(function ($) {
    var $allMaps = [];
    var GOOGLE_API_KEY = php_vars.key;
    
    var LitaeMaps = function ($scope, $) {
        $allMaps.push($scope.find('.litae-map-canvas')[0]);

        if (typeof google === 'object' && typeof google.maps === 'object') {
            initMap();
        }else{
            loadMaps();
        }
    };

    function initMap() {
        if(!$allMaps.length) {
            return;
        }
        
        $.each($allMaps, function(k,mapCanvas){
            
            var settings = $(mapCanvas).data('map_settings');

            var uluru = {lat: settings.lat, lng: settings.lng};
            
            var $divZoomIn  = $(mapCanvas).next('.zoom-in'),
                $divZoomOut = $(mapCanvas).next().next('.zoom-out');
                
            var map = new google.maps.Map(mapCanvas, {
                zoom: settings.zoom,
                mapTypeId: settings.mapTypeId,
                mapTypeControl: settings.mapTypeControl,
                center: uluru,
                draggable: false,
                scrollwheel: false,
                tilt: settings.tilt,
                streetViewControl: false,
                panControl: false,
                zoomControl: false,
                styles: $.parseJSON(settings.style)
            });
            var marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: false,
                icon: settings.icon
            });
            google.maps.event.addDomListener(window, "resize", function() {
                var center = map.getCenter();
                google.maps.event.trigger(map, "resize");
                map.setCenter(center); 
            });
            if( settings.zoom_controls ){
                var zoomControlDiv = document.createElement('div');
                zoomControlDiv.className = "zoom-wrapper "+ settings.zoom_position;
		var zoomControl = new CustomZoomControl(zoomControlDiv, map);
                
                var zoom_controls_position = settings.zoom_controls_position;
		//insert the zoom div on the top left of the map
                switch(zoom_controls_position){
                    case 'left-bottom':
                        map.controls[google.maps.ControlPosition.LEFT_BOTTOM].push(zoomControlDiv);
                        break;
                    case 'right-top':
                        map.controls[google.maps.ControlPosition.RIGHT_TOP].push(zoomControlDiv);
                        break;
                    case 'right-bottom':
                        map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(zoomControlDiv);
                        break;
                    default:
                        map.controls[google.maps.ControlPosition.LEFT_TOP].push(zoomControlDiv);
                }
            }
            //add custom buttons for the zoom-in/zoom-out on the map
            function CustomZoomControl(controlDiv, map) {
                //grap the zoom elements from the DOM and insert them in the map 
                var controlUIzoomIn= $divZoomIn[0],
                    controlUIzoomOut= $divZoomOut[0];
                controlDiv.appendChild(controlUIzoomIn);
                controlDiv.appendChild(controlUIzoomOut);

                // Setup the click event listeners and zoom-in or out according to the clicked element
                google.maps.event.addDomListener(controlUIzoomIn, 'click', function() {
                        map.setZoom(map.getZoom()+1)
                });
                google.maps.event.addDomListener(controlUIzoomOut, 'click', function() {
                        map.setZoom(map.getZoom()-1)
                });
            }
        });
        
        //clear array allMaps
        $allMaps = [];

    }
    

    var LitaeMapsEdit = function (panel, model, view) {
        //find search place element
        var $element = panel.$el.find('[data-setting="autocomplete"]');

        initAutocomplete($element[0]);
        
        function initAutocomplete(element) {
            // Create the autocomplete object, restricting the search to geographical
            // location types.
            autocomplete = new google.maps.places.Autocomplete(
                /** @type {!HTMLInputElement} */(element),
                {types: ['geocode']});
            // When the user selects an address from the dropdown, populate the address
            // fields in the form.
            autocomplete.addListener('place_changed', fillInAddress);
        }
        function fillInAddress() {
            var place = autocomplete.getPlace();
            var address = '',
                    lat = place.geometry.location.lat(),
                    lng = place.geometry.location.lng();
            if (place.address_components) {
              address = [
                (place.address_components[0] && place.address_components[0].short_name || ''),
                (place.address_components[1] && place.address_components[1].long_name || ''),
              ].join(' ');
            }
            model.setSetting('autocomplete', address, true);
            model.setSetting('lat', parseFloat( lat ), true);
            model.setSetting('lng', parseFloat( lng ), true);
        }

    };
    
   function loadMaps(){
        $.getScript("https://maps.googleapis.com/maps/api/js?key="+GOOGLE_API_KEY+"&libraries=places", function () {
            console.log('google maps api loaded');
            initMap();
        });
    }

    // Make sure you run this code under Elementor..
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/litae-maps.default', LitaeMaps);
        
        if ('undefined' !== typeof elementor) {
            //panel
            elementor.hooks.addAction('panel/open_editor/widget/litae-maps', LitaeMapsEdit);

        }
        
    });







})(jQuery);