<?php
/**
 * Plugin Name: Elementor Custom Elements
 * Description: Custom element added to Elementor
 * Plugin URI: http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
 * Version: 0.0.1
 * Author: dtbaker
 * Author URI: http://dtbaker.net
 * Text Domain: elementor-custom-element
 */

if (!defined('ABSPATH')){
    exit;
}

// This file is pretty much a boilerplate WordPress plugin.

class ElementorCustomElement {

    private static $instance = null;

    public static function get_instance() {
        if (!self::$instance){
            self::$instance = new self;
        }
            
        return self::$instance;
    }

    public function init() {
        // Add a custom category for panel widgets
        add_action('elementor/init', array($this, 'elementor_fully_loaded'));
        add_action('elementor/widgets/widgets_registered', array($this, 'widgets_registered'));
        add_action('elementor/element/before_section_end', array($this, 'action_before_section_end'), 10, 3);
        add_action('elementor/frontend/element/before_render', array($this, 'action_before_render_element'), 10, 1 );
        add_action('elementor/frontend/before_enqueue_scripts', function() {
            wp_enqueue_script( 'custom-widget', plugins_url( '/assets/js/custom-widget.js', __FILE__ ), [ 'jquery' ], false, true );
            wp_enqueue_script( 'letters', plugins_url( '/assets/js/letters.js', __FILE__ ), [ 'jquery' ], false, true );
            wp_enqueue_script( 'case-study', plugins_url( '/assets/js/case-study.js', __FILE__ ), [ 'jquery' ], false, true );
            wp_enqueue_script( 'litae-maps', plugins_url( '/assets/js/litae-maps.js', __FILE__ ), [ 'jquery' ], false, true );        
            //google maps
            $options = get_option( 'litae_options' );
            $google_api_key = ( $options && array_key_exists('google_api_key', $options) )? $options['google_api_key'] : '';
            $dataToBePassed = array(
                'key' => $google_api_key,
            );
            wp_localize_script( 'litae-maps', 'php_vars', $dataToBePassed );
        } );
        

    }

    public function elementor_fully_loaded()
    {
        //create Litae Widgets Category
        if (defined('ELEMENTOR_PATH') && class_exists('Elementor\Widget_Base')) {
            if (is_callable('Elementor\Plugin', 'instance')) {
                $elementor = Elementor\Plugin::instance();
                $elementor->elements_manager->add_category(
                        'litae-elements',
                        [
                        'title' => __( 'Litae Elements', 'litae' ),
                        'icon' => 'fa fa-plug', //default icon
                        ],
                        1 // position
                    );
            }
        }
    }


    public function widgets_registered() {
        //check Elementor plugin
        if( $this->checkElementorBase() && $this->checkElementorPlugin() ){
            //register litae widgets
            $elementor = Elementor\Plugin::instance();
            foreach ( self::get_widgets() as $widget_filename ) {
                include( dirname(__FILE__) . '/widgets/' . $widget_filename . '.php' );
                //capitalize class name letters
                $class_name = ucwords( str_replace( '-', ' ', $widget_filename ) );
                $class_name = str_replace(' ', '_', $class_name);
                $class_name = 'Elementor\Widget_' . $class_name;
                $elementor->widgets_manager->register_widget_type( new $class_name );
            }
        }    
    }
    
    public function checkElementorBase() {
        if (defined('ELEMENTOR_PATH') && class_exists('Elementor\Widget_Base')){
            return true;
        }
        return false;
    }
    
    public function checkElementorPlugin() {
        if (is_callable('Elementor\Plugin', 'instance')) {
            return true;
        }
        return false;
    }
    
    public static function get_widgets(){
        return [
            'testimonial-carousel',
            'text-box',
            'heading-reveal',
            'image-litae',
            'members-loop',
            'portfolios-loop',
            'posts-loop',
            'intro-slider',
            'text-rotator',
            'portfolios-case-study',
            'litae-maps',
            ];
    }
    
    public function action_before_section_end( $section, $section_id, $args ) {
        if( $section->get_name() == 'section' &&  $section_id == 'section_background' ){
            $this->add_parallax_on_section_background($section, $section_id, $args);
        }
    }
    
    public function add_parallax_on_section_background( $section, $section_id, $args ){
        $section->add_control(
            'is_parallax',
            [
                'label' => esc_html__( 'Parallax on BG image', 'your-plugin' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' =>  esc_html__( 'Show', 'litae_theme_plugins' ),
                'label_off' => esc_html__( 'Hide', 'litae_theme_plugins' ),
                'return_value' => 'yes',
            ]
        );
        $section->add_control(
            'parallax_speed' ,
            [
                'label'        => esc_html__( 'Parallax speed', 'litae_theme_plugins'  ),
                'type'         => Elementor\Controls_Manager::NUMBER,
                'default' => 0.4,
                'min'     => 0.1,
                'max'     => 1,
                'step'    => 0.1,
                'label_block'  => true,
                'condition' => [
                    'is_parallax' => 'yes'
                ]
            ]
        );
    }
    
    public function action_before_render_element($element){
        if ( $element->get_settings('parallax_speed') && $element->get_settings('is_parallax') ) {
            $this->add_section_parallax_attribute($element);
        }
    }
    
    public function add_section_parallax_attribute($element){
        $data = array(
            'xpos'  => '50%',
            'speed' => $element->get_settings('parallax_speed')
        );
        $element->add_render_attribute( '_wrapper', 'data-litae_parallax', json_encode($data) );
    }

}

ElementorCustomElement::get_instance()->init();
