<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Widget_Litae_Maps extends Widget_Base {
    
    public function get_name() {
        return 'litae-maps';
    }
    
    public function get_title() {
        return esc_html__( 'Litae Maps', 'elementor-custom-element' );
    }
    
    public function get_icon() {
        return 'fa fa-map-marker';
    }
    
    public function get_categories() {
        return [ 'litae-elements' ];
    }
    
    public function get_script_depends() {
        return [ 'jquery' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_editor',
            [
                'label' => esc_html__( 'Map', 'elementor-custom-element' ),
            ]
        );
        $this->add_control(
            'autocomplete',
            [
                'label' => esc_html__( 'Address', 'elementor-custom-element' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'html_msg1',
            [
               'type' => Controls_Manager::RAW_HTML,
               'raw'  => esc_html__( 'Get the coordinates of a place
Open Google Maps. If you\'re using Maps in Lite mode, you’ll see a lightning bolt at the bottom and you won\'t be able to get the coordinates of a place. Right-click the place or area on the map. Select What\'s here? At the bottom, you’ll see a card with the coordinates, click on it and paste Lat and Lng to fields respectively.', 'elementor-custom-element' ),
            ]
          );
        $this->add_control(
            'lat',
            [
                'label' => esc_html__( 'Lat', 'elementor-custom-element' ),
                'type' => Controls_Manager::TEXT,
                'default' => 43.726516,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'lng',
            [
                'label' => esc_html__( 'Lng', 'elementor-custom-element' ),
                'type' => Controls_Manager::TEXT,
                'default' => 20.674930,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'zoom',
            [
                'label' => __( 'Zoom Level', 'elementor-custom-element' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 17,
                'min'     => 1,
                'max'     => 20,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'height',
            [
                'label' => __( 'Map Height', 'elementor-custom-element' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 600,
                    'size_units' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    'vh' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => [ 'px', 'vh' ],
                'selectors' => [
                    '{{WRAPPER}} .litae-map-canvas' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__( 'Style map', 'elementor-custom-element' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'image',
            [
               'label' => esc_html__( 'Choose Icon Image', 'elementor-custom-element' ),
               'description' => esc_html__('If leave empty google default marker will be used', 'elementor-custom-element'),
               'type' => Controls_Manager::MEDIA,
               'default' => [
                  'url' => ''//Utils::get_placeholder_image_src(),
               ],
            ]
        );
        $this->add_control(
            'mapTypeId',
            [
               'label'       => esc_html__( 'Basic map types', 'elementor-custom-element' ),
               'type' => Controls_Manager::SELECT,
               'default' => 'roadmap',
               'options' => [
                   'roadmap'    => esc_html__( 'Roadmap', 'elementor-custom-element' ),
                   'satellite'  => esc_html__( 'Satellite', 'elementor-custom-element' ),
                   'hybrid'     => esc_html__( 'Hybrid', 'elementor-custom-element' ),
                   'terrain'    => esc_html__( 'Terrain', 'elementor-custom-element' ),
               ],
            ]
        );
        /*
        $this->add_control(
            'mapTypeControl',
            [
                'label' => esc_html__( 'Map Type Control', 'elementor-custom-element' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Show', 'elementor-custom-element' ),
                'label_off' => esc_html__( 'Hide', 'elementor-custom-element' ),
                'return_value' => 'yes',
            ]            
        );
        */
        $this->add_control(
            'tilt',
            [
                'label' => esc_html__( 'Map Tilt 45&#176;', 'elementor-custom-element' ),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__( 'Map Tilt only works on zoom set to 18+ and is not supported for all areas.', 'elementor-custom-element' ),
                'default' => '',
                'label_on' => esc_html__( 'Yes', 'elementor-custom-element' ),
                'label_off' => esc_html__( 'No', 'elementor-custom-element' ),
                'return_value' => 'yes',
                'condition' => [
                    'mapTypeId' => [ 'satellite', 'hybrid' ]
                ]
            ]            
        );
        $this->add_control(
            'map_theme',
            [
                'label' => esc_html__( 'Map Theme', 'elementor-custom-element' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'standard',
                'options' => [
                    'standard'  => esc_html__( 'Standard', 'elementor-custom-element' ),
                    'silver'    => esc_html__( 'Silver', 'elementor-custom-element' ),
                    'yellow'    => esc_html__( 'Yellow', 'elementor-custom-element' ),
                    'retro'     => esc_html__( 'Retro', 'elementor-custom-element' ),
                    'dark'      => esc_html__( 'Dark', 'elementor-custom-element' ),
                    'night'     => esc_html__( 'Night', 'elementor-custom-element' ),
                    'aubergine' => esc_html__( 'Aubergine', 'elementor-custom-element' ),
                 ],
                'separator' => 'before',

            ]
        );
        $this->add_control(
            'html_msg2',
            [
               'type' => Controls_Manager::RAW_HTML,
               'raw'  => 'If you want custom styles go to <a href="https://mapstyle.withgoogle.com/" target="_blank">https://mapstyle.withgoogle.com/</a> create a style for your map. Export to JSON and paste into Map Style field.',
            ]
          );
        $this->add_control(
            'map_style',
            [
               'label'   => esc_html__( 'Map Style', 'elementor-custom-element' ),
               'type'    => Controls_Manager::TEXTAREA,
               'rows'    => 4,
               'separator' => 'after',
               'default' => '',
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_style_control',
            [
                'label' => esc_html__( 'Map controls', 'elementor-custom-element' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'zoom_show',
            [
                'label' => esc_html__( 'Zoom controls', 'elementor-custom-element' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Yes', 'elementor-custom-element' ),
                'label_off' => esc_html__( 'No', 'elementor-custom-element' ),
                'return_value' => 'yes',
            ]            
        );
        $this->add_control(
            'zoom_color',
            [
                'label' => __( 'Zoom controls color', 'your-plugin' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .zoom-in, .zoom-out' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'zoom_position',
            [
                'label' => esc_html__( 'Zoom controls position', 'elementor-custom-element' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'left-top',
                'label_block' => true,
                'options' => [
                    'left-top'     => esc_html__( 'LEFT TOP', 'elementor-custom-element' ),
                    'left-bottom'  => esc_html__( 'LEFT BOTTOM', 'elementor-custom-element' ),
                    'right-top'    => esc_html__( 'RIGHT TOP', 'elementor-custom-element' ),
                    'right-bottom' => esc_html__( 'RIGHT BOTTOM', 'elementor-custom-element' ),
                 ],
            ]
        );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings = $this->get_settings();
        $address = $settings['autocomplete'];
        $mapTypeContol = false; //'yes' == $settings['mapTypeControl'] ? true : false;
        $tilt = 'yes' == $settings['tilt']? 45 : 0;
        $map_style = '' == trim($settings['map_style']) ? $this->getMapTheme($settings['map_theme']) : $settings['map_style'];
        $zoom_controls = 'yes' == $settings['zoom_show']? true : false;
        $zoom_controls_position = $settings['zoom_position'];
        $zoom_position = esc_attr( $settings['zoom_position']);

        $map_options = array(
            'lat' => floatval( $settings['lat'] ),
            'lng' => floatval( $settings['lng'] ),
            'zoom' => absint($settings['zoom']),
            'icon' => $settings['image']['url'],
            'mapTypeId' => $settings['mapTypeId'],
            'mapTypeControl' => $mapTypeContol,
            'tilt' => $tilt,
            'style'=> $map_style,
            'zoom_controls' => $zoom_controls,
            'zoom_controls_position' => $zoom_controls_position,
            'zoom_position' => $zoom_position,
        );
        $data_map_options = esc_attr( wp_json_encode( $map_options) );
        echo <<<HTML
<div class="litae-map-canvas" data-map_settings="{$data_map_options}">
</div>
<div class="zoom-in"></div>
<div class="zoom-out"></div>
HTML;
    }
    
    protected function _content_template() {
       
    }
    
    public function getMapTheme($key) {
        $arr = array(
            'standard'  => '[]',
            'silver'    => '[{"elementType":"geometry","stylers":[{"color":"#f5f5f5"}]},{"elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"elementType":"labels.text.fill","stylers":[{"color":"#616161"}]},{"elementType":"labels.text.stroke","stylers":[{"color":"#f5f5f5"}]},{"featureType":"administrative.land_parcel","elementType":"labels.text.fill","stylers":[{"color":"#bdbdbd"}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#eeeeee"}]},{"featureType":"poi","elementType":"labels.text.fill","stylers":[{"color":"#757575"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#e5e5e5"}]},{"featureType":"poi.park","elementType":"labels.text.fill","stylers":[{"color":"#9e9e9e"}]},{"featureType":"road","elementType":"geometry","stylers":[{"color":"#ffffff"}]},{"featureType":"road.arterial","elementType":"labels.text.fill","stylers":[{"color":"#757575"}]},{"featureType":"road.highway","elementType":"geometry","stylers":[{"color":"#dadada"}]},{"featureType":"road.highway","elementType":"labels.text.fill","stylers":[{"color":"#616161"}]},{"featureType":"road.local","elementType":"labels.text.fill","stylers":[{"color":"#9e9e9e"}]},{"featureType":"transit.line","elementType":"geometry","stylers":[{"color":"#e5e5e5"}]},{"featureType":"transit.station","elementType":"geometry","stylers":[{"color":"#eeeeee"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#c9c9c9"}]},{"featureType":"water","elementType":"labels.text.fill","stylers":[{"color":"#9e9e9e"}]}]',
            'yellow'    => '[{"elementType":"geometry","stylers":[{"color":"#f5f5f5"}]},{"elementType":"geometry.fill","stylers":[{"color":"#fcf652"},{"lightness":35},{"visibility":"on"}]},{"elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"elementType":"labels.text.fill","stylers":[{"visibility":"simplified"}]},{"elementType":"labels.text.stroke","stylers":[{"color":"#f5f5f5"}]},{"featureType":"administrative","elementType":"labels.text","stylers":[{"color":"#7f7f7f"},{"lightness":25}]},{"featureType":"administrative","elementType":"labels.text.fill","stylers":[{"visibility":"off"}]},{"featureType":"administrative.land_parcel","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"administrative.land_parcel","elementType":"labels.text.fill","stylers":[{"color":"#bdbdbd"}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#eeeeee"}]},{"featureType":"poi","elementType":"labels.text","stylers":[{"visibility":"off"}]},{"featureType":"poi","elementType":"labels.text.fill","stylers":[{"color":"#757575"}]},{"featureType":"poi.business","stylers":[{"visibility":"off"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#e5e5e5"}]},{"featureType":"poi.park","elementType":"labels.text.fill","stylers":[{"color":"#9e9e9e"}]},{"featureType":"road","elementType":"geometry","stylers":[{"color":"#7f40f1"}]},{"featureType":"road","elementType":"geometry.fill","stylers":[{"color":"#7f40f1"},{"lightness":70}]},{"featureType":"road","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"road.arterial","elementType":"labels.text.fill","stylers":[{"color":"#757575"}]},{"featureType":"road.highway","elementType":"geometry","stylers":[{"color":"#dadada"}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#f7f7f7"}]},{"featureType":"road.highway","elementType":"labels.text.fill","stylers":[{"color":"#616161"}]},{"featureType":"road.local","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"road.local","elementType":"labels.text.fill","stylers":[{"color":"#9e9e9e"}]},{"featureType":"transit","stylers":[{"visibility":"off"}]},{"featureType":"transit.line","elementType":"geometry","stylers":[{"color":"#e5e5e5"}]},{"featureType":"transit.station","elementType":"geometry","stylers":[{"color":"#eeeeee"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#c9c9c9"}]},{"featureType":"water","elementType":"geometry.fill","stylers":[{"color":"#f7f7f7"}]},{"featureType":"water","elementType":"labels.text.fill","stylers":[{"color":"#9e9e9e"}]}]',
            'retro'     => '[{"elementType":"geometry","stylers":[{"color":"#ebe3cd"}]},{"elementType":"labels.text.fill","stylers":[{"color":"#523735"}]},{"elementType":"labels.text.stroke","stylers":[{"color":"#f5f1e6"}]},{"featureType":"administrative","elementType":"geometry.stroke","stylers":[{"color":"#c9b2a6"}]},{"featureType":"administrative.land_parcel","elementType":"geometry.stroke","stylers":[{"color":"#dcd2be"}]},{"featureType":"administrative.land_parcel","elementType":"labels.text.fill","stylers":[{"color":"#ae9e90"}]},{"featureType":"landscape.natural","elementType":"geometry","stylers":[{"color":"#dfd2ae"}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#dfd2ae"}]},{"featureType":"poi","elementType":"labels.text.fill","stylers":[{"color":"#93817c"}]},{"featureType":"poi.park","elementType":"geometry.fill","stylers":[{"color":"#a5b076"}]},{"featureType":"poi.park","elementType":"labels.text.fill","stylers":[{"color":"#447530"}]},{"featureType":"road","elementType":"geometry","stylers":[{"color":"#f5f1e6"}]},{"featureType":"road.arterial","elementType":"geometry","stylers":[{"color":"#fdfcf8"}]},{"featureType":"road.highway","elementType":"geometry","stylers":[{"color":"#f8c967"}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#e9bc62"}]},{"featureType":"road.highway.controlled_access","elementType":"geometry","stylers":[{"color":"#e98d58"}]},{"featureType":"road.highway.controlled_access","elementType":"geometry.stroke","stylers":[{"color":"#db8555"}]},{"featureType":"road.local","elementType":"labels.text.fill","stylers":[{"color":"#806b63"}]},{"featureType":"transit.line","elementType":"geometry","stylers":[{"color":"#dfd2ae"}]},{"featureType":"transit.line","elementType":"labels.text.fill","stylers":[{"color":"#8f7d77"}]},{"featureType":"transit.line","elementType":"labels.text.stroke","stylers":[{"color":"#ebe3cd"}]},{"featureType":"transit.station","elementType":"geometry","stylers":[{"color":"#dfd2ae"}]},{"featureType":"water","elementType":"geometry.fill","stylers":[{"color":"#b9d3c2"}]},{"featureType":"water","elementType":"labels.text.fill","stylers":[{"color":"#92998d"}]}]',
            'dark'      => '[{"elementType":"geometry","stylers":[{"color":"#212121"}]},{"elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"elementType":"labels.text.fill","stylers":[{"color":"#757575"}]},{"elementType":"labels.text.stroke","stylers":[{"color":"#212121"}]},{"featureType":"administrative","elementType":"geometry","stylers":[{"color":"#757575"}]},{"featureType":"administrative.country","elementType":"labels.text.fill","stylers":[{"color":"#9e9e9e"}]},{"featureType":"administrative.land_parcel","stylers":[{"visibility":"off"}]},{"featureType":"administrative.locality","elementType":"labels.text.fill","stylers":[{"color":"#bdbdbd"}]},{"featureType":"poi","elementType":"labels.text.fill","stylers":[{"color":"#757575"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#181818"}]},{"featureType":"poi.park","elementType":"labels.text.fill","stylers":[{"color":"#616161"}]},{"featureType":"poi.park","elementType":"labels.text.stroke","stylers":[{"color":"#1b1b1b"}]},{"featureType":"road","elementType":"geometry.fill","stylers":[{"color":"#2c2c2c"}]},{"featureType":"road","elementType":"labels.text.fill","stylers":[{"color":"#8a8a8a"}]},{"featureType":"road.arterial","elementType":"geometry","stylers":[{"color":"#373737"}]},{"featureType":"road.highway","elementType":"geometry","stylers":[{"color":"#3c3c3c"}]},{"featureType":"road.highway.controlled_access","elementType":"geometry","stylers":[{"color":"#4e4e4e"}]},{"featureType":"road.local","elementType":"labels.text.fill","stylers":[{"color":"#616161"}]},{"featureType":"transit","elementType":"labels.text.fill","stylers":[{"color":"#757575"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#000000"}]},{"featureType":"water","elementType":"labels.text.fill","stylers":[{"color":"#3d3d3d"}]}]',
            'night'     => '[{"elementType":"geometry","stylers":[{"color":"#242f3e"}]},{"elementType":"labels.text.fill","stylers":[{"color":"#746855"}]},{"elementType":"labels.text.stroke","stylers":[{"color":"#242f3e"}]},{"featureType":"administrative.locality","elementType":"labels.text.fill","stylers":[{"color":"#d59563"}]},{"featureType":"poi","elementType":"labels.text.fill","stylers":[{"color":"#d59563"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#263c3f"}]},{"featureType":"poi.park","elementType":"labels.text.fill","stylers":[{"color":"#6b9a76"}]},{"featureType":"road","elementType":"geometry","stylers":[{"color":"#38414e"}]},{"featureType":"road","elementType":"geometry.stroke","stylers":[{"color":"#212a37"}]},{"featureType":"road","elementType":"labels.text.fill","stylers":[{"color":"#9ca5b3"}]},{"featureType":"road.highway","elementType":"geometry","stylers":[{"color":"#746855"}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#1f2835"}]},{"featureType":"road.highway","elementType":"labels.text.fill","stylers":[{"color":"#f3d19c"}]},{"featureType":"transit","elementType":"geometry","stylers":[{"color":"#2f3948"}]},{"featureType":"transit.station","elementType":"labels.text.fill","stylers":[{"color":"#d59563"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#17263c"}]},{"featureType":"water","elementType":"labels.text.fill","stylers":[{"color":"#515c6d"}]},{"featureType":"water","elementType":"labels.text.stroke","stylers":[{"color":"#17263c"}]}]',
            'aubergine' => '[{"elementType":"geometry","stylers":[{"color":"#1d2c4d"}]},{"elementType":"labels.text.fill","stylers":[{"color":"#8ec3b9"}]},{"elementType":"labels.text.stroke","stylers":[{"color":"#1a3646"}]},{"featureType":"administrative.country","elementType":"geometry.stroke","stylers":[{"color":"#4b6878"}]},{"featureType":"administrative.land_parcel","elementType":"labels.text.fill","stylers":[{"color":"#64779e"}]},{"featureType":"administrative.province","elementType":"geometry.stroke","stylers":[{"color":"#4b6878"}]},{"featureType":"landscape.man_made","elementType":"geometry.stroke","stylers":[{"color":"#334e87"}]},{"featureType":"landscape.natural","elementType":"geometry","stylers":[{"color":"#023e58"}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#283d6a"}]},{"featureType":"poi","elementType":"labels.text.fill","stylers":[{"color":"#6f9ba5"}]},{"featureType":"poi","elementType":"labels.text.stroke","stylers":[{"color":"#1d2c4d"}]},{"featureType":"poi.park","elementType":"geometry.fill","stylers":[{"color":"#023e58"}]},{"featureType":"poi.park","elementType":"labels.text.fill","stylers":[{"color":"#3C7680"}]},{"featureType":"road","elementType":"geometry","stylers":[{"color":"#304a7d"}]},{"featureType":"road","elementType":"labels.text.fill","stylers":[{"color":"#98a5be"}]},{"featureType":"road","elementType":"labels.text.stroke","stylers":[{"color":"#1d2c4d"}]},{"featureType":"road.highway","elementType":"geometry","stylers":[{"color":"#2c6675"}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#255763"}]},{"featureType":"road.highway","elementType":"labels.text.fill","stylers":[{"color":"#b0d5ce"}]},{"featureType":"road.highway","elementType":"labels.text.stroke","stylers":[{"color":"#023e58"}]},{"featureType":"transit","elementType":"labels.text.fill","stylers":[{"color":"#98a5be"}]},{"featureType":"transit","elementType":"labels.text.stroke","stylers":[{"color":"#1d2c4d"}]},{"featureType":"transit.line","elementType":"geometry.fill","stylers":[{"color":"#283d6a"}]},{"featureType":"transit.station","elementType":"geometry","stylers":[{"color":"#3a4762"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#0e1626"}]},{"featureType":"water","elementType":"labels.text.fill","stylers":[{"color":"#4e6d70"}]}]',
        );
        
        if( ''==$key || !array_key_exists($key, $arr) ){
            return [];
        }
        
        return $arr[$key];
    }
}
