<?php
namespace Elementor;

/**
 * Description of members-loop
 *
 * @author PC
 */
class Widget_Members_Loop extends Widget_Base {
    
    public function get_name() {
        return 'litae-members-loop';
    }
    
    public function get_title() {
        return esc_html__('Members loop', 'elementor-custom-element');
    }
    
    public function get_icon() {
        return 'fa fa-users';
    }

    public function get_categories() {
        return ['litae-elements'];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_members_loop',
                [
                    'label' => esc_html__('Members loop', 'elementor-custom-element'),
                ]
        );
        $this->add_control(
            'number_of_columns',
            [
               'label' => esc_html__( 'Number of columns', 'elementor-custom-element' ),
               'type' => Controls_Manager::SELECT,
               'default' => 'three',
               'options' => [
                  'six'   => esc_html__( 'Two', 'elementor-custom-element' ),
                  'four' => esc_html__( 'Three', 'elementor-custom-element' ),
                  'three'  => esc_html__( 'Four', 'elementor-custom-element' ),
               ]
            ]
        );
        $this->add_control(
            'linked',
                [
                    'label' => esc_html( 'Link image', 'elementor-custom-element' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => false,
                    'description' => esc_html__( 'Link image to team member single page.', 'elementor-custom-element' ),
                ]
        );
        $this->end_controls_section();
    }
    
    protected function render(){
        $settings = $this->get_settings();
        $columns = esc_attr($settings['number_of_columns']);
        $content = '';
        $loop = get_posts( array( 'post_type' => 'team_members', 'posts_per_page' => -1 ) );
        if ( $loop ) :
            foreach ($loop as $post) : setup_postdata( $post );
                $social_links = $this->fetch_social_links($post->ID);
                $social_html = '';
                if( !empty( $social_links ) ):
                    $social_html .= '<div class="social-team">';
                    $social_html .= '<ul class="list-social-team">';
                    foreach($social_links as $data):
                        $social_html .= '<li class="icon-team tipped" data-title="'.esc_attr( $data['title'] ).'" data-tipper-options=\'{"direction":"bottom","follow":"true","margin":25}\'>'
                            . '<a href="'.esc_url( $data['link'] ).'"><i class="fa '.esc_attr( $data['icon'] ).'"></i></a>'
                            . '</li>';
                    endforeach;
                    $social_html .= '</ul>';
                    $social_html .= '</div>';
                endif;
                $title     = esc_html( get_post_meta( $post->ID, 'name', true ) );
                $position  = esc_html( get_post_meta( $post->ID, 'position', true ) );
                $image_id  = (int) get_post_meta( $post->ID, 'image', true );
                $image     = $image_id ? wp_get_attachment_image($image_id, 'medium'):'';
                $permalink = get_permalink($post->ID);
                $linked_before = $settings['linked']=='on' ? '<a href="'.$permalink.'">' : '';
                $linked_after  = $settings['linked']=='on' ? '</a>' : '';
                $content  .= <<<HTML
<div class="{$columns} columns">
    <div class="team-wrap">
        {$linked_before}
        {$image}
        {$linked_after}
        <p>{$position}</p>
        <h6>{$title}</h6>
        {$social_html}
    </div>
</div>
HTML;
            endforeach;
        endif;

        wp_reset_postdata();
        

        echo <<<HTML
{$content}
HTML;
    }


    protected function _content_template() {
        
    }
    
    protected function fetch_social_links( $post_id ) {
        $return = [];
        $social_links = get_post_meta( $post_id, 'social', true );
        for( $i=0; $i < count( $social_links ); $i++):
            $icon = get_post_meta( $post_id, 'social_' . $i . '_icon', true );
            $return[] = array(
                'icon' => $icon,
                'title' => str_replace('fa-', '', $icon),
                'link' => get_post_meta( $post_id, 'social_' . $i . '_link', true ),
            );
        endfor;
        
        return $return;
    }
}
