<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ){
    exit; // Exit if accessed directly
}


class Widget_Portfolios_Loop extends Widget_Base  {
    
    public function get_name() {
        return 'litae-portfolios-loop';
    }
    
    public function get_title() {
        return esc_html__( 'Portfolios Loop', 'elementor-custom-element'  );
    }
    
    public function get_icon() {
        return 'fa fa-briefcase';
    }
    
    public function get_categories() {
        return ['litae-elements'];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_portfolio_filter',
            [
                'label' => esc_html__( 'Portfolio Filter', 'elementor-custom-element' ),
            ]
        );
        $this->add_control(
            'filter', 
            [
                'label' => esc_html__( 'Filter', 'elementor-custom-element' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'elementor-custom-element' ),
                'label_off' => esc_html__( 'Hide', 'elementor-custom-element'),
                'return_value' => 'yes'
            ]     
        );
        $this->add_control(
            'filter_font_family',
            [
                'label' => __( 'Font Family', 'elementor-custom-element' ),
                'type' => Controls_Manager::FONT,
                'default' => "Tenor Sans",
                'selectors' => [
                    '{{WRAPPER}} .filter li a' =>  'font-family: {{VALUE}}',
                 ],
                'condition' => [
                    'filter' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'filter_font_color',
            [
                'label' => esc_html__( 'Filter Font Color', 'elementor-custom-element' ),
                'description' => esc_html__( 'active & hover', 'elementor-custom-element' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .filter li a' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'filter' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'filter_border_color',
            [
                'label' => esc_html__( 'Filter Border Color', 'elementor-custom-element' ),
                'description' => esc_html__( 'active & hover', 'elementor-custom-element' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .filter li .current, .filter li a:hover' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'filter' => 'yes'
                ]
            ]
        );
        $this->add_responsive_control(
            'filter_align',
            [
                'label' => esc_html__( 'Alignment', 'elementor-custom-element'  ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementor-custom-element'  ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementor-custom-element'  ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementor-custom-element'  ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .portfolio-filter' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'filter' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'filter_gap',
            [
                'label' => esc_html__( 'Filter Gap (px)', 'elementor-custom-element' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 5,
                    'unit' => 'px'
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .filter li:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'filter' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'filter_font_size',
            [
                'label' => esc_html__( 'Filter Font Size (px)', 'elementor-custom-element' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 12,
                ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .filter li a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'filter' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'filter_font_line_height',
            [
                'label' => esc_html__( 'Filter Font Line Height (px)', 'elementor-custom-element' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 12,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .filter li a' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'filter' => 'yes'
                ]
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => __( 'Padding', 'elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'unit'   => 'px',
                    'top'    => '6',
                    'right'  => '14',
                    'bottom' => '6',
                    'left'   => '14'
                ],
                'selectors' => [
                    '{{WRAPPER}} .filter li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'filter' => 'yes'
                ]
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_portfolio_loop',
            [
                'label' => esc_html__( 'Portfolio Loop', 'elementor-custom-element' ),
            ]
        );
        $this->add_control(
            'loop_offset',
            [
               'label'       => esc_html__( 'Portfolios per page', 'elementor-custom-element' ),
               'type'    => Controls_Manager::NUMBER,
               'default' => 10,
               'min'     => 1,
               'max'     => 20,
               'step'    => 1,
            ]
        );
        $this->add_control(
        'loop_columns',
            [
               'label'=> esc_html__( 'Number of columns', 'elementor-custom-element' ),
               'type' => Controls_Manager::SELECT,
               'default' => 'half-width',
               'options' => [
                  'half-width'  => esc_html__( '2 columns', 'elementor-custom-element' ),
                  'third-width'  => esc_html__( '3 columns', 'elementor-custom-element' ),
               ],
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Actually its `image_size`
                'label' => esc_html__( 'Image Size', 'elementor-custom-element'  ),
                'default' => 'large',
            ]
        );
        /*
        *  RevealFx
        */
        $this->add_control(
            'is_effect',
                [
                    'label' => esc_html( 'Reveal effect', 'elementor-custom-element' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => false,
                ]
        );
        $this->add_control(
            'image_animation_color',
                [
                   'label' => esc_html__( 'Image animation color', 'elementor-custom-element' ),
                    'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'condition' => [
                        'is_effect' => 'on'
                    ]
                ]
        );
        $this->add_control(
            'image_animation_direction',
                [
                   'label' => esc_html__( 'Image animation direction', 'elementor-custom-element' ),
                   'type' => Controls_Manager::SELECT,
                   'label_block' => true,
                   'options' => [
                      'lr' => esc_html__( 'Left to right', 'elementor-custom-element' ),
                      'rl' => esc_html__( 'Right to left', 'elementor-custom-element' ),
                      'tb' => esc_html__( 'Top to bottom', 'elementor-custom-element' ),
                      'bt' => esc_html__( 'Bottom to top', 'elementor-custom-element' ),
                   ],
                   'default' => 'lr',
                   'multiple' => false,
                   'condition' => [
                       'is_effect' => 'on'
                   ]
                ]
        );
        $this->add_control(
            'image_animation_delay',
            [
                'label' => __( 'Image animation delay', 'elementor-custom-element' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 250,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                        'step' => 10,
                    ],
                ],
                'size_units' => [ 'px' ],
                'condition' => [
                    'is_effect' => 'on'
                ]
            ]
        );
        $this->add_control(
            'text_animation_color',
                [
                   'label' => esc_html__( 'Text animation color', 'elementor-custom-element' ),
                   'label_block' => true,
                   'type' => Controls_Manager::COLOR,
                    'scheme' => [
                        'type' => Scheme_Color::get_type(),
                        'value' => Scheme_Color::COLOR_1,
                    ],
                    'condition' => [
                        'is_effect' => 'on'
                    ]
                ]
        );
        $this->add_control(
            'text_animation_direction',
                [
                   'label' => esc_html__( 'Text animation direction', 'elementor-custom-element' ),
                   'type' => Controls_Manager::SELECT,
                   'label_block' => true,
                   'options' => [
                      'lr' => esc_html__( 'Left to right', 'elementor-custom-element' ),
                      'rl' => esc_html__( 'Right to left', 'elementor-custom-element' ),
                      'tb' => esc_html__( 'Top to bottom', 'elementor-custom-element' ),
                      'bt' => esc_html__( 'Bottom to top', 'elementor-custom-element' ),
                   ],
                   'default' => 'rl',
                   'multiple' => false,
                   'condition' => [
                       'is_effect' => 'on'
                   ]
                ]
        );
        $this->add_control(
            'text_animation_delay',
            [
                'label' => __( 'Text animation delay', 'elementor-custom-element' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 250,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                        'step' => 10,
                    ],
                ],
                'size_units' => [ 'px' ],
                'condition' => [
                    'is_effect' => 'on'
                ]
            ]
        );
        /*
         * end RevealFx
         */
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_portfolio_navigation',
            [
                'label' => esc_html__( 'Portfolio navigation', 'elementor-custom-element' ),
            ]
        );
        $this->add_control(
            'previous_post',
            [
               'label'       => esc_html__( 'Previous', 'elementor-custom-element' ),
               'type'        => Controls_Manager::TEXT,
               'default'     => esc_html__( 'Newer', 'elementor-custom-element' ),
               'placeholder' => esc_html__( 'Previous posts label', 'elementor-custom-element' ),
            ]
         );
        $this->add_control(
            'next_post',
            [
               'label'       => esc_html__( 'Next', 'elementor-custom-element' ),
               'type'        => Controls_Manager::TEXT,
               'default'     => esc_html__( 'Older', 'elementor-custom-element' ),
               'placeholder' => esc_html__( 'Next posts label', 'elementor-custom-element' ),
            ]
         );
        $this->end_controls_section();
    }
    
    protected function render() {
        
        $settings = $this->get_settings();
 
        $filter_html = '';
        
        $terms = $this->getPortfolioTagsObject();
        
        $is_effect = ($settings['is_effect']!='on')? false : true;
        $watcher = $is_effect? 'watcher' : '';
        $image_animation_color = esc_attr( $settings['image_animation_color'] );
        $image_animation_direction = esc_attr( $settings['image_animation_direction'] );
        $image_animation_delay = absint( $settings['image_animation_delay'] );
        $text_animation_color = esc_attr( $settings['text_animation_color'] );
        $text_animation_direction = esc_attr( $settings['text_animation_direction'] );
        $text_animation_delay = absint( $settings['text_animation_delay'] );
        
        $image_animation_settings = [
            'bgcolor'   => $image_animation_color,
            'direction' => $image_animation_direction,
            'delay'     => $image_animation_delay,
        ];

        $image_rev_settings = esc_attr( wp_json_encode( $image_animation_settings ) );
        
        $text_animation_settings = [
            'bgcolor'   => $text_animation_color,
            'direction' => $text_animation_direction,
            'delay'     => $text_animation_delay,
        ];

        $text_rev_settings = esc_attr( wp_json_encode( $text_animation_settings ) );

        
        if( 'yes' == $settings['filter'] && ! empty( $terms ) ){
            
            $tags = $this->getTagsArray($terms);
            
            $filter_html .= <<<HTML
<div class="portfolio-filter">
    <ul class="filter">
        <li><a href="#" class="current" data-filter="*" title="">all</a></li>
HTML;
        foreach ($tags as $tag ):
            $filter_html .= '<li class="tipped" data-title="'.$tag['name']. ' '. $tag['count'].'" data-tipper-options=\'{"direction":"top","follow":"true","margin":35}\'><a href="#" data-filter=".'. $tag['slug'] .'">'. $tag['name'] .'</a></li>';
        endforeach;
            
            $filter_html .= <<<HTML
    </ul>
</div>
HTML;
        }
        
        echo <<<HTML
{$filter_html}
<div class="blog-container">
HTML;
        $portfolio_content = '';
        global $paged;
        if (get_query_var('paged')) {
            $paged = get_query_var('paged');
        } elseif (get_query_var('page')) {
            $paged = get_query_var('page');
        } else {
            $paged = 1;
        }
        $loop = new \WP_Query( array( 'post_type' => 'portfolio', 'posts_per_page' => (int)$settings['loop_offset'], 'paged' => $paged ) );
        while ( $loop->have_posts() ) : $loop->the_post();
            $terms = wp_get_object_terms( get_the_ID(), 'portfolio_tag' );
            $tags_list_name = '';
            $tags_list_class = '';
            if( ! empty($terms) && ! is_wp_error($terms) ){
                $tags = $this->getTagsArray($terms);
                $tags_list_name  .= esc_html( $this->getTagsList($tags,'name') );
                $tags_list_class .= esc_attr( $this->getTagsList($tags,'slug') );
            }
            $portfolio_content .= '<a href="'. get_permalink().'">';
            $portfolio_content .= '<div class="portfolio-box-1 grid-item '.esc_attr( $settings['loop_columns'] ) .' '. $tags_list_class.'">';
            if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
                $portfolio_content .= '<div class="content__image-wrap '.$watcher.' '.$image_animation_color.'" data-rev-settings="'.$image_rev_settings.'">';
                $attachment_id = get_post_thumbnail_id( get_the_ID() );
                $image_src = Group_Control_Image_Size::get_attachment_image_src( $attachment_id, 'image', $settings );
                $portfolio_content .= '<img src="' .  esc_attr($image_src) . '" alt="' .get_the_title() . '">';
                $portfolio_content .= '</div>';
            }
            if ( '' != $tags_list_name ){
                $portfolio_content .= '<div class="work-subtitle '.$watcher.'" data-rev-settings="'.$text_rev_settings.'">';
                $portfolio_content .= $this->limitWords($tags_list_name, 3);
                $portfolio_content .= '</div><br>';
            }
            $portfolio_content .= '<div class="work-title '.$watcher.'" data-rev-settings="'.$text_rev_settings.'">';
            $portfolio_content .= get_the_title();
            $portfolio_content .= '</div>';
            $portfolio_content .= '</div>';
            $portfolio_content .= '</a>';
        endwhile;
        //get portfolio navigation
        $pagination = litae_get_the_posts_navigation( $loop, array( 'prev_label' => $settings['previous_post'], 'next_label' => $settings['next_post'] ) );
        wp_reset_postdata();
        wp_reset_query();
    
        echo <<<HTML
{$portfolio_content}
</div>
<div class="clearfix"></div>
{$pagination}
HTML;
        

    }
    
    protected function _content_template() {
        
    }
    
    protected function getPortfolioTagsObject() {
        $return = array();
        $terms = get_terms( array(
            'taxonomy' => 'portfolio_tag',
            'hide_empty' => false,
            'orderby' => 'count',
            'order'   => 'desc',
        ) );
        if ( !empty( $terms ) && !is_wp_error( $terms ) ){
            $return = $terms;
        }
        
        return $terms;
    }
    
    protected function getTagsArray($terms) {
        $return = array();
        foreach( $terms as $term ):
            $return[] = [
                'slug'  => $term->slug,
                'name'  => $term->name,
                'count' => $term->count
            ];
        endforeach;
        
        return $return;
    }
    
    protected function  getTagsList($tags, $selector='name', $separator=' ') {
        $return = '';
        foreach( $tags as $tag ):
            $return .= $tag[$selector] . $separator;
        endforeach;
        
        return $return;
    }
    
    protected function limitWords($string, $word_limit=3) {
        $words = explode(" ",$string);
        return implode(" ",array_splice($words,0,$word_limit));
    }
}
