<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ){
    exit; // Exit if accessed directly
}


class Widget_Posts_Loop extends Widget_Base  {
    
    public function get_name() {
        return 'litae-posts-loop';
    }
    
    public function get_title() {
        return esc_html__( 'Posts Loop', 'elementor-custom-element'  );
    }
    
    public function get_icon() {
        return 'fa fa-wordpress';
    }
    
    public function get_categories() {
        return ['litae-elements'];
    }
    
    protected function _register_controls() {
        
        $this->start_controls_section(
            'section_portfolio_loop',
            [
                'label' => esc_html__( 'Posts Loop', 'elementor-custom-element' ),
            ]
        );
        $this->add_control(
            'loop_offset',
            [
               'label'       => esc_html__( 'Posts per page', 'elementor-custom-element' ),
               'type'    => Controls_Manager::NUMBER,
               'default' => 10,
               'min'     => 1,
               'max'     => 20,
               'step'    => 1,
            ]
        );
        $this->add_control(
        'loop_columns',
            [
               'label'=> esc_html__( 'Number of columns', 'elementor-custom-element' ),
               'type' => Controls_Manager::SELECT,
               'default' => 'half-width',
               'options' => [
                  'half-width'  => esc_html__( '2 columns', 'elementor-custom-element' ),
                  'third-width'  => esc_html__( '3 columns', 'elementor-custom-element' ),
               ],
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Actually its `image_size`
                'label' => esc_html__( 'Image Size', 'elementor-custom-element'  ),
                'default' => 'large',
            ]
        );
        $this->add_control(
            'columns_bg_color',
            [
                'label' => __( 'Columns background color', 'elementor-custom-element' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-in' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'pages_label',
            [
               'label'       => esc_html__( 'Post pages label', 'elementor-custom-element' ),
               'type'        => Controls_Manager::TEXT,
               'default'     => esc_html__( 'Pages', 'elementor-custom-element' ),
               'placeholder' => esc_html__( 'Post pages label', 'elementor-custom-element' ),
            ]    
        );
        /*
        *  RevealFx
        */
        $this->add_control(
        'is_effect',
            [
                'label' => esc_html( 'Reveal effect', 'elementor-custom-element' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => false,
            ]
        );
        $this->add_control(
            'animation_color',
            [
                'label' => __( 'Animation Color', 'elementor-custom-element' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'condition' => [
                    'is_effect' => 'on'
                ]
            ]
        );
        $this->add_control(
            'animation_direction',
                [
                   'label' => esc_html__( 'Animation direction', 'elementor-custom-element' ),
                   'type' => Controls_Manager::SELECT,
                   'label_block' => true,
                   'options' => [
                      'lr' => esc_html__( 'Left to right', 'elementor-custom-element' ),
                      'rl' => esc_html__( 'Right to left', 'elementor-custom-element' ),
                      'tb' => esc_html__( 'Top to bottom', 'elementor-custom-element' ),
                      'bt' => esc_html__( 'Bottom to top', 'elementor-custom-element' ),
                   ],
                   'default' => 'lr',
                   'multiple' => false,
                   'condition' => [
                       'is_effect' => 'on'
                   ]
                ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => __( 'Animation delay', 'elementor-custom-element' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 250,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                        'step' => 10,
                    ],
                ],
                'size_units' => [ 'px' ],
                'condition' => [
                    'is_effect' => 'on'
                ]
            ]
        );
        /*
         * end RevealFx
         */
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_portfolio_navigation',
            [
                'label' => esc_html__( 'Posts navigation', 'elementor-custom-element' ),
            ]
        );
        $this->add_control(
            'previous_post',
            [
               'label'       => esc_html__( 'Previous', 'elementor-custom-element' ),
               'type'        => Controls_Manager::TEXT,
               'default'     => esc_html__( 'Newer', 'elementor-custom-element' ),
               'placeholder' => esc_html__( 'Previous posts label', 'elementor-custom-element' ),
            ]
         );
        $this->add_control(
            'next_post',
            [
               'label'       => esc_html__( 'Next', 'elementor-custom-element' ),
               'type'        => Controls_Manager::TEXT,
               'default'     => esc_html__( 'Older', 'elementor-custom-element' ),
               'placeholder' => esc_html__( 'Next posts label', 'elementor-custom-element' ),
            ]
         );
        $this->end_controls_section();
    }
    
    protected function render() {

        $settings = $this->get_settings();
        $is_effect = ($settings['is_effect']!='on')? false : true;
        $watcher = $is_effect? 'watcher' : '';
        $animation_settings = [
            'bgcolor'     => $settings['animation_color'],
            'direction' => $settings['animation_direction'],
            'delay'     => absint( $settings['animation_delay']['size'] ),
        ];

        $data_rev_settings = esc_attr( wp_json_encode( $animation_settings ) );
        
        echo <<<HTML
<div class="blog-container">
HTML;
        global $paged;
        if (get_query_var('paged')) {
            $paged = get_query_var('paged');
        } elseif (get_query_var('page')) {
            $paged = get_query_var('page');
        } else {
            $paged = 1;
        }
        $loop = new \WP_Query( array( 'post_type' => 'post', 'posts_per_page' => (int)$settings['loop_offset'], 'paged' => $paged ) );
        while ( $loop->have_posts() ) : $loop->the_post();
        $loop_columns = esc_attr( $settings['loop_columns'] );
        $post_class = is_sticky()? implode(' ',get_post_class('sticky')) : implode(' ',get_post_class());
        $attachment_id = get_post_thumbnail_id( $loop->ID );
        $image_src = Group_Control_Image_Size::get_attachment_image_src( $attachment_id, 'image', $settings );
        $post_img  = ('' != $image_src)?  '<img src="' .  esc_attr($image_src) . '" alt="' .get_the_title() . '">' : '';
        
        $title = '<a href="'. esc_url(get_permalink()) .'" rel="bookmark"><h2 class="entry-title">'.  get_the_title() .'</h2></a>';
        $posted_on  = litae_posted_on(false);
        $read_more = '<a href="'. esc_url(get_permalink()) .'"><div class="blog-link">'. esc_html__('read more', 'litae') .'</div></a>';
        $pages_label = $settings['pages_label'];
        echo <<<HTML
<div class="blog-box grid-item {$loop_columns} {$watcher}" data-rev-settings="{$data_rev_settings}">
    <div class="{$post_class}">
        <div class="content-in">
            {$post_img}
            <header class="entry-header">
            {$title}
            <div class="entry-meta">
            {$posted_on}
            </div>
            </header>
            <div class="entry-content margin-top-25px">
HTML;

        if( has_excerpt($loop->ID) ){ echo get_the_excerpt();}else{ the_excerpt();}
        wp_link_pages(array(
            'before' => '<div class="page-links">' . esc_html($pages_label),
            'after' => '</div>',
        ));
        echo <<<HTML
            </div>
            <footer class="entry-footer">
HTML;
        litae_entry_footer();
        echo <<<HTML
            </footer>
            {$read_more}
        </div>
    </div>
</div>
HTML;
        endwhile;
        //get portfolio navigation
        $pagination = litae_get_the_posts_navigation( $loop, array( 'prev_label' => $settings['previous_post'], 'next_label' => $settings['next_post'] ) );
        wp_reset_postdata();
        wp_reset_query();
    
        echo <<<HTML
</div>
{$pagination}
HTML;
        

    }
    
    protected function _content_template() {
        
    }
    
    protected function getPortfolioTagsObject() {
        $return = array();
        $terms = get_terms( array(
            'taxonomy' => 'portfolio_tag',
            'hide_empty' => false,
            'orderby' => 'count',
            'order'   => 'desc',
        ) );
        if ( !empty( $terms ) && !is_wp_error( $terms ) ){
            $return = $terms;
        }
        
        return $terms;
    }
    
    protected function getTagsArray($terms) {
        $return = array();
        foreach( $terms as $term ):
            $return[] = [
                'slug'  => $term->slug,
                'name'  => $term->name,
                'count' => $term->count
            ];
        endforeach;
        
        return $return;
    }
    
    protected function  getTagsList($tags, $selector='name', $separator=' ') {
        $return = '';
        foreach( $tags as $tag ):
            $return .= $tag[$selector] . $separator;
        endforeach;
        
        return $return;
    }
    
    protected function limitWords($string, $word_limit=3) {
        $words = explode(" ",$string);
        return implode(" ",array_splice($words,0,$word_limit));
    }
}
