<?php

/*
 * Plugin Name: Litae Theme Plugin
 * Description: 
 * Version: 1.0
 * Author: Zarioza
 * Author URI: https://themeforest.net/user/zarioza
 * Text Domain: litae-theme-plugin
 */

if (!defined('ABSPATH')) {
    die('-1');
}

add_action('init', 'litae_theme_plugins');

function litae_theme_plugins() {
    
}

/*
 * Redux
 */
add_action('plugins_loaded', 'litae_load_plugins');

function litae_load_plugins() {

    /*
     * Redux
     */
    // Load the embedded Redux Framework
    if (!class_exists('ReduxFramework') && file_exists(dirname(__FILE__) . '/libs/ReduxFramework/redux-framework/framework.php')) {
        require_once( dirname(__FILE__) . '/libs/ReduxFramework/redux-framework/framework.php' );
    }
    // Load the theme/plugin options
    if (!isset($redux_demo) && file_exists(dirname(__FILE__) . '/libs/ReduxFramework/litae-init.php')) {
        require_once( dirname(__FILE__) . '/libs/ReduxFramework/litae-init.php' );
    }
    // Load Redux extensions
    if (file_exists(dirname(__FILE__) . '/libs/ReduxFramework/redux-extensions/extensions-init.php')) {
        require_once dirname(__FILE__) . '/libs/ReduxFramework/redux-extensions/extensions-init.php';
    }

    /*
     * lessphp v0.5.0
     */
    if (!class_exists('lessc') && file_exists(dirname(__FILE__) . '/lessc.inc.php')) {
        require_once( dirname(__FILE__) . '/lessc.inc.php' );
    }

    /*
     * Elementor Widgets
     */
    include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
    if (is_plugin_active('elementor/elementor.php')) {
        require_once( dirname(__FILE__) . '/libs/litae-elementor-widgets/elementor-custom-element.php' );
    }

    if (is_plugin_active('advanced-custom-fields-pro/acf.php')) {
        require_once( dirname(__FILE__) . '/libs/advanced-custom-fields-font-awesome/acf-font-awesome.php' );
    }
}

/*
 * cpt
 */

function litae_register_my_cpts() {

    /**
     * Post Type: Team Members.
     */
    $labels = array(
        "name" => __('Team Members', 'litae'),
        "singular_name" => __('Team Member', 'litae'),
    );

    $args = array(
        "label" => __('Team Members', 'litae'),
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "publicly_queryable" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "rest_base" => "",
        "has_archive" => false,
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array("slug" => "team-members", "with_front" => true),
        "query_var" => true,
        "supports" => array("title", "editor", "thumbnail"),
    );

    register_post_type("team_members", $args);

    /**
     * Post Type: Portfolios.
     */
    $labels = array(
        "name" => __('Portfolios', 'litae'),
        "singular_name" => __('Portfolio', 'litae'),
    );

    $args = array(
        "label" => __('Portfolios', 'litae'),
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "publicly_queryable" => true,
        "show_ui" => true,
        "show_in_rest" => false,
        "rest_base" => "",
        "has_archive" => false,
        "show_in_menu" => true,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "rewrite" => array("slug" => "portfolio", "with_front" => true),
        "query_var" => true,
        "supports" => array("title", "editor", "thumbnail", "comments"),
    );

    register_post_type("portfolio", $args);
}

add_action('init', 'litae_register_my_cpts');

function litae_register_my_taxes() {

    /**
     * Taxonomy: Portfolio Tags.
     */
    $labels = array(
        "name" => __('Portfolio Tags', 'litae'),
        "singular_name" => __('Portfolio Tag', 'litae'),
    );

    $args = array(
        "label" => __('Portfolio Tags', 'litae'),
        "labels" => $labels,
        "public" => true,
        "hierarchical" => false,
        "label" => "Portfolio Tags",
        "show_ui" => true,
        "show_in_menu" => true,
        "show_in_nav_menus" => true,
        "query_var" => true,
        "rewrite" => array('slug' => 'portfolio_tag', 'with_front' => true,),
        "show_admin_column" => false,
        "show_in_rest" => false,
        "rest_base" => "",
        "show_in_quick_edit" => false,
    );
    register_taxonomy("portfolio_tag", array("portfolio"), $args);
}

add_action('init', 'litae_register_my_taxes');
