<?php
/*
  Plugin Name: Helpmate Latest Tweets
  Plugin URI:
  Description: Helpmate Latest Tweets for helpmate theme.
  Version: 1.0.0
  Author: AHT
  Author URI:
 */

if (!defined('ABSPATH'))
    die('-1');

require_once dirname(__FILE__) . '/settings.php';
require_once dirname(__FILE__) . '/api/Abraham/TwitterOAuth/TwitterOAuth.php';
require_once dirname(__FILE__) . '/widget.php';

class HelpmateLatestTweet {

    function __construct() {
        // Load text domain
        add_action('plugins_loaded', array($this, 'load_text_domain'));
    }
    
    // load plugin text domain
    public function load_text_domain() {
        load_plugin_textdomain('helpmate', false, dirname(__FILE__) . '/languages/');
    }

    public function get_tweets($number_tweets) {
        # Define constants
        $options = get_option('helpmate_latest_tweet');
        $username = $options['username'];
        $consumer_key = $options['consumer_key'];
        $consumer_secret = $options['consumer_secret'];
        $access_token = $options['access_token'];
        $access_token_secret = $options['access_token_secret'];
        if(empty($username) || empty($consumer_key) || empty($consumer_secret) 
                || empty($access_token) || empty($access_token_secret)) {
            return false;
        }
        # Create the connection
        $twitter = new TwitterOAuth($consumer_key, $consumer_secret, $access_token, $access_token_secret);
        # Migrate over to SSL/TLS
        $twitter->ssl_verifypeer = false;
        # Load the Tweets
        try {
            $tweets = $twitter->get('statuses/user_timeline', array('screen_name' => $username, 'exclude_replies' => 'true', 'include_rts' => 'false', 'count' => $number_tweets));
            # Example output
            //echo '<pre>';print_r($tweets);die();
            if (!empty($tweets)) {
                echo '<div id="twitter" class="twitter"><ul class="tweet_list">';
                foreach($tweets as $_tweet) {
                    // actual tweet as a string
                    $tweetText = $_tweet->text;
                 
                    // create an array to hold urls
                    $tweetEntites = array();
                 
                    // add each url to the array
                    foreach( $_tweet->entities->urls as $url ) {
                        $tweetEntites[] = array (
                                'type'    => 'url',
                                'curText' => substr( $tweetText, $url->indices[0], ( $url->indices[1] - $url->indices[0] ) ),
                                'newText' => "<a href='".$url->expanded_url."' target='_blank'>".$url->display_url."</a>"
                            );
                    }  // end foreach
                 
                    // add each user mention to the array
                    foreach ( $_tweet->entities->user_mentions as $mention ) {
                        $string = substr( $tweetText, $mention->indices[0], ( $mention->indices[1] - $mention->indices[0] ) );
                        $tweetEntites[] = array (
                                'type'    => 'mention',
                                'curText' => substr( $tweetText, $mention->indices[0], ( $mention->indices[1] - $mention->indices[0] ) ),
                                'newText' => "<a href='http://twitter.com/".$mention->screen_name."' target='_blank'>".$string."</a>"
                            );
                    }  // end foreach
                 
                    // add each hashtag to the array
                    foreach ( $_tweet->entities->hashtags as $tag ) {
                        $string = substr( $tweetText, $tag->indices[0], ( $tag->indices[1] - $tag->indices[0] ) );
                        $tweetEntites[] = array (
                                'type'    => 'hashtag',
                                'curText' => substr( $tweetText, $tag->indices[0], ( $tag->indices[1] - $tag->indices[0] ) ),
                                'newText' => "<a href='http://twitter.com/search?q=%23".$tag->text."&src=hash' target='_blank'>".$string."</a>"
                            );
                    }  // end foreach
                 
                    // replace the old text with the new text for each entity
                    foreach ( $tweetEntites as $entity ) {
                        $tweetText = str_replace( $entity['curText'], $entity['newText'], $tweetText );
                    } // end foreach
                 
                    $user = $_tweet->user;
                    $handle = $user->screen_name;
                    $id_str = $_tweet->id_str;
                    $link = esc_html( 'http://twitter.com/'.$handle.'/status/'.$id_str);
                    $date = DateTime::createFromFormat('D M d H:i:s O Y', $_tweet->created_at );
                    $output ='<li>';
                    $output .= '<div class="twitter-tweet"><div class ="tweet-text">'. $tweetText.'<p class="my-date">'.esc_attr($date->format('M j, Y g:i A')).'</p></div>';
                    $output .= '</div></li>';
                    echo $output;
                }
                echo '</ul></div>';
            }
        } catch (Exception $exc) {
            echo esc_html__('Something wrong, please check the connection or the api config!');
        }

        return null;
    }
}
