<?php

/*
  Plugin Name: Helpmate Post Types
  Plugin URI:
  Description: Register Post Types for helpmate Theme.
  Version: 1.0.0
  Author: AHT
  Author URI:
 */

// don't load directly
if (!defined('ABSPATH'))
    die('-1');

class HelpmatePostTypes {

    function __construct() {

        // Load text domain
        add_action('plugins_loaded', array($this, 'loadTextDomain'));

        // Register post types
        add_action('init', array($this, 'addGalleryPostType'));
        add_action('init', array($this, 'addMemberPostType'));
        add_action('init', array($this, 'addTestimonialPostType'));
        add_action('init', array($this, 'addBlockPostType'));
        add_action('init', array($this, 'addOfficePostType'));
        add_action('init', array($this, 'addClientsPostType'));
    }
    // Register gallery post type
    function addGalleryPostType() {
        register_post_type(
            'gallery', array(
            'labels' => $this->getLabels(esc_html__('Gallery', 'helpmate'), esc_html__('Gallery', 'helpmate')),
            'exclude_from_search' => false,
            'has_archive' => true,
            'public' => true,
            'rewrite' => array('slug' => 'gallery'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );

        register_taxonomy(
            'gallery_cat', 'gallery', array(
            'hierarchical' => true,
            'show_in_nav_menus' => true,
            'labels' => $this->getTaxonomyLabels(esc_html__('Gallery Category', 'helpmate'), esc_html__('Gallery Categories', 'helpmate')),
            'query_var' => true,
            'rewrite' => true
            )
        );
        register_taxonomy(
            'gallery_skills',
            'gallery',
            array(
                'hierarchical' => false,
                'show_in_nav_menus' => true,
                'labels' => $this->getTaxonomyLabels(esc_html__('Gallery Skill', 'helpmate'), esc_html__('Gallery Skills', 'helpmate')),
                'query_var' => true,
                'rewrite' => true
            )
        );
        register_taxonomy(
            'gallery_tags',
            'gallery',
            array(
                'hierarchical' => false,
                'show_in_nav_menus' => true,
                'labels' => $this->getTaxonomyLabels(esc_html__('Gallery Tag', 'helpmate'), esc_html__('Gallery Tags', 'helpmate')),
                'query_var' => true,
                'rewrite' => true
            )
        );
    }

    // Register testimonial post type
    function addTestimonialPostType() {
        register_post_type(
            'testimonial', array(
            'labels' => $this->getLabels(esc_html__('Testimonial', 'helpmate'), esc_html__('Testimonials', 'helpmate')),
            'exclude_from_search' => true,
            'has_archive' => false,
            'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => 'testimonial'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
    }
    // Register static block post type
    function addBlockPostType() {
        register_post_type(
            'block', array(
            'labels' => $this->getLabels(esc_html__('Static Block', 'helpmate'), esc_html__('Static Block', 'helpmate')),
            'exclude_from_search' => true,
            'has_archive' => false,
            'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => 'block'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
    }

    // Register member post type
    function addMemberPostType() {
        register_post_type(
            'member', array(
            'labels' => $this->getLabels(esc_html__('Member', 'helpmate'), esc_html__('Members', 'helpmate')),
            'exclude_from_search' => true,
            'has_archive' => false,
            'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => 'member'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
    }
    // Register member post type
    function addOfficePostType() {
        register_post_type(
            'office', array(
            'labels' => $this->getLabels(esc_html__('Office', 'helpmate'), esc_html__('Office', 'helpmate')),
            'exclude_from_search' => true,
            'has_archive' => false,
            'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => 'office'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
    }
	 // Register member post type
    function addClientsPostType() {
        register_post_type(
            'clients', array(
            'labels' => $this->getLabels(esc_html__('Clients', 'helpmate'), esc_html__('Clients', 'helpmate')),
            'exclude_from_search' => true,
            'has_archive' => false,
            'publicly_queryable'  => false,
            'public' => true,
            'rewrite' => array('slug' => 'clients'),
            'supports' => array('title', 'editor', 'thumbnail', 'comments', 'page-attributes'),
            'can_export' => true
                )
        );
    }
    // load plugin text domain
    function loadTextDomain() {
        load_plugin_textdomain('helpmate', false, dirname(__FILE__) . '/languages/');
    }

    // Get content type labels
    function getLabels($singular_name, $name, $title = FALSE) {
        if (!$title)
            $title = $name;

        return array(
            "name" => $title,
            "singular_name" => $singular_name,
            "add_new" => esc_html__("Add New", 'helpmate'),
            "add_new_item" => sprintf(esc_html__("Add New %s", 'helpmate'), $singular_name),
            "edit_item" => sprintf(esc_html__("Edit %s", 'helpmate'), $singular_name),
            "new_item" => sprintf(esc_html__("New %s", 'helpmate'), $singular_name),
            "view_item" => sprintf(esc_html__("View %s", 'helpmate'), $singular_name),
            "search_items" => sprintf(esc_html__("Search %s", 'helpmate'), $name),
            "not_found" => sprintf(esc_html__("No %s found", 'helpmate'), $name),
            "not_found_in_trash" => sprintf(esc_html__("No %s found in Trash", 'helpmate'), $name),
            "parent_item_colon" => ""
        );
    }

    // Get content type taxonomy labels
    function getTaxonomyLabels($singular_name, $name) {
        return array(
            "name" => $name,
            "singular_name" => $singular_name,
            "search_items" => sprintf(esc_html__("Search %s", 'helpmate'), $name),
            "all_items" => sprintf(esc_html__("All %s", 'helpmate'), $name),
            "parent_item" => sprintf(esc_html__("Parent %s", 'helpmate'), $singular_name),
            "parent_item_colon" => sprintf(esc_html__("Parent %s:", 'helpmate'), $singular_name),
            "edit_item" => sprintf(esc_html__("Edit %", 'helpmate'), $singular_name),
            "update_item" => sprintf(esc_html__("Update %s", 'helpmate'), $singular_name),
            "add_new_item" => sprintf(esc_html__("Add New %s", 'helpmate'), $singular_name),
            "new_item_name" => sprintf(esc_html__("New %s Name", 'helpmate'), $singular_name),
            "menu_name" => $name,
        );
    }

}

new helpmatePostTypes();
