<?php

/*
  Plugin Name: Helpmate Shortcodes
  Plugin URI:
  Description: Shortcodes for Helpmate Theme.
  Version: 1.0.0
  Author: AHT
  Author URI:
 */

// don't load directly
if (!defined('ABSPATH'))
    die('-1');

define('HELPMATE_SHORTCODES_URL', plugin_dir_url(__FILE__));
define('HELPMATE_SHORTCODES_PATH', dirname(__FILE__) . '/shortcodes/');
define('HELPMATE_SHORTCODES_LIB', dirname(__FILE__) . '/lib/');
define('HELPMATE_SHORTCODES_TEMPLATES', dirname(__FILE__) . '/templates/');

class HelpmateShortcodesClass {

    private $shortcodes = array( "helpmate_filter_faq", "helpmate_static_block", "helpmate_container", "helpmate_office", 
                                "helpmate_our_team", "helpmate_pricing_column","helpmate_counter",
                                "helpmate_testimonial","helpmate_clients", "helpmate_button", 
                                "helpmate_social_icon", "helpmate_blog", "helpmate_info_box",
                                "helpmate_gallery", "helpmate_service", "helpmate_info_block", "helpmate_work_progress",
								"helpmate_item_progress");

    function __construct() {

        // Load text domain
        add_action('plugins_loaded', array($this, 'loadTextDomain'));
        // Init plugins
        add_action('init', array($this, 'initPlugin'));

        $this->addShortcodes();
        add_filter('the_content', array($this, 'formatShortcodes'));
        add_filter('widget_text', array($this, 'formatShortcodes'));

        add_action('vc_base_register_admin_css', array($this, 'helpmate_iconpicker_base_register_css'));
        add_action('vc_backend_editor_enqueue_js_css', array($this, 'helpmate_iconpicker_editor_jscss'));
        add_action('vc_frontend_editor_enqueue_js_css', array($this, 'helpmate_iconpicker_editor_jscss'));
    }

    function helpmate_iconpicker_base_register_css() {
        wp_register_style('fontello', HELPMATE_SHORTCODES_URL . 'assets/css/fontello.css', false, '1.0', 'screen');
    }

    function helpmate_iconpicker_editor_jscss() {
        wp_enqueue_style('fontello');
    }


    // Init plugins
    function initPlugin() {
        $this->addTinyMCEButtons();
    }

    // load plugin text domain
    function loadTextDomain() {
        load_plugin_textdomain('helpmate', false, dirname(__FILE__) . '/languages/');
    }

    // Add buttons to tinyMCE
    function addTinyMCEButtons() {
        if (!current_user_can('edit_posts') && !current_user_can('edit_pages'))
            return;

        if (get_user_option('rich_editing') == 'true') {
            add_filter('mce_buttons', array(&$this, 'registerTinyMCEButtons'));
        }
    }

    function registerTinyMCEButtons($buttons) {
        array_push($buttons, "helpmate_shortcodes_button");
        return $buttons;
    }

    // Add shortcodes
    function addShortcodes() {
        require_once(HELPMATE_SHORTCODES_LIB . 'functions.php');
        foreach ($this->shortcodes as $shortcode) {
            require_once(HELPMATE_SHORTCODES_PATH . $shortcode . '.php');
        }
        // if( function_exists('is_plugin_active') && is_plugin_active( 'wp-customer-reviews/wp-customer-reviews-3.php' )){
        //     require_once(HELPMATE_SHORTCODES_PATH .'helpmate_reviews.php');
        // }
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
    }

    // Format shortcodes content
    function formatShortcodes($content) {
        $block = join("|", $this->shortcodes);
        // opening tag
        $content = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/", "[$2$3]", $content);
        // closing tag
        $content = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)/", "[/$2]", $content);

        return $content;
    }
}

// Finally initialize code
new HelpmateShortcodesClass();
