<?php

add_shortcode('helpmate_blog', 'helpmate_shortcode_blog');
add_action('vc_build_admin_page', 'helpmate_load_blog_shortcode');
add_action('vc_after_init', 'helpmate_load_blog_shortcode');

function helpmate_shortcode_blog($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_blog'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_blog_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "Helpmate " . esc_html__('Blog', 'helpmate'),
        'base' => 'helpmate_blog',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", 'helpmate'),
                "param_name" => "layout",
                'std' => 'list_3columns',
                'value' => array(
                    esc_html__('List 3 Columns', 'helpmate') => 'list_3columns',
                    esc_html__('List 4 Columns', 'helpmate') => 'list_4columns',
                    esc_html__('Slide', 'helpmate') => 'slide',
                ),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Posts Count", "helpmate"),
                "param_name" => "number",
                "value" => "4",
                "admin_label" => true,
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('list_3columns', 'list_4columns')
                )
            ),
			array(
                "type" => "textfield",
                "heading" => esc_html__("Category IDs", "helpmate"),
                "description" => esc_html__("Comma separated list of category ids", "helpmate"),
                "param_name" => "cat",
                "admin_label" => true
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Desktop Large (> 1200px)", "helpmate"),
                "param_name" => "items_desktop_large",
                'std' => 2,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ),
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('list_3columns', 'list_4columns')
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Desktop", "helpmate"),
                "param_name" => "items_desktop",
                'std' => 2,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ), 
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('list_3columns', 'list_4columns')
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => __("Number Column on Tablets", "helpmate"),
                "param_name" => "items_tablets",
                'std' => 2,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ), 
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('list_3columns', 'list_4columns')
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => __("Number Column on Mobile", "helpmate"),
                "param_name" => "items_mobile",
                'std' => 1,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ),
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('list_3columns', 'list_4columns')
                )
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'helpmate' ),
            ),
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_Blog')) {
        class WPBakeryShortCode_helpmate_Blog extends WPBakeryShortCode {
        }
    }
}