<?php

// helpmate_button
add_shortcode('helpmate_button', 'helpmate_shortcode_button');
add_action('vc_build_admin_page', 'helpmate_load_button_shortcode');
add_action('vc_after_init', 'helpmate_load_button_shortcode');

function helpmate_shortcode_button($atts, $content = null) {
    ob_start();
    if ($template = Helpmate_shortcode_template('helpmate_button'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_button_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "Helpmate " . esc_html__('Button', 'helpmate'),
        'base' => 'helpmate_button',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Button Type", 'helpmate'),
                "param_name" => "btn_layout",
                'std' => 'btn_layout_1',
                'value' => array(
                    esc_html__('Button Type 1', 'helpmate') => 'btn_layout_1',
                    esc_html__('Button Type 2', 'helpmate') => 'btn_layout_2',
                    esc_html__('Button Type 3', 'helpmate') => 'btn_layout_3',
                ),
				"description" => esc_html__( "Select button type.", "helpmate" )
            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Button Size", 'helpmate'),
                "param_name" => "btn_size",
                'std' => '',
                'value' => array(
                    esc_html__('Button Default', 'helpmate') => '',
                    esc_html__('Button Size 2', 'helpmate') => 'size2',
                ),
				"description" => esc_html__( "Select button size.", "helpmate" )
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", "helpmate"),
                "param_name" => "btn_text",
                'value' => esc_html__( 'Read more', 'helpmate' ),
            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Text align", 'helpmate'),
                "param_name" => "text_align",
                'std' => 'left',
                'value' => array(
                    esc_html__('left', 'helpmate') => 'left',
                    esc_html__('center', 'helpmate') => 'center',
                    esc_html__('right', 'helpmate') => 'right',
                ),
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Link", 'helpmate'),
                "param_name" => "link",
            ),
            $custom_class
        )
    ) );

    if (!class_exists('WPBakeryShortCode_helpmate_button')) {
        class WPBakeryShortCode_helpmate_button extends WPBakeryShortCode {
        }
    }
}