<?php

// helpmate_our_team
add_shortcode('helpmate_clients', 'helpmate_shortcode_clients');
add_action('vc_build_admin_page', 'helpmate_load_clients_shortcode');
add_action('vc_after_init', 'helpmate_load_clients_shortcode');

function helpmate_shortcode_clients($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_clients'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_clients_shortcode() {
    $animation_type = helpmate_vc_animation_type();
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "[Helpmate]" . esc_html__(' Clients', 'helpmate'),
        'base' => 'helpmate_clients',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(   
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", "helpmate"),
                "param_name" => "clients_layout",
                'std' => 'grid',
                'value' => array(
                    esc_html__('Grid', 'helpmate') => 'grid',
					esc_html__('List Content', 'helpmate') => 'list_content',
                    esc_html__('Slider Images', 'helpmate') => 'slide_image',
                    esc_html__('Slider Content', 'helpmate') => 'slide_content',
					esc_html__('Slider Content 2', 'helpmate') => 'slide_content_2',
					esc_html__('Slider Content With Title', 'helpmate') => 'slide_content_with_title',
                ),
            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Slide Type", 'helpmate'),
                "param_name" => "carousel_type",
                'std' => 'carousel_type_1',
                'value' => array(
                    esc_html__('Slide Type 1', 'helpmate') => 'carousel_type_1',
                    esc_html__('Slide Type 2', 'helpmate') => 'carousel_type_2',
                    esc_html__('Slide Type 3', 'helpmate') => 'carousel_type_3',
                    esc_html__('Slide Type 4', 'helpmate') => 'carousel_type_4',
                ),
                'dependency' => array(
                    'element' => 'clients_layout',
                    'value' => array('slide_image', 'slide_content', 'slide_content_2', 'slide_content_with_title'),
                ),
                "description" => esc_html__( "Select slide type.", "helpmate" )
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Posts Count", "helpmate"),
                "param_name" => "number",
                "value" => 3,
                "admin_label" => true,
				"dependency" => array(
                    'element' => 'clients_layout',
                    'value' => array('grid', 'list_content', 'slide_content_with_title'),
                ) 
				
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number of post entries per slide", 'helpmate'),
                "param_name" => "number_per_slide",
                "value" => 4,
                "description" => esc_html__('Set max number of entries to show per slide', 'helpmate'),
                "dependency" => array(
                    'element' => 'clients_layout',
                    'value' => array('slide_image', 'slide_content', 'slide_content_2', 'slide_content_with_title'),
                ) 
            ),            
			// post type
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Desktop Large (> 1200px)", "helpmate"),
                "param_name" => "items_desktop_large",
                'std' => 3,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ),
                'dependency' => array(
                    'element' => 'clients_layout',
                    'value' => array('grid')
                )                
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Desktop", "helpmate"),
                "param_name" => "items_desktop",
                'std' => 3,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ),
                'dependency' => array(
                    'element' => 'clients_layout',
                    'value' => array('grid')
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Tablets", "helpmate"),
                "param_name" => "items_tablets",
                'std' => 2,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ),
                'dependency' => array(
                    'element' => 'clients_layout',
                    'value' => array('grid')
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Mobile", "helpmate"),
                "param_name" => "items_mobile",
                'std' => 1,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ),
                'dependency' => array(
                    'element' => 'clients_layout',
                    'value' => array('grid')
                )
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )
        )
    ) );

    if (!class_exists('WPBakeryShortCode_helpmate_clients')) {
        class WPBakeryShortCode_helpmate_clients extends WPBakeryShortCode {
        }
    }
}