<?php

// Helpmate Container
add_shortcode('helpmate_container', 'helpmate_shortcode_container');
add_action('vc_build_admin_page', 'helpmate_load_container_shortcode');
add_action('vc_after_init', 'helpmate_load_container_shortcode');

function helpmate_shortcode_container($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_container'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_container_shortcode() {
    $custom_class = helpmate_vc_custom_class();
    vc_map( array(
        "name" => "[Helpmate] " . esc_html__("Container", 'helpmate'),
        "base" => "helpmate_container",
        "category" => esc_html__("Helpmate", 'helpmate'),
        "icon" => "helpmate_vc_container",
        'is_container' => true,
        'weight' => - 50,
        "show_settings_on_create" => false,
        'js_view' => 'VcColumnView',
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Container Type", 'helpmate'),
                "param_name" => "container_type",
                'std' => 1,
                'value' => array(
                    esc_html__('Container', 'helpmate') => '1',
                    esc_html__('Container Fluid', 'helpmate') => '2',
                ),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Block align", 'helpmate'),
                "param_name" => "align",
                'std' => 'left',
                'value' => array(
                    esc_html__('Left', 'helpmate') => 'left',
                    esc_html__('Center', 'helpmate') => 'center',
                    esc_html__('Right', 'helpmate') => 'right',
                ),
            ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__("Item delay", "helpmate"),
                'param_name' => 'item_delay',
                'value' => array( esc_html__( 'Yes', 'helpmate' ) => 'yes' )
            ),
            $custom_class
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_Container')) {
        class WPBakeryShortCode_Helpmate_Container extends WPBakeryShortCodesContainer {
        }
    }
}