<?php

add_shortcode('helpmate_counter', 'helpmate_shortcode_counter');
add_action('vc_build_admin_page', 'helpmate_load_counter_shortcode');
add_action('vc_after_init', 'helpmate_load_counter_shortcode');

function helpmate_shortcode_counter($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_counter'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_counter_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map(array(
        'name' => "[Helpmate] " . esc_html__('Counter', 'helpmate'),
        'base' => 'helpmate_counter',
        'category' => esc_html__("Helpmate", 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", 'helpmate'),
                "param_name" => "title",
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number", 'helpmate'),
                "param_name" => "number",
            ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__("Show line icon", "helpmate"),
                'param_name' => 'show_icon',
                'std' => 'yes',
                'value' => array(esc_html__('Yes', 'helpmate') => 'yes')
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Icon library', 'helpmate'),
                'value' => array(
                    esc_html__('Font Awesome', 'helpmate') => 'fontawesome',
                    esc_html__('Fontello', 'helpmate') => 'fontello',
                    esc_html__( 'Open Iconic', 'helpmate' ) => 'openiconic',
                    esc_html__( 'Typicons', 'helpmate' ) => 'typicons',
                    esc_html__( 'Entypo', 'helpmate' ) => 'entypo',
                    esc_html__( 'Linecons', 'helpmate' ) => 'linecons',
                    esc_html__( 'Mono Social', 'helpmate' ) => 'monosocial',
                ),
                'admin_label' => true,
                'param_name' => 'type',
                'weight' => 10,
                'description' => esc_html__('Select icon library.', 'helpmate'),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__('Icon', 'helpmate'),
                'param_name' => 'icon_fontello',
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'fontello',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'fontello',
                ),
                'weight' => 9,
                'description' => esc_html__('Select icon from library.', 'helpmate'),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'helpmate' ),
                'param_name' => 'icon_fontawesome',
                'value' => 'fa fa-adjust', // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false,
                    // default true, display an "EMPTY" icon?
                    'iconsPerPage' => 4000,
                    // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'fontawesome',
                ),
                'description' => esc_html__( 'Select icon from library.', 'helpmate' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'helpmate' ),
                'param_name' => 'icon_openiconic',
                'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'openiconic',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'openiconic',
                ),
                'description' => esc_html__( 'Select icon from library.', 'helpmate' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'helpmate' ),
                'param_name' => 'icon_typicons',
                'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'typicons',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'typicons',
                ),
                'description' => esc_html__( 'Select icon from library.', 'helpmate' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'helpmate' ),
                'param_name' => 'icon_entypo',
                'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'entypo',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'entypo',
                ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'helpmate' ),
                'param_name' => 'icon_linecons',
                'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'linecons',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'linecons',
                ),
                'description' => esc_html__( 'Select icon from library.', 'helpmate' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'helpmate' ),
                'param_name' => 'icon_monosocial',
                'value' => 'vc-mono vc-mono-fivehundredpx', // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'monosocial',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'monosocial',
                ),
                'description' => esc_html__( 'Select icon from library.', 'helpmate' ),
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )
        )
    ));

    if (!class_exists('WPBakeryShortCode_Helpmate_Counter')) {

        class WPBakeryShortCode_Helpmate_Counter extends WPBakeryShortCode {
            
        }

    }
}
