<?php

add_shortcode('helpmate_filter_faq', 'helpmate_shortcode_filter_faq');
add_action('vc_build_admin_page', 'helpmate_load_filter_faq_shortcode');
add_action('vc_after_init', 'helpmate_load_filter_faq_shortcode');

function helpmate_shortcode_filter_faq($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_filter_faq'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_filter_faq_shortcode() {
    $custom_class = helpmate_vc_custom_class();
    vc_map( array(
        'name' => "Helpmate " . esc_html__('Filter Faq', 'helpmate'),
        'base' => 'helpmate_filter_faq',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        'is_container' => true,
        'js_view' => 'VcColumnView',
        "as_parent" => array('only' => 'vc_toggle',),
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Title Filter", 'helpmate'),
                "param_name" => "number_filter",
                'std' => '3',
                'value' => array(
                    esc_html__('2', 'helpmate') => '2',
                    esc_html__('3', 'helpmate') => '3',
                    esc_html__('4', 'helpmate') => '4',
                    esc_html__('5', 'helpmate') => '5',
                ),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Category Filter 1", "helpmate"),
                "param_name" => "title_1",
                "value" => "Title 1",
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Category Filter 2", 'helpmate'),
                "param_name" => "title_2",
                'dependency' => array(
                    'element' => 'number_filter',
                    'value' => array('2', '3', '4', '5')
                ),
                "value" => esc_html__('Title 2', 'helpmate'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Category Filter 3", 'helpmate'),
                "param_name" => "title_3",
                'dependency' => array(
                    'element' => 'number_filter',
                    'value' => array('3', '4', '5')
                ),
                "value" => esc_html__('Title 3', 'helpmate'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Category Filter 4", 'helpmate'),
                "param_name" => "title_4",
                'dependency' => array(
                    'element' => 'number_filter',
                    'value' => array('4', '5')
                ),
                "value" => esc_html__('Title 4', 'helpmate'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Category Filter 5", 'helpmate'),
                "param_name" => "title_5",
                'dependency' => array(
                    'element' => 'number_filter',
                    'value' => array('5')
                ),
                "value" => esc_html__('Title 5', 'helpmate'),
            ),
            $custom_class
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_Filter_Faq')) {
        class WPBakeryShortCode_Helpmate_Filter_Faq extends WPBakeryShortCodesContainer {
        }
    }
}