<?php

// helpmate_gallery
add_shortcode('helpmate_gallery', 'helpmate_shortcode_gallery');
add_action('vc_build_admin_page', 'helpmate_load_gallery_shortcode');
add_action('vc_after_init', 'helpmate_load_gallery_shortcode');

function helpmate_shortcode_gallery($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_gallery'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_gallery_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "[Helpmate] " . esc_html__('Gallery', 'helpmate'),
        'base' => 'helpmate_gallery',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", "helpmate"),
                "param_name" => "title",
                "value" => "",
                "admin_label" => true
            ),
            array(
                "type" => "textarea",
                "heading" => esc_html__("Description", 'helpmate'),
                "param_name" => "description",
                'description' => esc_html__('Enter short description', 'helpmate')
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", "helpmate"),
                "param_name" => "layout",
                'std' => 'default',
                'value' => array(
                    esc_html__('Filter', 'helpmate') => 'filter',
                    esc_html__('Slider', 'helpmate') => 'slider',
                    esc_html__('Sortable Grid', 'helpmate') => 'grid',
                    esc_html__('Sortable Masonry', 'helpmate') => 'masonry',
                ),
            ),             
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Filter style", "helpmate"),
                "param_name" => "filter_style",
                'std' => 'default',
                'value' => array(
                    esc_html__('Default', 'helpmate') => 'default',
                    esc_html__('Link with slash', 'helpmate') => 'style_1',
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('filter'),
                )
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Category parent ID", "helpmate"),
                "param_name" => "category_parent",
                "admin_label" => true
            ),             
            array(
                "type" => "textfield",
                "heading" => esc_html__("Number of gallery to show", "helpmate"),
                "param_name" => "number",
                "value" => "8",
                "admin_label" => true
            ),
			array(
                'type' => 'checkbox',
                'heading' => esc_html__("Item delay", "helpmate"),
                'param_name' => 'item_delay',
                'std' => 'yes',
                'value' => array( esc_html__( 'Yes', 'helpmate' ) => 'yes' )
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_Gallery')) {
        class WPBakeryShortCode_Helpmate_Gallery extends WPBakeryShortCode {
        }
    }
}