<?php

// helpmate_info_block
add_shortcode('helpmate_info_block', 'helpmate_shortcode_info_block');
add_action('vc_build_admin_page', 'helpmate_load_info_block_shortcode');
add_action('vc_after_init', 'helpmate_load_info_block_shortcode');

function helpmate_shortcode_info_block($atts, $content = null) {
    ob_start();
    if ($template = Helpmate_shortcode_template('helpmate_info_block'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_info_block_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "[Helpmate] " . esc_html__('Info Block', 'helpmate'),
        'base' => 'helpmate_info_block',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", "helpmate"),
                "param_name" => "layout",
                'std' => 'type1',
                'value' => array(
                    esc_html__('Style 1', 'helpmate') => 'type1',
                    esc_html__('Style 2', 'helpmate') => 'type2',
                ),
            ), 
			array(
                'type' => 'dropdown',
                'heading' => esc_html__('Icon library', 'helpmate'),
                'value' => array(
                    esc_html__('Fontello', 'helpmate') => 'fontello',
                ),
                'admin_label' => true,
                'param_name' => 'type',
                'weight' => 10,
                'description' => esc_html__('Select icon library.', 'helpmate'),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__('Icon', 'helpmate'),
                'param_name' => 'icon_fontello',
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'fontello',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'fontello',
                ),
                'weight' => 9,
                'description' => esc_html__('Select icon from library.', 'helpmate'),
            ),
			array(
                "type" => "textfield",
                "heading" => esc_html__("Title", 'helpmate'),
                "param_name" => "title",
                "value" => "",
            ),
            array(
                "type" => "textarea",
                "heading" => esc_html__("Description", "helpmate"),
                "param_name" => "description",
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Link", 'helpmate'),
                "param_name" => "link",
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )            
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_info_block')) {
        class WPBakeryShortCode_Helpmate_info_block extends WPBakeryShortCode {
        }
    }
}