<?php

// helpmate_our_team
add_shortcode('helpmate_office', 'helpmate_shortcode_office');
add_action('vc_build_admin_page', 'helpmate_load_office_shortcode');
add_action('vc_after_init', 'helpmate_load_office_shortcode');

function helpmate_shortcode_office($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_office'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_office_shortcode() {
    $animation_type = helpmate_vc_animation_type();
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "[Helpmate]" . esc_html__(' Office', 'helpmate'),
        'base' => 'helpmate_office',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", 'helpmate'),
                "param_name" => "title",
                'description' => esc_html__('Enter title to display', 'helpmate'),
                "admin_label" => true
            ),
            array(
                "type" => "textarea",
                "heading" => esc_html__("Description", 'helpmate'),
                "param_name" => "description",
                'description' => esc_html__('Enter short description', 'helpmate')
            ),            
            array(
                "type" => "number",
                "heading" => esc_html__("Number of post entries", 'helpmate'),
                "param_name" => "number",
                "value" => esc_html__(8, 'helpmate'),
                'description' => esc_html__('Set the total number of entries to show', 'helpmate'),
                "admin_label" => true
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number of post entries per slide", 'helpmate'),
                "param_name" => "number_per_slide",
                "value" => esc_html__(3, 'helpmate'),
                'description' => esc_html__('Set max number of entries to show per slide', 'helpmate'),
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_Office')) {
        class WPBakeryShortCode_Helpmate_Office extends WPBakeryShortCode {
        }
    }
}