<?php

// helpmate_our_team
add_shortcode('helpmate_our_team', 'helpmate_shortcode_our_team');
add_action('vc_build_admin_page', 'helpmate_load_our_team_shortcode');
add_action('vc_after_init', 'helpmate_load_our_team_shortcode');

function helpmate_shortcode_our_team($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_our_team'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_our_team_shortcode() {
    $animation_type = helpmate_vc_animation_type();
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "[Helpmate]" . esc_html__(' Team', 'helpmate'),
        'base' => 'helpmate_our_team',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", 'helpmate'),
                "param_name" => "title",
                'description' => esc_html__('Set the title for our team block', 'helpmate'),
                "admin_label" => true
            ),
            array(
                "type" => "textarea",
                "heading" => esc_html__("Description", 'helpmate'),
                "param_name" => "description",
                'description' => esc_html__('Enter short description', 'helpmate')
            ), 
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", "helpmate"),
                "param_name" => "layout",
                'std' => 'grid',
                'value' => array(
                    esc_html__('Grid', 'helpmate') => 'grid',
                    esc_html__('Slide', 'helpmate') => 'slide',
                ),
            ),           
            array(
                "type" => "number",
                "heading" => esc_html__("Number of post entries per page", 'helpmate'),
                "param_name" => "number",
                "value" => esc_html__(8, 'helpmate'),
                'description' => esc_html__('Set the total number of entries to show per page', 'helpmate'),
                "admin_label" => true
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number of post entries per slide", 'helpmate'),
                "param_name" => "number_per_slide",
                "value" => esc_html__(3, 'helpmate'),
                'description' => esc_html__('Set max number of entries to show per slide', 'helpmate'),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('slide')
                ) 
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Items to show on Desktop", "helpmate"),
                "param_name" => "items_desktop",
                'std' => 3,
                'value' => array(
                    esc_html__('4', 'helpmate') => 4,
                    esc_html__('3', 'helpmate') => 3,
                    esc_html__('2', 'helpmate') => 2,
                    esc_html__('1', 'helpmate') => 1,
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('grid')
                )                
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_Our_Team')) {
        class WPBakeryShortCode_Helpmate_Our_Team extends WPBakeryShortCode {
        }
    }
}