<?php

// helpmate_pricing_column
add_shortcode('helpmate_pricing_column', 'helpmate_shortcode_pricing_column');
add_action('vc_build_admin_page', 'helpmate_load_pricing_column_shortcode');
add_action('vc_after_init', 'helpmate_load_pricing_column_shortcode');

function helpmate_shortcode_pricing_column($atts, $content = null) {
    ob_start();
    if ($template = Helpmate_shortcode_template('helpmate_pricing_column'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_pricing_column_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "Helpmate " . esc_html__('Pricing Column', 'helpmate'),
        'base' => 'helpmate_pricing_column',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Pricing Layout", 'helpmate'),
                "param_name" => "layout",
                'std' => 'layout_1',
                'value' => array(
                    esc_html__('Pricing Layout 1', 'helpmate') => 'layout_1',
                    esc_html__('Pricing Layout 2', 'helpmate') => 'layout_2',
                    esc_html__('Pricing No Price', 'helpmate') => 'layout_3',
                    esc_html__('Pricing Menu', 'helpmate') => 'layout_4',
                ),
				"description" => esc_html__( "Select pricing style.", "helpmate" )
            ),
			array(
                "type" => "textfield",
                "heading" => esc_html__("Currency", "helpmate"),
                "param_name" => "currency",
                "value" => "$",
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_1', 'layout_2', 'layout_4')
                )
            ),  
            array(
                "type" => "textfield",
                "heading" => esc_html__("Price", "helpmate"),
                "param_name" => "price",
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_1', 'layout_2', 'layout_4')
                )
            ),  
			array(
                "type" => "textfield",
                "heading" => esc_html__("Sup price", "helpmate"),
                "param_name" => "sup_price",
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_1', 'layout_2')
                )
            ), 
			array(
                "type" => "textfield",
                "heading" => esc_html__("Description Price", "helpmate"),
                "param_name" => "desc_price",
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_1', 'layout_2', 'layout_4')
                )
            ), 
			array(
                "type" => "textfield",
                "heading" => esc_html__("Title", "helpmate"),
                "param_name" => "title",
            ),
			 array(
                "type" => "textfield",
                "heading" => esc_html__("Text Holder", "helpmate"),
                "param_name" => "text_holder",
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_3')
                )
            ),
			array(
                "type" => "textfield",
                "heading" => esc_html__("Title Footer", "helpmate"),
                "param_name" => "title_footer",
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_3')
                )
            ),
            array(
                "type" => "textarea_html",
                "heading" => esc_html__("Content", "helpmate"),
                "param_name" => "content",

            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Button Type", 'helpmate'),
                "param_name" => "btn_layout",
                'std' => 'btn_layout_1',
                'value' => array(
                    esc_html__('Button Type 1', 'helpmate') => 'btn_layout_1',
                    esc_html__('Button Type 2', 'helpmate') => 'btn_layout_2',
                    esc_html__('Button Type 3', 'helpmate') => 'btn_layout_3',
                ),
				"description" => esc_html__( "Select button type.", "helpmate" ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_1', 'layout_2')
                )
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", "helpmate"),
                "param_name" => "btn_text",
                'value' => esc_html__( 'Read more', 'helpmate' ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_1', 'layout_2')
                )
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Link", 'helpmate'),
                "param_name" => "link",
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('layout_1', 'layout_2')
                )
            ),
            $custom_class
        )
    ) );

    if (!class_exists('WPBakeryShortCode_helpmate_pricing_column')) {
        class WPBakeryShortCode_helpmate_pricing_column extends WPBakeryShortCode {
        }
    }
}