<?php

// helpmate_service
add_shortcode('helpmate_service', 'helpmate_shortcode_service');
add_action('vc_build_admin_page', 'helpmate_load_service_shortcode');
add_action('vc_after_init', 'helpmate_load_service_shortcode');

function helpmate_shortcode_service($atts, $content = null) {
    ob_start();
    if ($template = Helpmate_shortcode_template('helpmate_service'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_service_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "[Helpmate] " . esc_html__('Service', 'helpmate'),
        'base' => 'helpmate_service',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", "helpmate"),
                "param_name" => "layout",
                'std' => 'style1',
                'value' => array(
                    esc_html__('Style 1', 'helpmate') => 'style1',
                    esc_html__('Style 2', 'helpmate') => 'style2',
                ),
            ), 
			array(
                'type' => 'dropdown',
                'heading' => esc_html__('Icon library', 'helpmate'),
                'value' => array(
                    esc_html__('Fontello', 'helpmate') => 'fontello',
                ),
                'admin_label' => true,
                'param_name' => 'type',
                'weight' => 10,
                'description' => esc_html__('Select icon library.', 'helpmate'),
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('style1'),
                ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__('Icon', 'helpmate'),
                'param_name' => 'icon_fontello',
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'fontello',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'fontello',
                ),
                'weight' => 9,
                'description' => esc_html__('Select icon from library.', 'helpmate'),
            ),
			/*array(
				"type" => "colorpicker",
				"class" => "",
				"heading" => esc_html__("Main background Color", "helpmate"),
				"param_name" => "color_bg_main",
				"value" => "",
				"description" => esc_html__("Select background color.", "helpmate"),
			),*/
			array(
                'type' => 'attach_image',
                'heading' => esc_html__('Image', 'helpmate'),
                'param_name' => 'image',
                'value' => '',
                'description' => esc_html__( 'Upload image.', 'helpmate' ),
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('style2'),
                ),
            ),
			array(
                "type" => "textfield",
                "heading" => esc_html__("Title", 'helpmate'),
                "param_name" => "title",
                "admin_label" => true,
            ),  
			array(
                "type" => "textarea",
                "heading" => esc_html__("Description", "helpmate"),
                "param_name" => "description",
            ),
			array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", "helpmate"),
                "param_name" => "btn_text",
                'value' => esc_html__( 'Read more', 'helpmate' ),
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('style2'),
                ),
            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Button Type", 'helpmate'),
                "param_name" => "btn_layout",
                'std' => 'btn_layout_1',
                'value' => array(
                    esc_html__('Button Type 1', 'helpmate') => 'btn_layout_1',
                    esc_html__('Button Type 2', 'helpmate') => 'btn_layout_2',
                    esc_html__('Button Type 3', 'helpmate') => 'btn_layout_3',
                ),
				"description" => esc_html__( "Select button type.", "helpmate" ),
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('style2'),
                ),
            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Button Size", 'helpmate'),
                "param_name" => "btn_size",
                'std' => '',
                'value' => array(
                    esc_html__('Button Default', 'helpmate') => '',
                    esc_html__('Button Size 2', 'helpmate') => 'size2',
                ),
				"description" => esc_html__( "Select button size.", "helpmate" ),
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('style2'),
                ),
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Link", 'helpmate'),
                "param_name" => "link",
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )            
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_service')) {
        class WPBakeryShortCode_Helpmate_service extends WPBakeryShortCode {
        }
    }
}