<?php

// helpmate_social_icon
add_shortcode('helpmate_social_icon', 'helpmate_shortcode_social_icon');
add_action('vc_build_admin_page', 'helpmate_load_social_icon_shortcode');
add_action('vc_after_init', 'helpmate_load_social_icon_shortcode');

function helpmate_shortcode_social_icon($atts, $content = null) {
    ob_start();
    if ($template = Helpmate_shortcode_template('helpmate_social_icon'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_social_icon_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "Helpmate " . esc_html__('Social icon', 'helpmate'),
        'base' => 'helpmate_social_icon',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Twitter", 'helpmate'),
                "param_name" => "twitter_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Instagram", 'helpmate'),
                "param_name" => "instagram_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Facebook", 'helpmate'),
                "param_name" => "facebook_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Youtube", 'helpmate'),
                "param_name" => "youtube_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Mail", 'helpmate'),
                "param_name" => "mail_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("RSS", 'helpmate'),
                "param_name" => "rss_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Googleplus", 'helpmate'),
                "param_name" => "gplus_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Vimeo", 'helpmate'),
                "param_name" => "vimeo_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Behance", 'helpmate'),
                "param_name" => "behance_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Flickr", 'helpmate'),
                "param_name" => "gplus_flickr",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Yahoo", 'helpmate'),
                "param_name" => "yahoo_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Pint", 'helpmate'),
                "param_name" => "pint_link",
            ),
           array(
                 "type" => "vc_link",
                "heading" => esc_html__("Skype", 'helpmate'),
                "param_name" => "skype_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Dribbble", 'helpmate'),
                "param_name" => "dribbble_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Vk", 'helpmate'),
                "param_name" => "vk_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Tumblr", 'helpmate'),
                "param_name" => "tumblr_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Dropbox", 'helpmate'),
                "param_name" => "dropbox_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Github", 'helpmate'),
                "param_name" => "github_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Delicious", 'helpmate'),
                "param_name" => "delicious_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Digg", 'helpmate'),
                "param_name" => "digg_link",
            ),
           array(
                 "type" => "vc_link",
                "heading" => esc_html__("Deviant", 'helpmate'),
                "param_name" => "deviant_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Reddit", 'helpmate'),
                "param_name" => "reddit_link",
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Stumble", 'helpmate'),
                "param_name" => "stumble_link",
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Link", 'helpmate'),
                "param_name" => "link",
            ),
            $custom_class
        )
    ) );

    if (!class_exists('WPBakeryShortCode_helpmate_social_icon')) {
        class WPBakeryShortCode_helpmate_social_icon extends WPBakeryShortCode {
        }
    }
}