<?php

// Helpmate_static_block
add_shortcode('helpmate_static_block', 'helpmate_shortcode_static_block');
add_action('vc_build_admin_page', 'helpmate_load_static_block_shortcode');
add_action('vc_after_init', 'helpmate_load_static_block_shortcode');
function helpmate_shortcode_static_block($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_static_block'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_static_block_shortcode() {
    $custom_class = helpmate_vc_custom_class();
    $block_options = array();
    $block_options[0] = esc_html__('Choose a block to display', 'Helpmate');
    $args = array(
        'numberposts'       => -1,
        'post_type'         => 'block',
        'post_status'       => 'publish',
    );
    $posts = get_posts($args);
    foreach( $posts as $_post ){
        $block_options[$_post->post_title] = $_post->post_title;
    }
    vc_map( array(
        'name' => "[Helpmate] " . esc_html__('Static Block', 'helpmate'),
        'base' => 'helpmate_static_block',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Static Block", 'helpmate'),
                "param_name" => "static",
                'value' =>  $block_options,
                "admin_label" => true
            ),
            $custom_class
        )
    ));

    if (!class_exists('WPBakeryShortCode_Helpmate_Static_Block')) {
        class WPBakeryShortCode_Helpmate_Static_Block extends WPBakeryShortCode {
        }
    }
}


