<?php

// helpmate_testimonial
add_shortcode('helpmate_testimonial', 'helpmate_shortcode_testimonial');
add_action('vc_build_admin_page', 'helpmate_load_testimonial_shortcode');
add_action('vc_after_init', 'helpmate_load_testimonial_shortcode');

function helpmate_shortcode_testimonial($atts, $content = null) {
    ob_start();
    if ($template = helpmate_shortcode_template('helpmate_testimonial'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_testimonial_shortcode() {
    $animation_type = helpmate_vc_animation_type();
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "[Helpmate]" . esc_html__(' Testimonial', 'helpmate'),
        'base' => 'helpmate_testimonial',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
        'weight' => - 50,
        "params" => array(
			 array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", "helpmate"),
                "param_name" => "layout",
                'std' => 'slide',
                'value' => array(
                    esc_html__('Grid', 'helpmate') => 'grid',
                    esc_html__('List', 'helpmate') => 'list',
                    esc_html__('Slide', 'helpmate') => 'slide',
                    esc_html__('Slide Content', 'helpmate') => 'slide_content',
                ),
            ), 
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Slide Type", 'helpmate'),
                "param_name" => "carousel_type",
                'std' => 'carousel_type_1',
                'value' => array(
                    esc_html__('Slide Type 1', 'helpmate') => 'carousel_type_1',
                    esc_html__('Slide Type 2', 'helpmate') => 'carousel_type_2',
                    esc_html__('Slide Type 3', 'helpmate') => 'carousel_type_3',
                    esc_html__('Slide Type 4', 'helpmate') => 'carousel_type_4',
                ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('slide', 'slide_content'),
                ),
                "description" => esc_html__( "Select Slide type.", "helpmate" )
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", 'helpmate'),
                "param_name" => "title",
                'description' => esc_html__('Set the title for our team block', 'helpmate'),
                "admin_label" => true,
				'dependency' => array(
                    'element' => 'layout',
                    'value' => array('list'),
                ),
            ),     
            array(
                "type" => "number",
                "heading" => esc_html__("Number of post entries per page", 'helpmate'),
                "param_name" => "number",
                "value" => esc_html__(8, 'helpmate'),
                'description' => esc_html__('Set the total number of entries to show per page', 'helpmate'),
                "admin_label" => true,
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('grid' , 'list')
                )
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number of post entries per slide", 'helpmate'),
                "param_name" => "number_per_slide",
                "value" => esc_html__(2, 'helpmate'),
                'description' => esc_html__('Set max number of entries to show per slide', 'helpmate'),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('slide' , 'slide_content')
                )
            ),
			array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Text color', 'helpmate'),
                'param_name' => 'text_color',
            ),  
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_Testimonial')) {
        class WPBakeryShortCode_Helpmate_Testimonial extends WPBakeryShortCode {
        }
    }
}