<?php

// helpmate_work_progress
add_shortcode('helpmate_work_progress', 'helpmate_shortcode_work_progress');
add_action('vc_build_admin_page', 'helpmate_load_work_progress_shortcode');
add_action('vc_after_init', 'helpmate_load_work_progress_shortcode');

function helpmate_shortcode_work_progress($atts, $content = null) {
    ob_start();
    if ($template = Helpmate_shortcode_template('helpmate_work_progress'))
        include $template;
    return ob_get_clean();
}

function helpmate_load_work_progress_shortcode() {
    $custom_class = helpmate_vc_custom_class();

    vc_map( array(
        'name' => "[Helpmate] " . esc_html__('Work Progress', 'helpmate'),
        'base' => 'helpmate_work_progress',
        'category' => esc_html__('Helpmate', 'helpmate'),
        'icon' => 'helpmate_vc_icon',
		'is_container' => true,
        'js_view' => 'VcColumnView',
		"as_parent" => array('only' => 'helpmate_item_progress',),
        'weight' => - 50,
        "params" => array(
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','helpmate' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','helpmate' ),
            )            
        )
    ) );

    if (!class_exists('WPBakeryShortCode_Helpmate_Work_Progress')) {
        class WPBakeryShortCode_Helpmate_Work_Progress extends WPBakeryShortCodesContainer {
        }
    }
}