<?php
$output  = $number = $layout = $cat = $items_desktop_large = $items_desktop = $items_tablets = $items_mobile =  $el_class = '';
extract(shortcode_atts(array(
    'number' => 4,
	'layout' => 'list_3columns',
	'cat' => '',
    'items_desktop_large' => 3,
    'items_desktop' => 3,
    'items_tablets' => 3,
    'items_mobile' => 1,
    'el_class' => '',
    'css' => ''
), $atts));
if ( get_query_var('paged') ) {

    $paged = get_query_var('paged');

} elseif ( get_query_var('page') ) {

    $paged = get_query_var('page');

} else {

    $paged = 1;

}
$args = array(
	'paged' => $paged,
	'post_type' => 'post',
	'post_status' => 'publish',
	'order' => 'DESC',
	'orderby' => 'date',
	'posts_per_page' => $number,
);

$items_desktop_large_no= 12/$items_desktop_large;
$items_desktop_no= 12/$items_desktop;
$items_tablets_no = 12/$items_tablets;
$items_mobile_no = 12/$items_mobile;
$layout_class = '';
$layout_class_list = '';
if($layout == 'list_4columns'){
    $layout_class = ' tips_section ';
	$layout_class_list = ' row ';
}
if($layout == 'list_3columns'){
    $layout_class_list = ' ';
}
if ($cat){
    $args['cat'] = $cat;
}
$blog = new WP_Query($args);
if ($blog->have_posts()) {
	$slide_id = 'news_' . wp_rand();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'helpmate_blog', $atts );
    $el_class = helpmate_shortcode_extract_class( $el_class );
    $output = '<div class="blog-container' .esc_attr($el_class) . esc_attr($layout_class) . esc_attr($layout_class_list) . '"';        
    $output .= '>';
    ob_start();
    ?>
	<?php while ($blog->have_posts()) : $blog->the_post(); ?>
		<?php if($layout == 'list_3columns') :?>
			<div class="col-lg-<?php echo esc_attr($items_desktop_large_no);?> col-md-<?php echo esc_attr($items_desktop_no) ?> col-sm-<?php echo esc_attr($items_tablets_no) ?> col-xs-<?php echo esc_attr($items_mobile_no) ?> grid-item item">
				<div class="post_news">
					<div class="post_item">
						<div class="blog-main">
							<figure>
								<a href="<?php the_permalink(); ?>">
									<?php if(has_post_thumbnail()):
										$attachment_img = helpmate_get_attachment(get_post_thumbnail_id(), 'helpmate_blog_3_column');
									?>
	                               		<img width="<?php echo esc_attr($attachment_img['width']) ?>" height="<?php echo esc_attr($attachment_img['height']) ?>" src="<?php echo esc_url($attachment_img['src']) ?>" alt="<?php echo esc_attr($attachment_img['alt']) ?>" />
									<?php endif;?>
								</a>
							</figure>
							<div class="post_body">
								<div class="post_meta"><?php echo esc_html__('On','helpmate');?> <?php echo get_the_time('M d, Y'); ?></div>
								<a href="<?php the_permalink(); ?>"><h4><?php the_title(); ?></h4></a>
								 <?php the_excerpt(); ?> 
								<div class="post_social">
								  <div class="post_social_item clearfix">
									<div class="post_social_autor">
										<?php $author_id= $blog->post_author;?>
										<span><?php echo esc_html__('By:','helpmate');?> </span><a href="<?php echo esc_url(get_edit_user_link( $author_id )); ?>"><?php the_author_meta( 'nickname' , $author_id ); ?></a>
									</div>
									<div class="post_social_event">
									  <a href="<?php comments_link(); ?>" class="social_comment"><span>
									  <?php comments_number( '0', '1', '%' )?></span></a>
									</div>
								  </div>
								  <div class="post_social_item clearfix">
									<div class="post_social_autor">
									  <span><?php echo esc_html__('In:','helpmate');?> </span><?php echo get_the_category_list(', '); ?>
									</div>
									<div class="post_social_event">
									  <?php  if(function_exists('helpmate_getPostLikeLink')) {
										echo helpmate_getPostLikeLink( get_the_ID() );
										}
										?>
									</div>
								  </div>
								</div>
							</div>
						</div>
					</div>
				</div> 
			</div>
		<?php elseif($layout == 'list_4columns'): ?>
			<?php $featuredImage = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) ); ?>
			<div class="col-lg-<?php echo esc_attr($items_desktop_large_no);?> col-md-<?php echo esc_attr($items_desktop_no) ?> col-sm-<?php echo esc_attr($items_tablets_no) ?> col-xs-<?php echo esc_attr($items_mobile_no) ?> grid-item item">
				<div class="tip_item">
					<style type="text/css" scoped>
						.tip_item:before{
							background-image: url(<?php echo esc_url($featuredImage);?>);
						}
					</style>
					<div>
						<span><?php echo get_the_time('M d, Y'); ?></span> / <?php echo get_the_category_list(', '); ?> /
						<a href="<?php comments_link(); ?>" class="social_comment"><span>
						<?php comments_number( '0', '1', '%' )?></span> <?php echo esc_html__('comment(s)','helpmate');?></a>
					</div>
					<a href="<?php the_permalink(); ?>"><h4><?php the_title(); ?></h4></a>
					<?php the_excerpt(); ?> 
				</div>
			</div>
		<?php endif;?>
	<?php endwhile;
	wp_reset_postdata();
	?>
	<?php if($layout == 'slide') :?>
		<div class="carousel_type_1 post_area">
			<div id="<?php echo esc_attr($slide_id); ?>" class="owl-carousel">
				<?php while ($blog->have_posts()) : $blog->the_post(); ?>
					<div>
						<div class="item_wrapper">
							<figure class="item_img">
								<a href="<?php the_permalink(); ?>">
									<?php if(has_post_thumbnail()):
										$attachment_img = helpmate_get_attachment(get_post_thumbnail_id(), 'helpmate_blog_slider');
									?>
	                               		<img width="<?php echo esc_attr($attachment_img['width']) ?>" height="<?php echo esc_attr($attachment_img['height']) ?>" src="<?php echo esc_url($attachment_img['src']) ?>" alt="<?php echo esc_attr($attachment_img['alt']) ?>" />
									<?php endif;?>
								</a>
							</figure>
							<div class="item_block">
								<div class="item_social">
									<div>
										<?php $author_id= $blog->post_author;?>
										<span><?php echo esc_html__('By:','helpmate');?> </span><a href="<?php echo esc_url(get_edit_user_link( $author_id )); ?>"><?php the_author_meta( 'nickname' , $author_id ); ?></a>
									</div>
									<div>
										 <span><?php echo esc_html__('In:','helpmate');?> </span><?php echo get_the_category_list(', '); ?>
									</div>
								</div>
								<div class="item_info">
									<a href="<?php the_permalink(); ?>"><h5><?php the_title(); ?></h5></a>
									<?php the_excerpt(); ?> 
									<div class="clearfix post_social_event">
										<div class="f_left">
											<a href="<?php comments_link(); ?>" class="social_comment"><span>
											<?php comments_number( '0', '1', '%' )?></span></a>
											<?php  if(function_exists('helpmate_getPostLikeLink')) {
											echo helpmate_getPostLikeLink( get_the_ID() );
											}
											?>
										</div>
										<div class="f_right">
											<span><?php echo get_the_time('M d, Y'); ?></span>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endwhile; wp_reset_postdata(); ?>
			</div>
		</div>
		<script type="text/javascript">
			jQuery(function ($) {
				var owl = $("#<?php echo esc_js($slide_id); ?>");
				owl.owlCarousel({
					dots:false,
					loop:true,
					nav:true,
					navText: ["<i class='fa fa-angle-left'></i>","<i class='fa fa-angle-right'></i>"],
					items: 4,
					responsive : {
                        0:{
                            items:1,
                        },
						479:{
                            items:2,
                        },
                        767:{
                            items:3,
                        },
                        1200:{
                            items:4,
                        }
                    }     
				}); //end: owl
			});
		</script> 
	<?php endif;?>
    <?php
    $output .= ob_get_clean();

    $output .= '</div>' . helpmate_shortcode_end_block_comment( 'helpmate_blog' ) . "\n";

    echo $output;
    wp_reset_query();
}
