<?php
$output = $number = $carousel_type = $number_slide = $css = $el_class = '';
extract(shortcode_atts(array(
    'number' => 11,
	'clients_layout' => 'grid',
	'carousel_type' => 'carousel_type_1',
    'items_desktop_large' => 3,
    'items_desktop' => 3,
    'number_per_slide' => 4,
    'items_tablets' => 2,
    'items_mobile' => 1,
    'load_more' => 'yes',
    'item_delay' => 'yes',
    'el_class' => '',
    'css' => ''
), $atts));
$args = array(
    'post_type' => 'clients',
    'posts_per_page' => $number
);
$items_desktop_large_no= 12/$items_desktop_large;
$items_desktop_no= 12/$items_desktop;
$items_tablets_no = 12/$items_tablets;
$items_mobile_no = 12/$items_mobile;
$posts = new WP_Query($args);
if ($posts->have_posts()) {
    $el_class = helpmate_shortcode_extract_class( $el_class );
	$slide_id = 'clients_' . wp_rand();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'helpmate_clients', $atts );
	$output .= '<div class="clients' . esc_attr($el_class) . esc_attr($css_class ).'">';
    ob_start();
    
    ?>
		<?php if($clients_layout == 'slide_image') :?>
			<div class="<?php if($carousel_type == 'carousel_type_1'){echo 'carousel_type_1';} 
				if($carousel_type == 'carousel_type_2'){echo 'carousel_type_2';} 
				if($carousel_type == 'carousel_type_3'){echo 'carousel_type_3';} 
				if($carousel_type == 'carousel_type_4'){echo 'carousel_type_4';}
				 ?>">
				<div id="<?php echo esc_attr($slide_id); ?>" class="brand-content owl-carousel" data-max-items="<?php echo esc_attr($number_per_slide);?>" data-autoplay="true">
					<?php while ($posts->have_posts()) : $posts->the_post(); ?>
						<div class="item_holder">
							<div>
								<?php if (has_post_thumbnail()){
										$featuredImage = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
									}else{
										$featuredImage = get_template_directory_uri() . '/images/author_placeholder.jpg';
									}
								?>
							   <a href="<?php $link= get_post_meta(get_the_ID(), 'link', true);  echo esc_url($link); ?>"><img src="<?php echo esc_url($featuredImage); ?>" alt="clients"/></a>
							</div>
						</div>
					<?php endwhile; ?>
				</div>
			</div>
		<?php elseif($clients_layout == 'grid'): ?>
			<div class="grid_list">
				<div class="row <?php if ( $css_class ){echo $css_class;}?>">
					<?php while ($posts->have_posts()) : $posts->the_post(); ?>
						<div class="col-lg-<?php echo esc_attr($items_desktop_large_no);?> col-md-<?php echo esc_attr($items_desktop_no) ?> col-sm-<?php echo esc_attr($items_tablets_no) ?> col-xs-<?php echo esc_attr($items_mobile_no) ?>">
							<?php if (has_post_thumbnail()){
									$featuredImage = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
								}else{
									$featuredImage = get_template_directory_uri() . '/images/author_placeholder.jpg';
								}
							?>
						   <a href="<?php $link= get_post_meta(get_the_ID(), 'link', true);  echo esc_url($link); ?>"><img src="<?php echo esc_url($featuredImage); ?>" alt="clients"/></a>
						</div>
					<?php endwhile; ?>
				</div>
			</div>
		<?php elseif($clients_layout == 'slide_content'): ?>
			<div class="<?php if($carousel_type == 'carousel_type_1'){echo 'carousel_type_1';} 
				if($carousel_type == 'carousel_type_2'){echo 'carousel_type_2';} 
				if($carousel_type == 'carousel_type_3'){echo 'carousel_type_3';} 
				if($carousel_type == 'carousel_type_4'){echo 'carousel_type_4';}
				 ?> with_thumbs">
				<div id="<?php echo esc_attr($slide_id); ?>" class="owl-carousel" data-max-items="<?php echo esc_attr($number_per_slide);?>" data-autoplay="true" >
					<?php while ($posts->have_posts()) : $posts->the_post(); ?>
						<blockquote class="var3">
							<?php the_content();?>
							<div class="author_info">
								<b>- <?php echo get_post_meta(get_the_ID(),'client_name',true);?></b>, 
								<?php echo esc_html(get_post_meta(get_the_ID(),'address', true));?>
							</div>
						</blockquote>
					<?php endwhile; ?>
				</div>
			</div>
		<?php elseif($clients_layout == 'list_content'): ?>
			<?php while ($posts->have_posts()) : $posts->the_post(); ?>
				<blockquote>
					<?php the_content();?>
					<div class="author_info">
						- <?php echo get_post_meta(get_the_ID(),'client_name',true);?>
					</div>
				</blockquote>
			<?php endwhile; ?>
		<?php elseif($clients_layout == 'slide_content_with_title'): ?>
			<div class="<?php if($carousel_type == 'carousel_type_1'){echo 'carousel_type_1';} 
				if($carousel_type == 'carousel_type_2'){echo 'carousel_type_2';} 
				if($carousel_type == 'carousel_type_3'){echo 'carousel_type_3';} 
				if($carousel_type == 'carousel_type_4'){echo 'carousel_type_4';}
				 ?> with_thumbs">
				<div id="<?php echo esc_attr($slide_id); ?>" class="owl-carousel" data-max-items="<?php echo esc_attr($number_per_slide);?>" data-autoplay="true">
					<?php while ($posts->have_posts()) : $posts->the_post(); ?>
						<div class="client-title">
							<div class="quote_holder">
								<blockquote class="var2">
									<h5><?php echo esc_html(get_post_meta(get_the_ID(),'client_title', true));?></h5>
									<?php the_content();?>
								</blockquote>
							</div>
							<div class="author_info">
								<b><?php echo get_post_meta(get_the_ID(),'client_name',true);?></b> - 
								<?php echo esc_html(get_post_meta(get_the_ID(),'address', true));?>
							</div>
						</div>
					<?php endwhile; ?>
				</div>
			</div>
		<?php else:?>
			<div class="<?php if($carousel_type == 'carousel_type_1'){echo 'carousel_type_1';} 
				if($carousel_type == 'carousel_type_2'){echo 'carousel_type_2';} 
				if($carousel_type == 'carousel_type_3'){echo 'carousel_type_3';} 
				if($carousel_type == 'carousel_type_4'){echo 'carousel_type_4';}
				 ?> with_thumbs">
				<div id="<?php echo esc_attr($slide_id); ?>" class="owl-carousel" data-max-items="<?php echo esc_attr($number_per_slide);?>" data-autoplay="true">
					<?php while ($posts->have_posts()) : $posts->the_post(); ?>
						<blockquote>
							<?php the_content();?>
							<div class="author_info">
								- <?php echo get_post_meta(get_the_ID(),'client_name',true);?>
							</div>
						</blockquote>
					<?php endwhile; ?>
				</div>
			</div>
		<?php endif;?>
    <?php
	
    $output .= ob_get_clean();

    $output .= '</div>' . helpmate_shortcode_end_block_comment( 'helpmate_clients' ) . "\n";
    echo $output;
}

wp_reset_postdata();