<?php
$output = $number = $show_icon = $title = $css = $el_class = '';
extract(shortcode_atts(array(
    'number' => 8,
    'title' => '',
    'type' => '',    
    'show_icon' => 'yes',
    'icon_linecons' => '',
    'icon_fontawesome' => '',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_fontello' => '',
    'icon_monosocial' => '',
    'icon_entypo' => '',
    'el_class' => '',
    'css' => '',
), $atts));

$icon_class = "icon_counter";
if (!empty($icon_fontello)) {
    $icon_class = $icon_fontello;
} elseif (!empty($icon_fontawesome)) {
    $icon_class = $icon_fontawesome;
} elseif (!empty($icon_openiconic)) {
    $icon_class = $icon_openiconic;
} elseif (!empty($icon_typicons)) {
    $icon_class = $icon_typicons;
} elseif (!empty($icon_entypo)) {
    $icon_class = $icon_entypo;
} elseif (!empty($icon_linecons)) {
    $icon_class = $icon_linecons;
} elseif (!empty($icon_monosocial)) {
    $icon_class = $icon_monosocial;
}

if ($type == 'fontello') {
    wp_enqueue_style('fontello');
} else {
    vc_icon_element_fonts_enqueue($type);
}
    $el_class = helpmate_shortcode_extract_class( $el_class );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'helpmate_counter', $atts );


    ob_start();
    $output .= '<div class="helpmate_counter' . esc_attr($el_class) . esc_attr($css_class ). '">';
    ?>
        <div class="p_table_stat" data-counter="<?php echo esc_attr($number);?>">
            <h2 class="counter_output"><?php echo esc_html__('0','helpmate');?></h2>
            <?php if($show_icon == 'yes'):?>
                <div class="align_right">
                    <div class="p_icon"><span class="<?php echo esc_attr($icon_class); ?>"></span></div>
                </div>
            <?php endif;?>
            <h6><?php echo esc_html($title,'helpmate');?></h6>
        </div>
    <?php
    $output .= ob_get_clean();

    $output .= '</div>' . helpmate_shortcode_end_block_comment( 'helpmate_counter' ) . "\n";
    echo $output;
