<?php
$output = $number = $number_per_slide= $filter_style = $cat = $layout = $description = $item_delay  = $css = $el_class = '';
extract(shortcode_atts(array(
    'number' => 8,
    'title' => '',
    'layout' => '',
    'category_parent' => '',
    'filter_style' => '',
    'number_per_slide' => 3,
    'description' => '',
    'item_delay' => 'yes',
    'el_class' => '',
    'css' => '',
), $atts));
if ( get_query_var('paged') ) {
    $paged = get_query_var('paged');
} elseif ( get_query_var('page') ) {
    $paged = get_query_var('page');
} else {
    $paged = 1;
}
if ($layout == 'grid' || $layout == 'masonry') {
    $args = array(
        'paged' => $paged,
        'post_type' => 'gallery',
        'post_status' => 'publish',
        'posts_per_page' => $number,
    );
}else {
    $args = array(
        'post_type' => 'gallery',
        'posts_per_page' => $number
    );
}

if ($category_parent){
    $catArray = explode(',', $category_parent);
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'gallery_cat',
            'field'    => 'term_id',
            'terms'    => $catArray,
        ),
    );
}

$posts = new WP_Query($args);
if ($posts->have_posts()) {
    $el_class = helpmate_shortcode_extract_class( $el_class );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'helpmate_gallery', $atts );


    ob_start();
    $output .= '<div class="gallery' . esc_attr($el_class) . esc_attr($css_class ). '">';
    //delay item
    $count_item = 0.5; 
    $animation_delay = '';
    if($item_delay) {
        $animation_delay = ' data-sr="enter bottom wait '. $count_item .'s"';  
    }
    $count_item += 0.2;
    ?>
    

    <?php 
    $taxonomy_names = get_object_taxonomies( 'gallery' );

    if ( is_array( $taxonomy_names ) && count( $taxonomy_names ) > 0  && in_array( 'gallery_cat', $taxonomy_names ) ) {
        if($category_parent){
            $terms = get_terms( 'gallery_cat', array(
            'hide_empty'        => false,
            'parent' => $category_parent, 
            'order' => 'random'
            ) );
        }else{
            $terms = get_terms( 'gallery_cat', array(
                'hide_empty'        => false,
                
                ) );            
        }
    }

    ?>

    <div class="container">
        <?php if($title !="") :?>
            <h2 class="main_title" <?php echo $animation_delay; ?>><?php echo esc_html($title); ?></h2>
            <p class="align_center mad_bottom" <?php echo $animation_delay; ?>><?php echo wp_kses( $description, array('br' => array()));?></p>
        <?php endif;?>    

    </div>
    <?php if($layout == 'filter'):?>
        <div class="container extra">
            <div class="tabs_sort">

                <div id="options">
                    <?php if($filter_style == 'style_1'): ?>
                        <div id="filters" class="button-group js-radio-button-group">
                            <button class="is-checked" data-filter="*"><?php echo esc_html__('All','helpmate'); ?></button>
                            <b>/</b>  
                            <?php foreach ( $terms as $key => $term ) : ?> 
                                <button data-filter=".<?php echo esc_attr($term->slug); ?>"><?php echo $term->name; ?></button>
                                <b>/</b>
                            <?php endforeach;?>  
                        </div>                    
                    <?php else:?>
                    <div id="filters" class="button-group js-radio-button-group">
                        <button class="is-checked" data-filter="*"><?php echo esc_html__('All','helpmate'); ?></button>  
                        <?php foreach ( $terms as $key => $term ) : ?> 
                            <button data-filter=".<?php echo esc_attr($term->slug); ?>"><?php echo $term->name; ?></button>
                        <?php endforeach;?>  
                    </div>
                    <?php endif;?>
                </div>
                <div class="isotope clearfix" data-isotope-options='{"itemSelector" : ".item","layoutMode" : "masonry","transitionDuration":"0.7s","masonry" : {"columnWidth":".item"}}'>
                <?php while ($posts->have_posts()) : $posts->the_post(); ?>
                    <?php 
                        $post_term_arr = get_the_terms( get_the_ID(), 'gallery_cat' );
                        $post_term_filters = '';
                        $post_term_names = '';
                        if($post_term_arr > 1){
                        foreach ( $post_term_arr as $post_term ) {

                            $post_term_filters .= $post_term->slug . ' ';
                            $post_term_names .= $post_term->name . ', ';
                            }
                        }
                        $post_term_filters = trim( $post_term_filters );
                        $post_term_names = substr( $post_term_names, 0, -2 );
                        $author = get_the_author();
                    ?>
                      <div class="item <?php echo esc_attr($post_term_filters);?>">
                        <figure>
                            <?php 
                                if ( has_post_thumbnail() ) : ?>
                                    <?php $attachment_img = helpmate_get_attachment(get_post_thumbnail_id(), 'helpmate_gallery'); ;?>
                                   <img width="<?php echo esc_attr($attachment_img['width']) ?>" height="<?php echo esc_attr($attachment_img['height']) ?>" src="<?php echo esc_url($attachment_img['src']) ?>" alt="<?php echo esc_attr($attachment_img['alt']) ?>" />
                                <?php endif;
                            ?>

                            <figcaption>
                                <div class="caption_block">
                                  <div class="item_desc">
                                    <?php echo get_the_term_list(get_the_ID(),'gallery_cat', '', ', ' ); ?>
                                    <a href="<?php the_permalink(); ?>" class="project_title"><h4><?php the_title();?></h4></a>
                                    <?php echo wp_trim_words( get_the_content(), 20, '' );?>
                                  </div>
                                </div>
                            </figcaption>
                        </figure>

                      </div>

                <?php endwhile;?>
                </div>
            </div>
        </div>
    <?php elseif($layout == 'grid'):?>
        <div class="row">
            <div class="mad_blog mad_portfolio portfolio_grid">
                <div class="tabs_sort post_area var2 type2">
                    <?php if (is_array( $terms ) && count( $terms ) > 0 ) : ?>
                      <div id="options">
                        <div id="filters" class="button-group js-radio-button-group">
                          <button class="is-checked" data-filter="*"><?php esc_html_e( 'All', 'helpmate' );?></button>
                          <?php foreach ( $terms as $term ) : ?>    
                          <button data-filter=".<?php echo esc_attr($term->slug); ?>"><?php echo $term->name; ?></button>
                          <?php endforeach;?>  
                        </div>
                      </div>
                    <?php endif;?>    

                  <div class="gallery-entries-wrap isotope four_collumn clearfix post_news" data-isotope-options='{"itemSelector" : ".item","layoutMode" : "fitRows","transitionDuration":"0.7s","fitRows" : {"columnWidth":".item"}}'>
                    <?php while ($posts->have_posts()) : $posts->the_post(); ?>
                        <?php 
                            $post_term_arr = get_the_terms( get_the_ID(), 'gallery_cat' );
                            $post_term_filters = '';
                            $post_term_names = '';

                            foreach ( $post_term_arr as $post_term ) {

                                $post_term_filters .= $post_term->slug . ' ';
                                $post_term_names .= $post_term->name . ', ';
                            }

                            $post_term_filters = trim( $post_term_filters );
                            $post_term_names = substr( $post_term_names, 0, -2 );
                            $author = get_the_author_link();
                        ?>
                        <div class="item <?php echo esc_attr($post_term_filters);?>">

                          <div class="post_item">
                            <?php if ( has_post_thumbnail() ) : ?>
                            <figure>
                              <div class="post_image plus_link">
                                    <?php 
                                    $image_url = wp_get_attachment_url( get_post_thumbnail_id() );
                                    $attachment_id = get_post_thumbnail_id();
                                    $attachment_grid = helpmate_get_attachment($attachment_id, 'helpmate_portfolio_grid'); 
                                    ?>
                                    <img class="img-responsive" width="<?php echo esc_attr($attachment_grid['width']) ?>" height="<?php echo esc_attr($attachment_grid['height']) ?>" src="<?php echo esc_url($attachment_grid['src']) ?>" alt="<?php echo esc_attr($attachment_grid['alt']) ?>" />
                                    <div class="curtain two_items">
                                      <a href="<?php echo esc_url($image_url);?>" class="gallery" rel="category"></a>
                                      <a href="<?php the_permalink();?>" class="link" rel="category"></a>
                                    </div>
                              </div>
                            </figure>
                            <?php endif;?>  
                            <div class="post_body">
                              <a href="<?php the_permalink();?>"><h4><?php the_title();?></h4></a>
                              <div class="post_social">
                                <div class="post_social_item clearfix">
                                  <div class="post_social_autor">
                                  <?php $author_id= $posts->post_author;?>
                                    <span><?php esc_html_e( 'By:', 'helpmate' );?> </span><a href="<?php echo esc_url(get_edit_user_link( $author_id )); ?>"><?php echo $author;?></a>
                                  </div>
                                  <div class="post_social_event">
                                    <?php comments_popup_link('<span>'.esc_html__('0', 'helpmate').'</span>', '<span>'.esc_html__('1', 'helpmate').'</span>', '<span>'.esc_html__('%', 'helpmate').'</span>', 'social_comment'); ?>
                                  </div>
                                </div>
                                <div class="post_social_item clearfix">
                                  <div class="post_social_autor">
                                    <span><?php echo esc_html__('In:','helpmate');?> </span><?php echo get_the_term_list($posts->ID,'gallery_cat', '', ', ' ); ?>
                                  </div>
                                </div>
                              </div>
                              <?php
                                the_content();
                               ?> 
                            </div>
                            <a href="<?php the_permalink(); ?>" class="button type1"><span><span><?php esc_html_e( 'Read More', 'helpmate' );?></span><span><?php esc_html_e( 'Read More', 'helpmate' );?></span></span></a>
                            <a href="<?php the_permalink(); ?>" class="button type1"><span><span><?php esc_html_e( 'View Project', 'helpmate' );?></span><span><?php esc_html_e( 'View Project', 'helpmate' );?></span></span></a>
                          </div>
                        </div>
                    <?php endwhile;?>
                  </div>
                  
                </div>
                <?php if ($posts->max_num_pages > 1) : ?>
                <div class="align_center">
                  <a class="portfolio_ajax_load_more button type1 load-more" data-paged="<?php echo esc_attr($paged) ?>" data-totalpage="<?php echo esc_attr($posts->max_num_pages) ?>"><span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span></span></a>
                </div>  
                <?php endif;?>
            </div>  
        </div>
    <?php elseif($layout == 'masonry'):?>
        <div class="row">
            <div class="tabs_sort post_area var2 type2 mad_bottom3">
                <?php if (is_array( $terms ) && count( $terms ) > 0 ) : ?>
                  <div id="options">
                    <div id="filters" class="button-group js-radio-button-group">
                      <button class="is-checked" data-filter="*"><?php esc_html_e( 'All', 'helpmate' );?></button>
                      <?php foreach ( $terms as $term ) : ?>    
                      <button data-filter=".<?php echo esc_attr($term->slug); ?>"><?php echo $term->name; ?></button>
                      <?php endforeach;?>  
                    </div>
                  </div>
                <?php endif;?>  

                  <div class="isotope three_collumn clearfix gallery-entries-wrap" data-isotope-options='{"itemSelector" : ".item","layoutMode" : "masonry","transitionDuration":"0.7s","masonry" : {"columnWidth":".item"}}'>
                    <?php while ($posts->have_posts()) : $posts->the_post(); ?>
                        <?php 
                            $post_term_arr = get_the_terms( get_the_ID(), 'gallery_cat' );
                            $post_term_filters = '';
                            $post_term_names = '';

                            foreach ( $post_term_arr as $post_term ) {

                                $post_term_filters .= $post_term->slug . ' ';
                                $post_term_names .= $post_term->name . ', ';
                            }

                            $post_term_filters = trim( $post_term_filters );
                            $post_term_names = substr( $post_term_names, 0, -2 );
                            $author = get_the_author();
                        ?>
                        <div class="item <?php echo esc_attr($post_term_filters);?>">
                          <div class="item_holder">
                            <?php 
                            if( class_exists('Dynamic_Featured_Image') ):
                            global $dynamic_featured_image;
                            $featured_images = $dynamic_featured_image->get_featured_images( $posts->ID );

                                if ( $featured_images ): ?>
                                        <?php foreach( $featured_images as $images ): ?>
                                            <figure class="item_img">
                                                <img src="<?php echo esc_url($images['full']) ?>" alt="gallery">
                                            </figure>
                                        <?php endforeach; ?>
                                <?php
                                endif;
                            else :
                                if ( has_post_thumbnail() ) : ?>
                                <figure class="item_img"><?php the_post_thumbnail();?></figure>
                                <?php endif;
                            endif;
                            ?>
                            <div class="caption_block">
                              <div class="item_desc">
                                <div class="item_desc_inner post_news">
                                  <h4><?php the_title();?></h4>
                                  <div class="post_social">
                                    <div class="post_social_item clearfix">
                                      <div class="post_social_autor">
                                        <span><?php esc_html_e( 'By:', 'helpmate' );?> </span><?php echo $author;?>
                                      </div>
                                      <div class="post_social_event">
                                        <?php  if(function_exists('helpmate_getPostLikeLink')) {
                                                    echo helpmate_getPostLikeLink( get_the_ID() );
                                        } ?>
                                      </div>
                                    </div>
                                    <div class="post_social_item clearfix">
                                      <div class="post_social_autor">
                                         <span><?php esc_html_e( 'In:', 'helpmate' );?> </span><?php echo get_the_term_list($posts->ID,'gallery_cat', '', ', ' ); ?>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="social_icon_list">
                                    <ul>
                                      <li>
                                        <?php $image_url = wp_get_attachment_url( get_post_thumbnail_id() );?>
                                        <div class="curtain">
                                          <a href="<?php echo esc_url($image_url);?>" class="soc_icon gallery fancybox" rel="category"></a>
                                        </div>

                                      </li>
                                      <li>

                                        <a href="<?php the_permalink();?>" class="soc_icon icon-link"></a>

                                      </li>
                                    </ul>
                                  </div>
                                </div>
                              </div>
                            </div>
                            
                          </div>

                        </div>  
                    <?php endwhile;?>      
                  </div>
                  <?php if ($posts->max_num_pages > 1) : ?>
                      <div class="align_center">
                        <a class="portfolio_ajax_load_more button type1 load-more" data-paged="<?php echo esc_attr($paged) ?>" data-totalpage="<?php echo esc_attr( $posts->max_num_pages) ?>"><span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span></span></a>
                      </div>
                  <?php endif;?>          
            </div> 
        </div> 
    <?php else:?>
        <div class="carousel_type_4">          
          <div class="owl-carousel" data-max-items="3">
            <?php while ($posts->have_posts()) : $posts->the_post(); ?>
            <!-- Slide -->
            <div>
                <!-- Carousel Item -->
                <div class="item_wrapper">
                    <figure class="item_img"><a href="<?php the_permalink(); ?>">
                    <?php 
                        if ( has_post_thumbnail() ) : ?>
                            <?php $attachment_img = helpmate_get_attachment(get_post_thumbnail_id(), 'helpmate_gallery_slider'); ;?>
                           <img width="<?php echo esc_attr($attachment_img['width']) ?>" height="<?php echo esc_attr($attachment_img['height']) ?>" src="<?php echo esc_url($attachment_img['src']) ?>" alt="<?php echo esc_attr($attachment_img['alt']) ?>" />
                        <?php endif;
                    ?>
                    </a></figure>

                </div>
                <!-- /Carousel Item -->
            </div>
            <!-- /Slide -->
            <?php endwhile;?>
            </div>
        </div>   
    <?php endif;?>
    <?php
    $output .= ob_get_clean();

    $output .= '</div>' . helpmate_shortcode_end_block_comment( 'helpmate_gallery' ) . "\n";
    echo $output;

wp_reset_postdata();
}