<?php
$output = $number = $number_per_slide = $description = $css = $el_class = '';
extract(shortcode_atts(array(
    'number' => 8,
    'title' => '',
    'description' => '',
    'number_per_slide' => 3,
    'el_class' => '',
    'css' => '',
), $atts));
$args = array(
    'post_type' => 'office',
    'posts_per_page' => $number
);

$posts = new WP_Query($args);

if ($posts->have_posts()) {
    $el_class = helpmate_shortcode_extract_class( $el_class );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'helpmate_office', $atts );


    ob_start();
    $output .= '<div class="team' . esc_attr($el_class) . esc_attr($css_class ). '">';
    ?>
    
    <?php if($title !="") :?>
            <h2><?php echo esc_attr($title); ?></h2>
            <p class="mad_bottom"><?php echo wp_kses( $description, array('br' => array()));?></p>
    <?php endif;?>
        <div class="carousel_type_1 post_area var2 type2">
            
            <div class="owl-carousel" data-max-items="<?php echo esc_attr($number_per_slide);?>">
             <?php while ($posts->have_posts()) : $posts->the_post(); ?>
              <!-- Slide -->
                <div>
                <!-- Carousel Item -->
                    <div class="item_holder post_image plus_link">  
                        <?php if (has_post_thumbnail()){
                                $featuredImage = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
                            }else{
                                $featuredImage = get_template_directory_uri() . '/images/author_placeholder.jpg';
                            }
                        ?>
                        <figure class="item_img"><img src="<?php echo esc_url($featuredImage); ?>" alt="office"></figure>
                        <div class="caption_block">
                            <div class="item_desc">
                                <div class="curtain">
                                    <a href="<?php echo esc_url($featuredImage); ?>" class="gallery" rel="category"></a>
                            </div>
                        </div>
                      </div>
                  
                    </div>
                <!-- /Carousel Item -->
                </div>
              <?php endwhile; ?>
            </div>
        </div>       
    
    <?php
    $output .= ob_get_clean();

    $output .= '</div>' . helpmate_shortcode_end_block_comment( 'helpmate_office' ) . "\n";
    echo $output;
}

wp_reset_postdata();