<?php
$output = $number = $items_desktop = $number_per_slide= $layout = $description  = $css = $el_class = '';
extract(shortcode_atts(array(
    'number' => 8,
    'title' => '',
    'layout' => '',
    'number_per_slide' => 3,
    'description' => '',
    'items_desktop' => 3,
    'el_class' => '',
    'css' => '',
), $atts));
$args = array(
    'post_type' => 'member',
    'posts_per_page' => $number
);

$posts = new WP_Query($args);
$items_desktop_no= 12/$items_desktop;

if ($posts->have_posts()) {
    $el_class = helpmate_shortcode_extract_class( $el_class );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'helpmate_our_team', $atts );


    ob_start();
    $output .= '<div class="team' . esc_attr($el_class) . esc_attr($css_class ). '">';
    ?>
    
    <?php if($title !="") :?>
            <h2><?php echo esc_attr($title); ?></h2>
            <p class="mad_bottom"><?php echo wp_kses( $description, array('br' => array()));?></p>
    <?php endif;?>
    <?php if($layout == 'slide'):?>
        <div class="carousel_type_1 post_area var2 type2">              
            <div class="owl-carousel" data-max-items="<?php echo esc_attr($number_per_slide);?>"  data-autoplay="true">
                <?php while ($posts->have_posts()) : $posts->the_post(); ?>
                    <div >
                        <?php helpmate_get_team();?>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    <?php else:?>
        <div class="grid_list post_area var2 type2">
            <div class="row">
                <?php while ($posts->have_posts()) : $posts->the_post(); ?>
                        <div class="col-sm-<?php echo esc_attr($items_desktop_no);?>">
                            <?php helpmate_get_team();?>
                        </div>
                <?php endwhile; ?>
            </div>   
        </div>     
    <?php endif;?>
    <?php
    $output .= ob_get_clean();

    $output .= '</div>' . helpmate_shortcode_end_block_comment( 'helpmate_our_team' ) . "\n";
    echo $output;
}

wp_reset_postdata();

function helpmate_get_team(){
        if (has_post_thumbnail()){
            $featuredImage = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
        }else{
            $featuredImage = get_template_directory_uri() . '/images/author_placeholder.jpg';
        }
    ?>                    
    <div class="item_holder">
        <figure class="item_img"><img src="<?php echo esc_url($featuredImage); ?>" alt="member"></figure>
        <div class="caption_block">
            <div class="item_desc">
                <div class="item_desc_inner">
                    <?php the_content();?>
                
                    <?php 
                        $fb = get_post_meta(get_the_ID(),'facebook', true);
                        $twitter = get_post_meta(get_the_ID(),'twitter', true);
                        $instagram = get_post_meta(get_the_ID(),'insta', true);
                        $mail = get_post_meta(get_the_ID(),'mail', true);
                        $job = get_post_meta(get_the_ID(),'job',true);    
                    ?>
                    <?php if($fb!='' || $twitter!="" || $instagram!="" || $mail!=''):?>
                    <div class="social_icon_list">
                        <ul>
                            <?php if($fb!=''):?>
                                <li><a href="<?php echo esc_url($fb);?>" class="soc_icon icon_facebook"></a></li>
                            <?php endif;?>
                            <?php if($twitter!=''):?>
                                <li><a href="<?php echo esc_url($twitter);?>" class="soc_icon icon_twitter"></a></li>
                            <?php endif;?>
                            <?php if($mail!=''):?>
                                <li><a href="<?php echo esc_url($mail);?>" class="soc_icon icon_mail"></a></li>
                            <?php endif;?>                                                
                            <?php if($instagram!=''):?>
                                <li><a href="<?php echo esc_url($instagram);?>" class="soc_icon icon_instagram"></a></li>
                            <?php endif;?>                                               
                        </ul>
                    </div>
                    <?php endif;?> 
                </div> 
            </div>
        </div>
    </div>
    <div class="user_info">
        <h5><b><?php the_title();?></b></h5>
        <?php if($job != ''): ?>
            <p><?php echo $job;?></p>
        <?php endif;?>
    </div>
    <?php
}