<?php
/*
  Plugin Name: Helpmate Instagram Feed
  Plugin URI:
  Description: Helpmate Instagram Feed for Helpmate Theme.
  Version: 1.0.0
  Author: AHT
  Author URI:
 */

// Block direct requests
if ( !defined('ABSPATH') )
    die('-1');
    
require_once dirname(__FILE__) . '/settings.php';    

/**
 * Adds helpmate_instagram_feed widget.
 */
class helpmate_instagram_feed extends WP_Widget {
    /**
     * Register widget with WordPress.
     */
    function __construct() {
        parent::__construct(
            'helpmate_instagram_feed', // Base ID
            __('Helpmate Instagram Feed', 'helpmate'), // Name
            array( 'description' => __( 'Helpmate Instagram Feed', 'helpmate' ), ) // Args
        );
    }
    function loadJs() {
        wp_enqueue_script('helpmate_instagram', plugin_dir_url(__FILE__) . '/js/instagramfeed.js', array(), false, false);
    }
    // load plugin text domain
    function loadTextDomain() {
        load_plugin_textdomain('helpmate', false, dirname(__FILE__) . '/languages/');
    }
    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        $options = get_option('helpmate_instagram');
        $access_token = $options['access_token'];
        $user_id = $options['user_id'];

        extract( $args );
        $title = apply_filters( 'widget_title', $instance['title'] );
 
        echo $before_widget;
        ?>

        <?php if ($access_token != '' && $user_id != ''): ?>
            <?php
            $url = 'https://api.instagram.com/v1/users/' . $user_id . '/media/recent/?access_token=' . $access_token;
            $all_result = $this->process_url($url);

            $decoded_results = json_decode($all_result, true);
        ?>
            <h5 class="widget_title"><?php echo $title; ?></h5>
            <div class="instagram-container">
              <div class="media-grid">
                <?php if (count($decoded_results) && isset($decoded_results['data'])) : ?>
                    <?php if($instance['number'] <=16):?>
            
                            <div class="media-grid">
                              <?php foreach (array_slice($decoded_results['data'], 0, $instance['number']) as $value): ?>
                                <div class="media-item">
                                  <div class="social-links">
                                    <a href="http://www.facebook.com/sharer.php?u=<?php echo urlencode(esc_url($value['link'])); ?>" target="_blank"><i class="fa fa-facebook"></i></a>
                                    <a class="twitter" href="https://twitter.com/share?url=<?php echo urlencode(esc_url($value['link'])); ?>&amp;text=<?php echo urlencode(esc_attr($value['caption']['text'])); ?>" target="_blank"><i class="fa fa-twitter"></i></a>
                                  </div>
                                  <div class="div-img" style="background-image: url(<?php echo esc_url($value['images']['thumbnail']['url']) ?>)">      
                                  </div>
                                </div>
                              <?php endforeach; ?>                                
                            </div>
                    <?php else:?>
                            <div class="media-grid">
                              <?php foreach (array_slice($decoded_results['data'], 0, $instance['number']) as $value): ?>
                                <div class="media-item">
                                  <div class="social-links">
                                    <a href="http://www.facebook.com/sharer.php?u=<?php echo urlencode(esc_url($value['link'])); ?>" target="_blank"><i class="fa fa-facebook"></i></a>
                                    <a class="twitter" href="https://twitter.com/share?url=<?php echo urlencode(esc_url($value['link'])); ?>&amp;text=<?php echo urlencode(esc_attr($value['caption']['text'])); ?>" target="_blank"><i class="fa fa-twitter"></i></a>
                                  </div>
                                  <div class="div-img" style="background-image: url(<?php echo esc_url($value['images']['thumbnail']['url']) ?>)">      
                                  </div>
                                </div>
                              <?php endforeach; ?>                                
                            </div>
                    <?php endif;?>
                        
                <?php endif; ?>
              </div>
            </div>
        <?php endif; ?>
        <?php
        echo $after_widget;
    }
    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        $defaults = array( 
            'title' => 'Instagram', 
            'number' => 16,
            );
        $instance = wp_parse_args( (array) $instance, $defaults );
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" type="text" name="<?php echo $this->get_field_name('title'); ?>'" value="<?php echo $instance['title']; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of photos to display (Less than or equal to 16):'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" type="text" name="<?php echo $this->get_field_name('number'); ?>" value="<?php echo $instance['number']; ?>" />
        </p>
       
       
        <?php 
    }
    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        
        $instance['number'] = ( ! empty( $new_instance['number'] ) ) ? strip_tags( $new_instance['number'] ) : '';
        return $instance;
    }
    function process_url($url) {
        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => 2
        ));

        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }
} // class My_Widget

add_action( 'widgets_init', function(){
     register_widget( 'helpmate_instagram_feed' );
}); 
?>