<?php

/**
 * For full documentation, please visit: http://docs.reduxframework.com/
 * For a more extensive sample-config file, you may look at:
 * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
 */
if (!class_exists('Redux')) {
    return;
}

// This is your option name where all the Redux data is stored.
$opt_name = "litae_options";

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */
$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    'opt_name' => 'litae_options',
    'use_cdn' => FALSE,
    'display_name' => 'Litae Options',
    'display_version' => '1.0.0',
    'page_title' => 'Litae Options',
    'update_notice' => TRUE,
    'menu_type' => 'menu',
    'menu_title' => 'Litae Theme Options',
    'allow_sub_menu' => TRUE,
    'page_parent_post_type' => 'your_post_type',
    'customizer' => TRUE,
    'default_mark' => '*',
    'hints' => array(
        'icon_position' => 'right',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'light',
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect' => array(
            'show' => array(
                'duration' => '500',
                'event' => 'mouseover',
            ),
            'hide' => array(
                'duration' => '500',
                'event' => 'mouseleave unfocus',
            ),
        ),
    ),
    'output' => TRUE,
    'output_tag' => TRUE,
    'settings_api' => TRUE,
    'cdn_check_time' => '1440',
    'compiler' => TRUE,
    'page_permissions' => 'manage_options',
    'save_defaults' => TRUE,
    'show_import_export' => TRUE,
    'database' => 'options',
    'transient_time' => '3600',
    'network_sites' => TRUE,
);

// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
$args['share_icons'][] = array(
    'url' => 'https://github.com/ReduxFramework/ReduxFramework',
    'title' => 'Visit us on GitHub',
    'icon' => 'el el-github'
        //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
);
$args['share_icons'][] = array(
    'url' => 'https://www.facebook.com/pages/Redux-Framework/243141545850368',
    'title' => 'Like us on Facebook',
    'icon' => 'el el-facebook'
);
$args['share_icons'][] = array(
    'url' => 'http://twitter.com/reduxframework',
    'title' => 'Follow us on Twitter',
    'icon' => 'el el-twitter'
);
$args['share_icons'][] = array(
    'url' => 'http://www.linkedin.com/company/redux-framework',
    'title' => 'Find us on LinkedIn',
    'icon' => 'el el-linkedin'
);

Redux::setArgs($opt_name, $args);

/*
 * ---> END ARGUMENTS
 */

/*
 * ---> START HELP TABS
 */

$tabs = array(
    array(
        'id' => 'redux-help-tab-1',
        'title' => __('Theme Information 1', 'admin_folder'),
        'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'admin_folder')
    ),
    array(
        'id' => 'redux-help-tab-2',
        'title' => __('Theme Information 2', 'admin_folder'),
        'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'admin_folder')
    )
);
Redux::setHelpTab($opt_name, $tabs);

// Set the help sidebar
$content = __('<p>This is the sidebar content, HTML is allowed.</p>', 'admin_folder');
Redux::setHelpSidebar($opt_name, $content);


/*
 * <--- END HELP TABS
 */


/*
 * <--- Theme Options Settings
 */

// <editor-fold defaultstate="collapsed" desc="GENERAL SETTINGS">
Redux::setSection($opt_name, array(
    'title' => esc_html__('General Settings', 'litae-theme-plugin'),
    'icon' => 'el el-wrench',
        )
);
Redux::setSection($opt_name, array(
    'title'   => esc_html__('Menu', 'litae-theme-plugin'),
    'heading' => esc_html__('Menu Options', 'litae-theme-plugin'),
    'desc'    => wp_kses(__('These options affect your posts catalog display.<br>If you are using a speed optimization plugin, don\'t forget to clear cache after options update.', 'litae-theme-plugin'), array(
        'br' => array(),
    )),
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'menu_style',
            'title' => esc_html( 'Choose Menu Style', 'litae-theme-plugin' ),
            'type' => 'radio',
            'default' => 'light',
            'options' => array(
                'light' => 'Light',
                'dark' => 'Dark',
            ),
        ),
    )
));

// <editor-fold defaultstate="collapsed" desc="BLOG PAGE SETTINGS">
Redux::setSection($opt_name, array(
    'title' => esc_html__('Blog', 'litae-theme-plugin'),
    'heading' => esc_html__('Blog Options', 'litae-theme-plugin'),
    'desc' => wp_kses(__('These options affect your posts catalog display.<br>If you are using a speed optimization plugin, don\'t forget to clear cache after options update.', 'litae-theme-plugin'), array(
        'br' => array(),
    )),
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'blog_page-section-start',
            'type' => 'section',
            'title' => esc_html__('Blog Page Options', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Settings for Blog Page (index page)', 'litae-theme-plugin'),
            'indent' => true
        ),
        /* Main Layout */
        array(
            'id' => 'blog_page_layout',
            'type' => 'image_select',
            'title' => esc_html__('Main Layout', 'litae-theme-plugin'),
            'subtitle' => wp_kses(__('Select main content and sidebar alignment.<br>Choose between:<br>one column<br>two columns left sidebar<br>two columns right sidebar', 'litae-theme-plugin'), array(
                'br' => array(),
            )),
            'options' => array(
                'one-column' => array(
                    'alt' => esc_html__('one column', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                ),
                'two-columns-left' => array(
                    'alt' => esc_html__('two columns left', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                ),
                'two-columns-right' => array(
                    'alt' => esc_html__('two columns right', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                ),
            ),
            'default' => 'one-column'
        ),
        /* Blog Title */
        array(
            'id' => 'blog_page_title',
            'title' => esc_html__('Blog Title', 'litae-theme-plugin'),
            'type' => 'text',
            'default' => esc_html__('Journal', 'litae-theme-plugin'),
        ),
        /* Blog Title Font */
        array(
            'id' => 'blog_page_title_font',
            'title' => esc_html__('Blog Title Font', 'litae-theme-plugin'),
            'type' => 'select',
            'options' => array(
                'home-big-text' => 'Speck-Display',
                'home-big-text other-font' => 'Archivo Black',
            ),
            'default' => 'home-big-text other-font',
        ),
        /* Blog Title Animation */
        array(
            'id' => 'blog_page_title_animation',
            'title' => esc_html__('Blog Title Animation', 'litae-theme-plugin'),
            'type' => 'switch',
            'on' => 'Enable',
            'off' => 'Disable',
            'default' => '1',
        ),
        /* Blog Title Animation Color */
        array(
            'id' => 'blog_page_title_anim_color',
            'title' => esc_html__('Choose Animation Color', 'litae-theme-plugin'),
            'required' => array('blog_page_title_animation', '=', '1'),
            'type' => 'color',
            'default' => '#fcf652',
            'validate' => 'color',
            'transparent' => false,
        ),
        /* Blog Page Title Direction */
        array(
            'id' => 'blog_page_title_anim_direction',
            'title' => esc_html__('Choose Animation Direction', 'litae-theme-plugin'),
            'required' => array('blog_page_title_animation', '=', '1'),
            'type' => 'select',
            'options' => array(
                'lr' => esc_html__('Direction: left to right', 'litae-theme-plugin'),
                'rl' => esc_html__('Direction: right to left', 'litae-theme-plugin'),
                'tb' => esc_html__('Direction: top to bottom', 'litae-theme-plugin'),
                'bt' => esc_html__('Direction: bottom to top', 'litae-theme-plugin'),
            ),
            'default' => 'lr'
        ),
        /* Blog Subtitle */
        array(
            'id' => 'blog_page_subtitle',
            'title' => esc_html__('Blog Subtitle', 'litae-theme-plugin'),
            'subtitle' => __('You may use some html tags such as:<br><code> &lt;a&gt; &lt;br&gt; &lt;em&gt; and &lt;strong&gt; </code>', 'litae-theme-plugin'),
            'type' => 'textarea',
            'validate' => 'html_custom',
            'default' => __('I just don\'t know why<br>people can\'t use the word \'journal\'.', 'litae-theme-plugin'),
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title' => array()
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array()
            ),

        ),
        /* Blog Subitle Animation */
        array(
            'id' => 'blog_page_subtitle_animation',
            'title' => esc_html__('Blog Subtitle Animation', 'litae-theme-plugin'),
            'type' => 'switch',
            'on' => 'Enable',
            'off' => 'Disable',
            'default' => '1',
        ),
        /* Blog Page Subtitle Animation Color */
        array(
            'id' => 'blog_page_subtitle_anim_color',
            'title' => esc_html__('Choose Animation Color', 'litae-theme-plugin'),
            'required' => array('blog_page_subtitle_animation', '=', '1'),
            'type' => 'color',
            'default' => '#7f40f1',
            'validate' => 'color',
            'transparent' => false,
        ),
        /* Blog Page Subtitle Animation Direction */
        array(
            'id' => 'blog_page_subtitle_anim_direction',
            'title' => esc_html__('Choose Animation', 'litae-theme-plugin'),
            'required' => array('blog_page_subtitle_animation', '=', '1'),
            'type' => 'select',
            'options' => array(
                'lr' => esc_html__('Direction: left to right', 'litae-theme-plugin'),
                'rl' => esc_html__('Direction: right to left', 'litae-theme-plugin'),
            ),
            'default' => 'rl'
        ),
        /* Blog Heading Alignment */
        array(
            'id' => 'blog_title_alignment',
            'title' => esc_html('Blog Title & Subtitle Text Alignment', 'litae-theme-plugin'),
            'subtitle' => esc_html('Alignment for Title and Subtitle', 'litae-theme-plugin'),
            'type' => 'select',
            'options' => array(
                'text-left' => 'Text Left Alignment',
                'text-center' => 'Text Center Alignment',
                'text-right' => 'Text Right Alignment',
            ),
            'default' => 'text-left',
        ),
        array(
            'id' => 'blog_title_placement',
            'title' => esc_html('Blog Title & Subtitle Placement', 'litae-theme-plugin'),
            'subtitle' => esc_html('Placement for Title and Subtitle', 'litae-theme-plugin'),
            'type' => 'select',
            'options' => array(
                'text-left' => 'Left Placement',
                'text-center' => 'Center Placement',
                'text-right' => 'Right Placement',
            ),
            'default' => 'text-left',
        ),
        /* Blog Header Height */
        array(
            'id' => 'blog_page_header_height',
            'title' => esc_html('Choose Blog Header Height', 'litae-theme-plugin'),
            'type' => 'select',
            'options' => array(
                'full-height' => '100%',
                'big-height' => '80%',
                'half-height' => '50%'
            ),
            'default' => 'big-height',
        ),
        /* Blog Header Image */
        array(
            'id' => 'blog_page_header_image',
            'type' => 'media',
            //'required' => array('blog_page_header_background', '=', '1'),
            'title' => esc_html__('Choose Header Background Image', 'litae-theme-plugin'),
            'default' => array(
                'url' => get_template_directory_uri() . '/images/1.jpg',
            ),
        ),
        array(
            'id' => 'blog_page_posts_bg_color',
            'title' => esc_html__('Blog Page Posts background color', 'litae-theme-plugin'),
            'type' => 'color',
            'default' => '#fcf652',
            'validate' => 'color',
            'transparent' => false,
        ),
        /* Blog Page Post Animations */
        array(
            'id' => 'blog_page_post_animation',
            'title' => esc_html__('Blog Page Post Animation', 'litae-theme-plugin'),
            'type' => 'switch',
            'on' => 'Enable',
            'off' => 'Disable',
            'default' => '1',
        ),
        /* Blog Title Animation Color */
        array(
            'id' => 'blog_page_post_anim_color',
            'title' => esc_html__('Choose Animation Color', 'litae-theme-plugin'),
            'required' => array('blog_page_post_animation', '=', '1'),
            'type' => 'color',
            'default' => '#fcf652',
            'validate' => 'color',
            'transparent' => false,
        ),
        /* Blog Page Title Direction */
        array(
            'id' => 'blog_page_post_anim_direction',
            'title' => esc_html__('Choose Animation Direction', 'litae-theme-plugin'),
            'required' => array('blog_page_post_animation', '=', '1'),
            'type' => 'select',
            'options' => array(
                'lr' => esc_html__('Direction: left to right', 'litae-theme-plugin'),
                'rl' => esc_html__('Direction: right to left', 'litae-theme-plugin'),
                'tb' => esc_html__('Direction: top to bottom', 'litae-theme-plugin'),
                'bt' => esc_html__('Direction: bottom to top', 'litae-theme-plugin'),
            ),
            'default' => 'lr'
        ),
        array(
            'id' => 'blog-page-section-end',
            'type' => 'section',
            'indent' => false
        ),
        array(
            'id' => 'single-post-page-section-start',
            'type' => 'section',
            'title' => esc_html__('Blog Single Page Options', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Settings for Single Blog Page', 'litae-theme-plugin'),
            'indent' => true
        ),
        /* Single PageMain Layout */
        array(
            'id' => 'single_post_page_layout',
            'type' => 'image_select',
            'title' => esc_html__('Single Post Page Layout', 'litae-theme-plugin'),
            'subtitle' => wp_kses(__('Select main content and sidebar alignment.<br>Choose between:<br>one column<br>two columns left sidebar<br>two columns right sidebar', 'litae-theme-plugin'), array(
                'br' => array(),
            )),
            'options' => array(
                'one-column' => array(
                    'alt' => esc_html__('one column', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                ),
                'two-columns-left' => array(
                    'alt' => esc_html__('two columns left', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                ),
                'two-columns-right' => array(
                    'alt' => esc_html__('two columns right', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                ),
            ),
            'default' => 'one-column'
        ),
        /* Single Blog Title Animation */
        array(
            'id' => 'single_post_page_title_animation',
            'title' => esc_html__('Single Blog Title Animation', 'litae-theme-plugin'),
            'type' => 'switch',
            'on' => 'Enable',
            'off' => 'Disable',
            'default' => '1',
        ),
        /* Blog Title Animation Color */
        array(
            'id' => 'single_post_page_title_anim_color',
            'title' => esc_html__('Choose Animation Color', 'litae-theme-plugin'),
            'required' => array('single_post_page_title_animation', '=', '1'),
            'type' => 'color',
            'default' => '#fcf652',
            'validate' => 'color',
            'transparent' => false,
        ),
        /* Blog Page Title Direction */
        array(
            'id' => 'single_post_page_title_anim_direction',
            'title' => esc_html__('Choose Animation Direction', 'litae-theme-plugin'),
            'required' => array('single_post_page_title_animation', '=', '1'),
            'type' => 'select',
            'options' => array(
                'lr' => esc_html__('Direction: left to right', 'litae-theme-plugin'),
                'rl' => esc_html__('Direction: right to left', 'litae-theme-plugin'),
                'tb' => esc_html__('Direction: top to bottom', 'litae-theme-plugin'),
                'bt' => esc_html__('Direction: bottom to top', 'litae-theme-plugin'),
            ),
            'default' => 'lr'
        ),
        /* Single Blog Entry Header Animation */
        array(
            'id' => 'single_post_page_entry_animation',
            'title' => esc_html__('Single Blog Entry Header Animation', 'litae-theme-plugin'),
            'type' => 'switch',
            'on' => 'Enable',
            'off' => 'Disable',
            'default' => '1',
        ),
        /* Single Blog Header Entry Animation Color */
        array(
            'id' => 'single_post_page_entry_anim_color',
            'title' => esc_html__('Choose Animation Color', 'litae-theme-plugin'),
            'required' => array('single_post_page_entry_animation', '=', '1'),
            'type' => 'color',
            'default' => '#7F40F1',
            'validate' => 'color',
            'transparent' => false,
        ),
        /* Single Blog Page Header Entry Direction */
        array(
            'id' => 'single_post_page_entry_anim_direction',
            'title' => esc_html__('Choose Animation Direction', 'litae-theme-plugin'),
            'required' => array('single_post_page_entry_animation', '=', '1'),
            'type' => 'select',
            'options' => array(
                'lr' => esc_html__('Direction: left to right', 'litae-theme-plugin'),
                'rl' => esc_html__('Direction: right to left', 'litae-theme-plugin'),
                'tb' => esc_html__('Direction: top to bottom', 'litae-theme-plugin'),
                'bt' => esc_html__('Direction: bottom to top', 'litae-theme-plugin'),
            ),
            'default' => 'rl'
        ),
        array(
            'id' => 'single-post-page-section-end',
            'type' => 'section',
            'indent' => false
        ),
    ),
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="SEARCH PAGE SETTINGS">
Redux::setSection($opt_name, array(
    'title' => esc_html__('Search page', 'litae-theme-plugin'),
    'heading' => esc_html__('Search page options', 'litae-theme-plugin'),
    'desc' => wp_kses(__('These options affect your posts catalog display.<br>If you are using a speed optimization plugin, don\'t forget to clear cache after options update.', 'litae-theme-plugin'), array(
        'br' => array(),
    )),
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'search_page_layout',
            'type' => 'image_select',
            'title' => esc_html__('Main Layout', 'litae-theme-plugin'),
            'subtitle' => wp_kses(__('Select main content and sidebar alignment.<br>Choose between:<br>one column<br>two columns left sidebar<br>two columns right sidebar', 'litae-theme-plugin'), array(
                'br' => array(),
            )),
            'options' => array(
                'one-column' => array(
                    'alt' => esc_html__('one column', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                ),
                'two-columns-left' => array(
                    'alt' => esc_html__('two columns left', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                ),
                'two-columns-right' => array(
                    'alt' => esc_html__('two columns right', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                ),
            ),
            'default' => 'one-column'
        ),
    )
));
// </editor-fold>

Redux::setSection($opt_name, array(
    'title' => esc_html__('Archive page', 'litae-theme-plugin'),
    'heading' => esc_html__('Archive page options', 'litae-theme-plugin'),
    'desc' => wp_kses(__('These options affect your posts catalog display.<br>If you are using a speed optimization plugin, don\'t forget to clear cache after options update.', 'litae-theme-plugin'), array(
        'br' => array(),
    )),
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'archive_page_layout',
            'type' => 'image_select',
            'title' => esc_html__('Main Layout', 'litae-theme-plugin'),
            'subtitle' => wp_kses(__('Select main content and sidebar alignment.<br>Choose between:<br>one column<br>two columns left sidebar<br>two columns right sidebar', 'litae-theme-plugin'), array(
                'br' => array(),
            )),
            'options' => array(
                'one-column' => array(
                    'alt' => esc_html__('one column', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                ),
                'two-columns-left' => array(
                    'alt' => esc_html__('two columns left', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                ),
                'two-columns-right' => array(
                    'alt' => esc_html__('two columns right', 'litae-theme-plugin'),
                    'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                ),
            ),
            'default' => 'one-column'
        ),
    )
));


// <editor-fold defaultstate="collapsed" desc="COLORS SETTING">
Redux::setSection($opt_name, array(
    'title' => esc_html__('Colors', 'litae-theme-plugin'),
    'desc' => wp_kses(__('If you are using a speed optimization plugin, don\'t forget to clear cache after options update.', 'litae-theme-plugin'), array(
        'br' => array(),
    )),
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'color-settings-section-start',
            'type' => 'section',
            'title' => esc_html__('Theme Colors', 'litae-theme-plugin'),
            'indent' => true
        ),
        array(
            'id' => 'theme_main_color',
            'title' => esc_html('Choose Theme Main Color', 'litae-theme-plugin'),
            'type' => 'color',
            'transparent' => false,
            'default' => '#7F40F1',
            'validate' => 'color',
        ),
        array(
            'id' => 'theme_main_color_before',
            'title' => esc_html('Choose Theme Main Color Before', 'litae-theme-plugin'),
            'subtitle' => esc_html__('This color is used for widgets and posts headings underline.', 'litae'),
            'type' => 'color',
            'transparent' => false,
            'default' => '#FCF652',
            'validate' => 'color',
        ),
        array(
            'id' => 'theme_tooltip_color',
            'title' => esc_html('Choose Theme Tooltip Color', 'litae-theme-plugin'),
            'type' => 'color',
            'transparent' => false,
            'default' => '#FCF652',
            'validate' => 'color',
        ),
        array(
            'id' => 'color-settings-section-end',
            'type' => 'section',
            'indent' => false
        ),
    )
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="SOCIAL ICONS">
Redux::setSection($opt_name, array(
    'title' => esc_html__('Social Icons', 'litae-theme-plugin'),
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'social_repeater',
            'type' => 'repeater',
            'title' => esc_html__('Social Icons', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Add social icons for general use on your website.', 'litae-theme-plugin'),
            'group_values' => true, // Group all fields below within the repeater ID
            //'item_name' => '', // Add a repeater block name to the Add and Delete buttons
            //'bind_title' => 'social_title', // Bind the repeater block title to this field ID
            //'static'     => 2, // Set the number of repeater blocks to be output
            //'limit' => 2, // Limit the number of repeater blocks a user can create
            'sortable' => true, // Allow the users to sort the repeater blocks or not
            'fields' => array(
                array(
                    'id' => 'social_icon',
                    'type' => 'select',
                    'title' => esc_html__('Social Icon', 'litae-theme-plugin'),
                    'class' => ' font-icons',
                    'options' => FaIcons::getIcons()
                ),
                array(
                    'id' => 'social_url',
                    'type' => 'text',
                    'title' => esc_html__('Social URL', 'litae-theme-plugin'),
                    'placeholder' => esc_html__('Social URL', 'litae-theme-plugin'),
                ),
            
            ),
            'default' => array(
                'redux_repeater_data' => array(
                    array('title' => 'Twitter'),
                    array('title' => 'Facebook'),
                ),
                'social_icon' => array(
                    'fa fa-twitter',
                    'fa fa-facebook',
                ),
                'social_url' => array(
                    '#',
                    '#',
                ),
            ),
        ),
    ),
        )
); 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="FAVICON ICONS">
Redux::setSection($opt_name, array(
    'title' => esc_html( 'Favicon', 'litae-theme-plugin'),
    'heading' => 'Favicon an Apple Touch Icon',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'favicon',
            'type' => 'media',
            'title' => esc_html__('Favicon Icon', 'litae-theme-plugin'),
            'url' => true,
            'compiler' => 'true',
            //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => esc_html__('Upload your favicon icon.', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Image type: PNG. Recommended size: 32x32px', 'litae-theme-plugin'),
            'default' => array( 'url' => get_template_directory_uri().'/images/favicon.png' ),
        ),
        array(
            'id' => 'apple_57',
            'type' => 'media',
            'title' => esc_html__('Apple Touch Icon 57px', 'litae-theme-plugin'),
            'url' => true,
            'compiler' => 'true',
            //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => esc_html__('Upload your favicon icon.', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Image type: PNG. Recommended size: 57x57px', 'litae-theme-plugin'),
            'default' => array( 'url' => get_template_directory_uri().'/images/apple-touch-icon.png' ),
        ),
        array(
            'id' => 'apple_72',
            'type' => 'media',
            'title' => esc_html__('Apple Touch Icon 72px', 'litae-theme-plugin'),
            'url' => true,
            'compiler' => 'true',
            //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => esc_html__('Upload your favicon icon.', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Image type: PNG. Recommended size: 72x72px', 'litae-theme-plugin'),
            'default' => array( 'url' => get_template_directory_uri().'/images/apple-touch-icon-72x72.png' ),
        ),
        array(
            'id' => 'apple_114',
            'type' => 'media',
            'title' => esc_html__('Apple Touch Icon 114px', 'litae-theme-plugin'),
            'url' => true,
            'compiler' => 'true',
            //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => esc_html__('Upload your favicon icon.', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Image type: PNG. Recommended size: 114x114px', 'litae-theme-plugin'),
            'default' => array( 'url' => get_template_directory_uri().'/images/apple-touch-icon-114x114.png' ),
        ),
    ),
));
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="PRELOADER">
Redux::setSection($opt_name, array(
    'title' => esc_html__('Preloader', 'litae-theme-plugin'),
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'preloader',
            'type' => 'switch',
            'title' => esc_html__('Preloader', 'litae-theme-plugin'),
            'desc' => esc_html__('Show/Hide.', 'litae-theme-plugin'),
            'on' => 'Enable',
            'off' => 'Disable',
            'default' => '1',
        ),
        array(
            'id' => 'preloader_bg',
            'title' => esc_html('Choose Preloader background-color', 'litae-theme-plugin'),
            'type' => 'color',
            'transparent' => false,
            'default' => '#fff',
            'validate' => 'color',
        ),
        array(
            'id' => 'preloader_image',
            'type' => 'media',
            'title' => esc_html__('Preloader image', 'litae-theme-plugin'),
            'url' => true,
            'compiler' => 'true',
            //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'subtitle' => esc_html__('Image type: GIF. Recommended size: 64x64px', 'litae-theme-plugin'),
            'default' => array('url' => get_template_directory_uri() . '/images/preload.gif'),
        ),
    ),
));
// </editor-fold>


Redux::setSection($opt_name, array(
    'title' => esc_html__( 'Logo', 'litae-theme-plugin' ),
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'logo',
            'type' => 'media',
            'title' => esc_html__('Logo', 'litae-theme-plugin'),
            'url' => true,
            'compiler' => 'true',
            //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => esc_html__('Upload your logo.', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Recommended size about: 130x50px', 'litae-theme-plugin'),
            'default' => array( 'url' => get_template_directory_uri().'/images/logo.png' ),
        ),
    ),
));



Redux::setSection($opt_name, array(
    'title' => esc_html__('Google Map', 'litae-theme-plugin'),
    'heading' => '',
    'icon' => 'fa fa-google',
    'fields' => array(
        array(
            'id' => 'google_api_key',
            'title' => esc_html__( 'Google API key', 'litae-theme-plugin'),
            'type'  => 'text',
            'subtitle' => 'Insert your Google API key to enable google maps.<br>If you don\'t have google API key click on link below to get your key.<br><a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">Get your Google API key</a>',
            'default' => '',
        ),
    ),
));

// <editor-fold defaultstate="collapsed" desc="FOOTER SETTINGS">
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer', 'litae-theme-plugin'),
    'heading' => '',
    'icon' => 'el el-circle-arrow-down',
    'fields' => array(
        array(
            'id' => 'footer_color_set_start',
            'title' => 'Footer Color Set',
            'type' => 'section',
            'indent' => true
        ),
        array(
            'id' => 'footer_bg_color',
            'title' => esc_html('Footer Background Color', 'litae-theme-plugin'),
            'subtitle' => esc_html('default: #fff', 'litae-theme-plugin'),
            'type' => 'color',
            'transparent' => false,
            'default' => '#ffffff',
            'validate' => 'color',
        ),
        array(
            'id' => 'footer_text_color',
            'title' => esc_html('Footer Text Color', 'litae-theme-plugin'),
            'subtitle' => esc_html('default: #999', 'litae-theme-plugin'),
            'type' => 'color',
            'transparent' => false,
            'default' => '#999999',
            'validate' => 'color',
        ),
        array(
            'id' => 'footer_link_color',
            'type' => 'link_color',
            'title' => esc_html__('Links Color Option', 'litae-theme-plugin'),
            'subtitle' => esc_html__('default: #999 / #7f40f1', 'litae-theme-plugin'),
            'visited' => false,
            'active' => false,
            'default' => array(
                'regular' => '#999', // grey
                'hover' => '#7f40f1', // violet
            ),
        ),
        array(
            'id' => 'footer_color_set_end',
            'type' => 'section',
            'indent' => false
        ),
        array(
            'id' => 'footer_content_set_start',
            'title' => esc_html('Footer Content Set', 'litae-theme-plugin'),
            'type' => 'section',
            'indent' => true
        ),
        array(
            'id' => 'footer_first_column',
            'title' => esc_html__('First Column', 'litae-theme-plugin'),
            'desc' => esc_html__('allowed html tags: &lt;a&gt;, &lt;p&gt;, &lt;strong&gt; and &lt;br&gt;', 'litae-theme-plugin'),
            'type' => 'textarea',
            'default' => wp_kses('<a href="#" class="logo-text-footer">The Litae</a><br><a href="#" class="mail-text-footer">hello[at]thelitea[dot]com</a>', array(
                'br' => array(),
                'a' => array(
                    'title' => array(),
                    'href' => array(),
                    'class' => array(),
                    'target' => array('_blank', '_top'),
                ),
                'p' => array(
                    'class' => array()
                ),
                'strong' => array(),
            )),
        ),
        array(
            'id' => 'footer_second_column',
            'title' => esc_html__('Second Column', 'litae-theme-plugin'),
            'desc' => esc_html__('allowed html tags: &lt;a&gt;, &lt;p&gt;, &lt;strong&gt; and &lt;br&gt;', 'litae-theme-plugin'),
            'type' => 'textarea',
            'default' => wp_kses('kralja milutina 325<br>11000 belgrade, serbia<br>(+381)60111222333', array(
                'br' => array(),
                'a' => array(
                    'title' => array(),
                    'href' => array(),
                    'class' => array(),
                    'target' => array('_blank', '_top'),
                ),
                'p' => array(
                    'class' => array()
                ),
                'strong' => array(),
            )),
        ),
        array(
            'id' => 'footer_social_column',
            'title' => esc_html__('Social Column', 'litae-theme-plugin'),
            'subtitle' => esc_html__('Show or hide social icons column.', 'litae-theme-plugin'),
            'on' => esc_html__('Show', 'litae-theme-plugin'),
            'off' => esc_html__('Hide', 'litae-theme-plugin'),
            'type' => 'switch',
            'default' => true
        ),
        array(
            'id' => 'footer_content_set_end',
            'type' => 'section',
            'indent' => false
        ),
    ),
));
// </editor-fold>


/*
 * <-- END Theme Options Settings
 */
class FaIcons
{
 private static $icons = array(
    "fa-adn",
    "fa-android",
    "fa-apple",
    "fa-behance",
    "fa-behance-square",
    "fa-bitbucket",
    "fa-bitbucket-square",
    "fa-bitcoin",
    "fa-btc",
    "fa-codepen",
    "fa-css3",
    "fa-delicious",
    "fa-deviantart",
    "fa-digg",
    "fa-dribbble",
    "fa-dropbox",
    "fa-drupal",
    "fa-empire",
    "fa-facebook",
    "fa-facebook-square",
    "fa-flickr",
    "fa-foursquare",
    "fa-ge",
    "fa-git",
    "fa-git-square",
    "fa-github",
    "fa-github-alt",
    "fa-github-square",
    "fa-gittip",
    "fa-google",
    "fa-google-plus",
    "fa-google-plus-square",
    "fa-hacker-news",
    "fa-html5",
    "fa-instagram",
    "fa-joomla",
    "fa-jsfiddle",
    "fa-linkedin",
    "fa-linkedin-square",
    "fa-linux",
    "fa-maxcdn",
    "fa-openid",
    "fa-pagelines",
    "fa-pied-piper",
    "fa-pied-piper-alt",
    "fa-pied-piper-square",
    "fa-pinterest",
    "fa-pinterest-square",
    "fa-qq",
    "fa-ra",
    "fa-rebel",
    "fa-reddit",
    "fa-reddit-square",
    "fa-renren",
    "fa-share-alt",
    "fa-share-alt-square",
    "fa-skype",
    "fa-slack",
    "fa-soundcloud",
    "fa-spotify",
    "fa-stack-exchange",
    "fa-stack-overflow",
    "fa-steam",
    "fa-steam-square",
    "fa-stumbleupon",
    "fa-stumbleupon-circle",
    "fa-tencent-weibo",
    "fa-trello",
    "fa-tumblr",
    "fa-tumblr-square",
    "fa-twitter",
    "fa-twitter-square",
    "fa-vimeo-square",
    "fa-vine",
    "fa-vk",
    "fa-wechat",
    "fa-weibo",
    "fa-weixin",
    "fa-windows",
    "fa-wordpress",
    "fa-xing",
    "fa-xing-square",
    "fa-yahoo",
    "fa-youtube",
    "fa-youtube-play",
    "fa-youtube-square"
);
public static function getIcons($param="") {
    $icons = self::$icons;
    sort( $icons) ;
    $iconArray = array();
    foreach ($icons as $icon) {
        $name = ucwords(str_replace('-', ' ', str_replace(array(
            'fa-',
            '-play',
            '-square',
            '-alt',
            '-circle'
                                ), '', $icon)));
        $iconArray['fa ' . $icon] = $name;
    }
    return $iconArray; 
}

}