<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Widget_Heading_Reveal extends Widget_Base {

	public function get_name() {
		return 'litae-heading-reveal';
	}

	public function get_title() {
		return esc_html__( 'Heading Litae', 'elementor-custom-element' );
	}

	public function get_icon() {
		return 'eicon-type-tool';
	}
        
        public function get_categories() {
            return ['litae-elements'];
        }

	protected function _register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'elementor-custom-element' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'elementor-custom-element' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter your title', 'elementor-custom-element' ),
				'default' => get_the_title()
			]
		);
		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor-custom-element' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => esc_html__( 'H1', 'elementor-custom-element' ),
					'h2' => esc_html__( 'H2', 'elementor-custom-element' ),
					'h3' => esc_html__( 'H3', 'elementor-custom-element' ),
					'h4' => esc_html__( 'H4', 'elementor-custom-element' ),
					'h5' => esc_html__( 'H5', 'elementor-custom-element' ),
					'h6' => esc_html__( 'H6', 'elementor-custom-element' ),
					'div' => esc_html__( 'div', 'elementor-custom-element' ),
					'span' => esc_html__( 'span', 'elementor-custom-element' ),
					'p' => esc_html__( 'p', 'elementor-custom-element' ),
				],
				'default' => 'h2',
			]
		);

		$this->add_responsive_control(
                    'align',
                    [
                        'label' => esc_html__( 'Alignment', 'elementor-custom-element' ),
                        'type' => Controls_Manager::CHOOSE,
                        'options' => [
                            'left' => [
                                    'title' => esc_html__( 'Left', 'elementor-custom-element' ),
                                    'icon' => 'fa fa-align-left',
                            ],
                            'center' => [
                                    'title' => esc_html__( 'Center', 'elementor-custom-element' ),
                                    'icon' => 'fa fa-align-center',
                            ],
                            'right' => [
                                    'title' => esc_html__( 'Right', 'elementor-custom-element' ),
                                    'icon' => 'fa fa-align-right',
                            ],
                            'justify' => [
                                    'title' => esc_html__( 'Justified', 'elementor-custom-element' ),
                                    'icon' => 'fa fa-align-justify',
                            ],
                        ],
                        'default' => '',
                        'selectors' => [
                                '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                        ],
                    ]
		);
                /*
                 *  RevealFx
                 */
                $this->add_control(
                'is_effect',
                    [
                        'label' => esc_html( 'Reveal effect', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SWITCHER,
                        'default' => false,
                    ]
                );
                $this->add_control(
                    'animation_color',
                    [
                        'label' => __( 'Animation Color', 'elementor-custom-element' ),
                        'type' => Controls_Manager::COLOR,
                        'scheme' => [
                            'type' => Scheme_Color::get_type(),
                            'value' => Scheme_Color::COLOR_1,
                        ],
                        'condition' => [
                            'is_effect' => 'on'
                        ]
                    ]
                );
                $this->add_control(
                    'animation_direction',
                        [
                           'label' => esc_html__( 'Animation direction', 'elementor-custom-element' ),
                           'type' => Controls_Manager::SELECT,
                           'label_block' => true,
                           'options' => [
                              'lr' => esc_html__( 'Left to right', 'elementor-custom-element' ),
                              'rl' => esc_html__( 'Right to left', 'elementor-custom-element' ),
                              'tb' => esc_html__( 'Top to bottom', 'elementor-custom-element' ),
                              'bt' => esc_html__( 'Bottom to top', 'elementor-custom-element' ),
                           ],
                           'default' => 'lr',
                           'multiple' => false,
                           'condition' => [
                               'is_effect' => 'on'
                           ]
                        ]
                );
                $this->add_control(
                    'animation_delay',
                    [
                        'label' => __( 'Animation delay', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SLIDER,
                        'default' => [
                            'size' => 250,
                        ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 2000,
                                'step' => 10,
                            ],
                        ],
                        'size_units' => [ 'px' ],
                        'condition' => [
                            'is_effect' => 'on'
                        ]
                    ]
                );
                /*
                 * end RevealFx
                 */
		$this->add_control(
			'view',
			[
				'label' => esc_html__( 'View', 'elementor-custom-element' ),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'elementor-custom-element' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Text Color', 'elementor-custom-element' ),
				'type' => Controls_Manager::COLOR,
				'scheme' => [
				    'type' => Scheme_Color::get_type(),
				    'value' => Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-heading-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .elementor-heading-title',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
		if ( empty( $settings['title'] ) ){
			return;
                }
                
		$this->add_render_attribute( 'heading', 'class', 'elementor-heading-title' );
		$title = nl2br($settings['title']);
                $watcher = ( $settings['is_effect']!='on' )? '' : 'watcher';
                $animation_settings = [
                    'bgcolor'     => $settings['animation_color'],
                    'direction' => $settings['animation_direction'],
                    'delay'     => absint( $settings['animation_delay']['size'] ),
                ];
                
                $data_rev_settings = esc_attr( wp_json_encode( $animation_settings ) );
                
                echo <<<HTML
<div>
<{$settings['header_size']} class="elementor-heading-title elementor-size-default {$watcher}" data-rev-settings="{$data_rev_settings}" >{$title}</{$settings['header_size']}>
</div>
HTML;
	}

	protected function _content_template() {
	}
}
