<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Widget_Testimonial_Carousel extends Widget_Base {

	public function get_name() {
		return 'testimonial-carousel';
	}

	public function get_title() {
		return esc_html__( 'Testimonial Carousel', 'elementor-custom-element' );
	}

	public function get_icon() {
		return 'fa fa-quote-right';
	}

	public function get_categories() {
		return [ 'litae-elements' ];
	}

	public function get_script_depends() {
		return [ 'jquery-slick' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
                    'section_testimonial_carousel',
                    [
                        'label' => esc_html__( 'Testimonial Carousel', 'elementor-custom-element' ),
                    ]
		);
                /**
                 * Repeater
                 */
                $this->add_control(
                    'testimonials',
                    [
                        'label' => esc_html__( 'Items', 'elementor-custom-element' ),
                        'type' => Controls_Manager::REPEATER,
                        'default' => [],
                        'title' => 'Custom item',
                        'fields' => [
                            [
                                'name' => 'text',
                                'label' => esc_html__( 'Blockquote', 'elementor-custom-element' ),
                                'type' => Controls_Manager::TEXTAREA,
                                'label_block' => true,
                                'placeholder' => esc_html__( 'Say something', 'elementor-custom-element' ),
                            ],
                            [
                                'name' => 'cite',
                                'label' => esc_html__( 'Cite', 'elementor-custom-element'),
                                'type' => Controls_Manager::TEXT,
                                'label_block' => true,
                                'placeholder' => esc_html__( 'Author name', 'elementor-custom-element' ),
                            ],
                        ],
                        'title_field' => '{{{ text }}}',
                    ]
                );
		$this->end_controls_section();

		$this->start_controls_section(
                    'section_additional_options',
                    [
                        'label' => esc_html__( 'Additional Options', 'elementor-custom-element' ),
                    ]
		);
                
                $this->add_control(
                    'navigation',
                        [
                            'label' => esc_html__( 'Navigation', 'elementor-custom-element' ),
                            'type' => Controls_Manager::SELECT,
                            'default' => 'both',
                            'options' => [
                                'both' => esc_html__( 'Arrows and Dots', 'elementor-custom-element' ),
                                'arrows' => esc_html__( 'Arrows', 'elementor-custom-element'),
                                'dots' => esc_html__( 'Dots', 'elementor-custom-element' ),
                                'none' => esc_html__( 'None', 'elementor-custom-element' ),
                            ],
                        ]
		);
                
                $this->add_responsive_control(
                    'navigation_position',
                        [
                            'label' => esc_html__( 'Navigation aligmnet', 'elementor-custom-element' ),
                            'type' => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'elementor-custom-element' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'elementor-custom-element' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'elementor-custom-element' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                            ],
                            'default' => 'center',
                            'selectors' => [
                                '{{WRAPPER}} .elementor-testimonial-carousel-wrapper .elementor-testimonial-carousel ul.slick-dots' => 'text-align: {{VALUE}};',
                            ],
                        ]
                );
                
		$this->add_control(
                    'pause_on_hover',
                    [
                        'label' => esc_html__( 'Pause on Hover', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'yes',
                        'options' => [
                            'yes' => esc_html__( 'Yes', 'elementor-custom-element' ),
                            'no' => esc_html__( 'No', 'elementor-custom-element' ),
                        ],
                    ]
		);

		$this->add_control(
                    'autoplay',
                    [
                        'label' => esc_html__( 'Autoplay', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'yes',
                        'options' => [
                            'yes' => esc_html__( 'Yes', 'elementor-custom-element' ),
                            'no' => esc_html__( 'No', 'elementor-custom-element' ),
                        ],
                    ]
		);

		$this->add_control(
                    'autoplay_speed',
                    [
                        'label' => esc_html__( 'Autoplay Speed', 'elementor-custom-element' ),
                        'type' => Controls_Manager::NUMBER,
                        'default' => 5000,
                    ]
		);

		$this->add_control(
                    'infinite',
                    [
                        'label' => esc_html__( 'Infinite Loop', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'yes',
                        'options' => [
                            'yes' => esc_html__( 'Yes', 'elementor-custom-element' ),
                            'no' => esc_html__( 'No', 'elementor-custom-element' ),
                        ],
                    ]
		);

		$this->add_control(
                    'effect',
                    [
                        'label' => esc_html__( 'Effect', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'slide',
                        'options' => [
                            'slide' => esc_html__( 'Slide', 'elementor-custom-element' ),
                            'fade' => esc_html__( 'Fade', 'elementor-custom-element' ),
                        ],
                    ]
		);

		$this->add_control(
                    'speed',
                    [
                        'label' => esc_html__( 'Animation Speed', 'elementor-custom-element' ),
                        'type' => Controls_Manager::NUMBER,
                        'default' => 500,
                    ]
		);

		$this->add_control(
                    'direction',
                    [
                        'label' => esc_html__( 'Direction', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'ltr',
                        'options' => [
                            'ltr' => esc_html__( 'Left', 'elementor-custom-element' ),
                            'rtl' => esc_html__( 'Right', 'elementor-custom-element' ),
                        ],
                    ]
		);

		$this->end_controls_section();

		$this->start_controls_section(
                    'section_style_navigation',
                    [
                        'label' => __( 'Navigation', 'elementor-custom-element' ),
                        'tab' => Controls_Manager::TAB_STYLE,
                        'condition' => [
                            'navigation' => [ 'arrows', 'dots', 'both' ],
                        ],
                    ]
		);

		$this->add_control(
                    'heading_style_arrows',
                    [
                        'label' => esc_html__( 'Arrows', 'elementor-custom-element' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                        ],
                    ]
		);

		$this->add_control(
                    'arrows_position',
                    [
                        'label' => esc_html__( 'Arrows Position', 'elementor-custom-element'),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'inside',
                        'options' => [
                            'inside' => esc_html__( 'Inside', 'elementor-custom-element' ),
                            'outside' => esc_html__( 'Outside', 'elementor-custom-element' ),
                        ],
                        'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                        ],
                    ]
		);

		$this->add_control(
                    'arrows_size',
                    [
                        'label' => esc_html__( 'Arrows Size', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 20,
                                'max' => 60,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .elementor-testimonial-carousel-wrapper .slick-slider .slick-prev:before, {{WRAPPER}} .elementor-testimonial-carousel-wrapper .slick-slider .slick-next:before' => 'font-size: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                        ],
                    ]
		);

		$this->add_control(
                    'arrows_color',
                    [
                        'label' => esc_html__( 'Arrows Color', 'elementor-custom-element' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .elementor-testimonial-carousel-wrapper .slick-slider .slick-prev:before, {{WRAPPER}} .elementor-testimonial-carousel-wrapper .slick-slider .slick-next:before' => 'color: {{VALUE}};',
                        ],
                        'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                        ],
                    ]
		);

		$this->add_control(
                    'heading_style_dots',
                    [
                        'label' => esc_html__( 'Dots', 'elementor-custom-element' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'navigation' => [ 'dots', 'both' ],
                        ],
                    ]
		);

		$this->add_control(
                    'dots_position',
                    [
                        'label' => esc_html__( 'Dots Position', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'outside',
                        'options' => [
                            'outside' => esc_html__( 'Outside', 'elementor-custom-element' ),
                            'inside' => esc_html__( 'Inside', 'elementor-custom-element' ),
                        ],
                        'condition' => [
                            'navigation' => [ 'dots', 'both' ],
                        ],
                    ]
		);

		$this->add_control(
                    'dots_size',
                    [
                        'label' => esc_html__( 'Dots Size', 'elementor-custom-element' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 5,
                                'max' => 10,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .elementor-testimonial-carousel-wrapper .elementor-testimonial-carousel .slick-dots li button:before' => 'font-size: {{SIZE}}{{UNIT}};padding-left:15px;padding-right:15px;',
                        ],
                        'condition' => [
                            'navigation' => [ 'dots', 'both' ],
                        ],
                    ]
		);

		$this->add_control(
                    'dots_color',
                    [
                        'label' => esc_html__( 'Dots Color', 'elementor-custom-element' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .elementor-testimonial-carousel-wrapper .elementor-testimonial-carousel .slick-dots li button:before' => 'color: {{VALUE}};',
                        ],
                        'condition' => [
                            'navigation' => [ 'dots', 'both' ],
                        ],
                    ]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings();

		//$is_slideshow = '1' === $settings['slides_to_show'];
		$is_rtl = ( 'rtl' === $settings['direction'] );
		$direction = $is_rtl ? 'rtl' : 'ltr';
		$show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
		$show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );

		$slick_options = [
                    'slidesToShow' => 1,
                    'autoplaySpeed' => absint( $settings['autoplay_speed'] ),
                    'autoplay' => ( 'yes' === $settings['autoplay'] ),
                    'infinite' => ( 'yes' === $settings['infinite'] ),
                    'pauseOnHover' => ( 'yes' === $settings['pause_on_hover'] ),
                    'speed' => absint( $settings['speed'] ),
                    'arrows' => $show_arrows,
                    'dots' => $show_dots,
                    'rtl' => $is_rtl,
		];

		$carousel_classes = [ 'elementor-testimonial-carousel' ];

		if ( $show_arrows ) {
                    $carousel_classes[] = 'slick-arrows-' . $settings['arrows_position'];
		}

		if ( $show_dots ) {
                    $carousel_classes[] = 'slick-dots-' . $settings['dots_position'];
		}

                $slick_options['fade'] = ( 'fade' === $settings['effect'] );

                    
                $slides = [];
            
            foreach( $settings['testimonials'] as $data ){
                $slides[] = <<<HTML
<div>
    <blockquote>
        <p>{$data['text']}</p>
        <cite class="author">{$data['cite']}</cite>
    </blockquote>
</div>
HTML;
            }
            
            if ( empty( $slides ) ) {
                return;
            }
            ?>

            <div class="elementor-testimonial-carousel-wrapper elementor-slick-slider" dir="<?php echo $direction; ?>">
                <div class="<?php echo implode( ' ', $carousel_classes ); ?>" data-slider_options='<?php echo esc_attr( wp_json_encode( $slick_options ) ); ?>'>
                <?php echo implode( '', $slides ); ?>

                </div>
            </div>

            <?php
	}
        
        protected function _content_template() {
        }
    
}
