<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


class Widget_Text_Box extends Widget_Base {

    public function get_name() {
        return 'litae-about-text-box';
    }

    public function get_title() {
        return esc_html__('About Text Box', 'elementor-custom-element');
    }

    public function get_icon() {
        return 'fa fa-align-left';
    }

    public function get_categories() {
        return ['litae-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
                'section_icon', [
                'label' => esc_html__('About Text Box', 'elementor-custom-element'),
                ]
        );
        $this->add_control(
            'title', [
            'label'   => esc_html__('Title', 'elementor-custom-element'),
            'label_block' => true,
            'type'    => Controls_Manager::TEXT,
            'default' => esc_html__('About work title', 'elementor-custom-element'),
                ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .elementor-heading-title',
            ]
        );
        $this->add_control(
            'description', [
                'label'       => esc_html__('Description', 'elementor-custom-element'),
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 8,
                'placeholder' => esc_html__('Type your works', 'elementor-custom-element'),
                ]
        );
        $this->add_control(
            'description_color',
            [
                'label' => esc_html__( 'Description Color', 'elementor-custom-element' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'selectors' => [
                        '{{WRAPPER}} .about-work .description' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        /*
        *  RevealFx
        */
        $this->add_control(
        'is_effect',
            [
                'label' => esc_html( 'Reveal effect', 'elementor-custom-element' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => false,
            ]
        );
        $this->add_control(
            'animation_color',
            [
                'label' => __( 'Animation Color', 'elementor-custom-element' ),
                'type' => Controls_Manager::COLOR,
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'condition' => [
                    'is_effect' => 'on'
                ]
            ]
        );
        $this->add_control(
            'animation_direction',
                [
                   'label' => esc_html__( 'Animation direction', 'elementor-custom-element' ),
                   'type' => Controls_Manager::SELECT,
                   'label_block' => true,
                   'options' => [
                      'lr' => esc_html__( 'Left to right', 'elementor-custom-element' ),
                      'rl' => esc_html__( 'Right to left', 'elementor-custom-element' ),
                      'tb' => esc_html__( 'Top to bottom', 'elementor-custom-element' ),
                      'bt' => esc_html__( 'Bottom to top', 'elementor-custom-element' ),
                   ],
                   'default' => 'lr',
                   'multiple' => false,
                   'condition' => [
                       'is_effect' => 'on'
                   ]
                ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => __( 'Animation delay', 'elementor-custom-element' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 250,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                        'step' => 10,
                    ],
                ],
                'size_units' => [ 'px' ],
                'condition' => [
                    'is_effect' => 'on'
                ]
            ]
        );
        /*
         * end RevealFx
         */
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        $title = esc_html( $settings['title'] );
        $description = nl2br( $settings['description'] );
        $is_effect = ($settings['is_effect']!='on')? false : true;
        $animation_settings = [
            'bgcolor'     => $settings['animation_color'],
            'direction' => $settings['animation_direction'],
            'delay'     => absint( $settings['animation_delay']['size'] ),
        ];

        $data_rev_settings = esc_attr( wp_json_encode( $animation_settings ) );
        
        $html = '';
        $html .= '<div class="about-work">';
        if($is_effect){
            $html .=  '<div class="watcher" data-rev-settings="'.$data_rev_settings.'">'; 
        }
        
        $html .= '<h6>' . $title .'</h6>';
        $html .= '<div class="description">' . $description . '</div>';
        
        if($is_effect){
            $html .=  '</div>'; 
        }
        $html .= '</div>';
        
        echo $html;
    }

    protected function _content_template() {
        
    }

}
