<?php
/**
 * Plugin Name:  Piroll Shortcodes
 * Description:  Shortcodes for Piroll
 * Version:      1.0.1
 * Author:       nK
 * Author URI:   https://nkdev.info
 * License:      GPLv2 or later
 * License URI:  https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:  piroll-shortcodes
 */

// Make sure we don't expose any info if called directly
if ( ! function_exists( 'add_action' ) ) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

/**
 * Khaki_Shortcodes Class
 */
if ( ! class_exists( 'Piroll_Shortcodes' ) ) :
    class Piroll_Shortcodes {
        public $plugin_path;
        public $plugin_url;

        public function __construct() {
            $this->plugin_path = plugin_dir_path( __FILE__ );
            $this->plugin_url = plugin_dir_url( __FILE__ );

            $this->init_text_domain();
            $this->include_dependencies();
        }

        public function init_text_domain() {
            load_plugin_textdomain( 'piroll-shortcodes', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
        }

        // include
        private function include_dependencies() {
            require $this->plugin_path . 'shortcodes/_all.php';

            /* include all shortcodes */
            require $this->plugin_path . 'shortcodes/nk-title.php';
            require $this->plugin_path . 'shortcodes/nk-button.php';
            require $this->plugin_path . 'shortcodes/nk-testimonial.php';
            require $this->plugin_path . 'shortcodes/nk-carousel.php';

            require $this->plugin_path . 'shortcodes/nk-icon-box.php';
            require $this->plugin_path . 'shortcodes/nk-progress.php';

            require $this->plugin_path . 'shortcodes/nk-tabs.php';
            require $this->plugin_path . 'shortcodes/nk-images-carousel.php';
            require $this->plugin_path . 'shortcodes/nk-contact-info.php';

            require $this->plugin_path . 'shortcodes/nk-portfolio-custom-list.php';
            require $this->plugin_path . 'shortcodes/nk-portfolio-fullscreen-slider.php';
        }
    }
endif;

if ( ! function_exists( 'piroll_shortcodes' ) ) :
    function piroll_shortcodes() {
        new Piroll_Shortcodes();
    }
endif;
add_action( 'plugins_loaded', 'piroll_shortcodes' );
