<?php
/**
 * Piroll Shortcodes
 */

// Check if $var isset / true / 1
if ( ! function_exists( 'piroll_check' ) ) :
    function piroll_check( $var ) {
        return ! ( ! isset( $var ) || $var === false || $var === 'false' || $var === 0 || $var === '0' || $var === '' );
    }
endif;

// custom CSS tab
if ( ! function_exists( 'piroll_get_css_tab' ) ) :
    function piroll_get_css_tab() {
        return array(
            array(
                'type'       => 'css_editor',
                'heading'    => esc_html__( 'CSS', 'piroll-shortcodes' ),
                'param_name' => 'vc_css',
                'group'      => esc_html__( 'Design Options', 'piroll-shortcodes' ),
            ),
        );
    }
endif;

// return additional class from Visual Composer style tab
if ( ! function_exists( 'piroll_get_css_tab_class' ) ) :
    function piroll_get_css_tab_class( $atts = array() ) {
        $result = ' ';
        if ( function_exists( 'vc_shortcode_custom_css_class' ) && isset( $atts['vc_css'] ) ) {
            $result = ' ' . vc_shortcode_custom_css_class( $atts['vc_css'] ) . ' ';
        }
        return $result;
    }
endif;


/**
 * Get all terms for portfolio shortcodes
 */
if ( ! function_exists( 'piroll_get_portfolio_terms' ) ) :
    function piroll_get_portfolio_terms( $category_only = false ) {
        $terms_list_vc = array();
        $categories = get_terms( 'portfolio-category' );
        $tags = $category_only ? array() : get_terms( 'portfolio-tag' );
        $terms_list = array();

        if ( ! empty( $categories ) && ! is_wp_error( $categories ) ) {
            $terms_list = array_merge( $terms_list, $categories );
        }
        if ( ! empty( $tags ) && ! is_wp_error( $tags ) ) {
            $terms_list = array_merge( $terms_list, $tags );
        }

        foreach ( $terms_list as $term ) {
            $terms_list_vc[] = array(
                'value' => $term->term_id,
                'label' => $term->name,
                'group' => $term->taxonomy,
            );
        }

        return $terms_list_vc;
    }
endif;

// add additional icon pack to default Visual Composer set icons
if ( ! function_exists( 'piroll_filter_iconpicker' ) ) {
    function piroll_filter_iconpicker( $icons ) {
        $custom_icons = array(
            esc_html__( 'Pe 7s Stroke', 'piroll-shortcodes' ) => array(
                array(
                    'pe-7s-album' => 'pe-7s-album',
                ),
                array(
                    'pe-7s-arc' => 'pe-7s-arc',
                ),
                array(
                    'pe-7s-back-2' => 'pe-7s-back-2',
                ),
                array(
                    'pe-7s-bandaid' => 'pe-7s-bandaid',
                ),
                array(
                    'pe-7s-car' => 'pe-7s-car',
                ),
                array(
                    'pe-7s-diamond' => 'pe-7s-diamond',
                ),
                array(
                    'pe-7s-door-lock' => 'pe-7s-door-lock',
                ),
                array(
                    'pe-7s-eyedropper' => 'pe-7s-eyedropper',
                ),
                array(
                    'pe-7s-female' => 'pe-7s-female',
                ),
                array(
                    'pe-7s-gym' => 'pe-7s-gym',
                ),
                array(
                    'pe-7s-hammer' => 'pe-7s-hammer',
                ),
                array(
                    'pe-7s-headphones' => 'pe-7s-headphones',
                ),
                array(
                    'pe-7s-helm' => 'pe-7s-helm',
                ),
                array(
                    'pe-7s-hourglass' => 'pe-7s-hourglass',
                ),
                array(
                    'pe-7s-leaf' => 'pe-7s-leaf',
                ),
                array(
                    'pe-7s-magic-wand' => 'pe-7s-magic-wand',
                ),
                array(
                    'pe-7s-male' => 'pe-7s-male',
                ),
                array(
                    'pe-7s-map-2' => 'pe-7s-map-2',
                ),
                array(
                    'pe-7s-next-2' => 'pe-7s-next-2',
                ),
                array(
                    'pe-7s-paint-bucket' => 'pe-7s-paint-bucket',
                ),
                array(
                    'pe-7s-pendrive' => 'pe-7s-pendrive',
                ),
                array(
                    'pe-7s-photo' => 'pe-7s-photo',
                ),
                array(
                    'pe-7s-piggy' => 'pe-7s-piggy',
                ),
                array(
                    'pe-7s-plugin' => 'pe-7s-plugin',
                ),
                array(
                    'pe-7s-refresh-2' => 'pe-7s-refresh-2',
                ),
                array(
                    'pe-7s-rocket' => 'pe-7s-rocket',
                ),
                array(
                    'pe-7s-settings' => 'pe-7s-settings',
                ),
                array(
                    'pe-7s-shield' => 'pe-7s-shield',
                ),
                array(
                    'pe-7s-smile' => 'pe-7s-smile',
                ),
                array(
                    'pe-7s-usb' => 'pe-7s-usb',
                ),
                array(
                    'pe-7s-vector' => 'pe-7s-vector',
                ),
                array(
                    'pe-7s-wine' => 'pe-7s-wine',
                ),
                array(
                    'pe-7s-cloud-upload' => 'pe-7s-cloud-upload',
                ),
                array(
                    'pe-7s-cash' => 'pe-7s-cash',
                ),
                array(
                    'pe-7s-close' => 'pe-7s-close',
                ),
                array(
                    'pe-7s-bluetooth' => 'pe-7s-bluetooth',
                ),
                array(
                    'pe-7s-cloud-download' => 'pe-7s-cloud-download',
                ),
                array(
                    'pe-7s-way' => 'pe-7s-way',
                ),
                array(
                    'pe-7s-close-circle' => 'pe-7s-close-circle',
                ),
                array(
                    'pe-7s-id' => 'pe-7s-id',
                ),
                array(
                    'pe-7s-angle-up' => 'pe-7s-angle-up',
                ),
                array(
                    'pe-7s-wristwatch' => 'pe-7s-wristwatch',
                ),
                array(
                    'pe-7s-angle-up-circle' => 'pe-7s-angle-up-circle',
                ),
                array(
                    'pe-7s-world' => 'pe-7s-world',
                ),
                array(
                    'pe-7s-angle-right' => 'pe-7s-angle-right',
                ),
                array(
                    'pe-7s-volume' => 'pe-7s-volume',
                ),
                array(
                    'pe-7s-angle-right-circle' => 'pe-7s-angle-right-circle',
                ),
                array(
                    'pe-7s-users' => 'pe-7s-users',
                ),
                array(
                    'pe-7s-angle-left' => 'pe-7s-angle-left',
                ),
                array(
                    'pe-7s-user-female' => 'pe-7s-user-female',
                ),
                array(
                    'pe-7s-angle-left-circle' => 'pe-7s-angle-left-circle',
                ),
                array(
                    'pe-7s-up-arrow' => 'pe-7s-up-arrow',
                ),
                array(
                    'pe-7s-angle-down' => 'pe-7s-angle-down',
                ),
                array(
                    'pe-7s-switch' => 'pe-7s-switch',
                ),
                array(
                    'pe-7s-angle-down-circle' => 'pe-7s-angle-down-circle',
                ),
                array(
                    'pe-7s-scissors' => 'pe-7s-scissors',
                ),
                array(
                    'pe-7s-wallet' => 'pe-7s-wallet',
                ),
                array(
                    'pe-7s-safe' => 'pe-7s-safe',
                ),
                array(
                    'pe-7s-volume2' => 'pe-7s-volume2',
                ),
                array(
                    'pe-7s-volume1' => 'pe-7s-volume1',
                ),
                array(
                    'pe-7s-voicemail' => 'pe-7s-voicemail',
                ),
                array(
                    'pe-7s-video' => 'pe-7s-video',
                ),
                array(
                    'pe-7s-user' => 'pe-7s-user',
                ),
                array(
                    'pe-7s-upload' => 'pe-7s-upload',
                ),
                array(
                    'pe-7s-unlock' => 'pe-7s-unlock',
                ),
                array(
                    'pe-7s-umbrella' => 'pe-7s-umbrella',
                ),
                array(
                    'pe-7s-trash' => 'pe-7s-trash',
                ),
                array(
                    'pe-7s-tools' => 'pe-7s-tools',
                ),
                array(
                    'pe-7s-timer' => 'pe-7s-timer',
                ),
                array(
                    'pe-7s-ticket' => 'pe-7s-ticket',
                ),
                array(
                    'pe-7s-target' => 'pe-7s-target',
                ),
                array(
                    'pe-7s-sun' => 'pe-7s-sun',
                ),
                array(
                    'pe-7s-study' => 'pe-7s-study',
                ),
                array(
                    'pe-7s-stopwatch' => 'pe-7s-stopwatch',
                ),
                array(
                    'pe-7s-star' => 'pe-7s-star',
                ),
                array(
                    'pe-7s-speaker' => 'pe-7s-speaker',
                ),
                array(
                    'pe-7s-signal' => 'pe-7s-signal',
                ),
                array(
                    'pe-7s-shuffle' => 'pe-7s-shuffle',
                ),
                array(
                    'pe-7s-shopbag' => 'pe-7s-shopbag',
                ),
                array(
                    'pe-7s-share' => 'pe-7s-share',
                ),
                array(
                    'pe-7s-server' => 'pe-7s-server',
                ),
                array(
                    'pe-7s-search' => 'pe-7s-search',
                ),
                array(
                    'pe-7s-film' => 'pe-7s-film',
                ),
                array(
                    'pe-7s-science' => 'pe-7s-science',
                ),
                array(
                    'pe-7s-disk' => 'pe-7s-disk',
                ),
                array(
                    'pe-7s-ribbon' => 'pe-7s-ribbon',
                ),
                array(
                    'pe-7s-repeat' => 'pe-7s-repeat',
                ),
                array(
                    'pe-7s-refresh' => 'pe-7s-refresh',
                ),
                array(
                    'pe-7s-add-user' => 'pe-7s-add-user',
                ),
                array(
                    'pe-7s-refresh-cloud' => 'pe-7s-refresh-cloud',
                ),
                array(
                    'pe-7s-paperclip' => 'pe-7s-paperclip',
                ),
                array(
                    'pe-7s-radio' => 'pe-7s-radio',
                ),
                array(
                    'pe-7s-note2' => 'pe-7s-note2',
                ),
                array(
                    'pe-7s-print' => 'pe-7s-print',
                ),
                array(
                    'pe-7s-network' => 'pe-7s-network',
                ),
                array(
                    'pe-7s-prev' => 'pe-7s-prev',
                ),
                array(
                    'pe-7s-mute' => 'pe-7s-mute',
                ),
                array(
                    'pe-7s-power' => 'pe-7s-power',
                ),
                array(
                    'pe-7s-medal' => 'pe-7s-medal',
                ),
                array(
                    'pe-7s-portfolio' => 'pe-7s-portfolio',
                ),
                array(
                    'pe-7s-like2' => 'pe-7s-like2',
                ),
                array(
                    'pe-7s-plus' => 'pe-7s-plus',
                ),
                array(
                    'pe-7s-left-arrow' => 'pe-7s-left-arrow',
                ),
                array(
                    'pe-7s-play' => 'pe-7s-play',
                ),
                array(
                    'pe-7s-key' => 'pe-7s-key',
                ),
                array(
                    'pe-7s-plane' => 'pe-7s-plane',
                ),
                array(
                    'pe-7s-joy' => 'pe-7s-joy',
                ),
                array(
                    'pe-7s-photo-gallery' => 'pe-7s-photo-gallery',
                ),
                array(
                    'pe-7s-pin' => 'pe-7s-pin',
                ),
                array(
                    'pe-7s-phone' => 'pe-7s-phone',
                ),
                array(
                    'pe-7s-plug' => 'pe-7s-plug',
                ),
                array(
                    'pe-7s-pen' => 'pe-7s-pen',
                ),
                array(
                    'pe-7s-right-arrow' => 'pe-7s-right-arrow',
                ),
                array(
                    'pe-7s-paper-plane' => 'pe-7s-paper-plane',
                ),
                array(
                    'pe-7s-delete-user' => 'pe-7s-delete-user',
                ),
                array(
                    'pe-7s-paint' => 'pe-7s-paint',
                ),
                array(
                    'pe-7s-bottom-arrow' => 'pe-7s-bottom-arrow',
                ),
                array(
                    'pe-7s-notebook' => 'pe-7s-notebook',
                ),
                array(
                    'pe-7s-note' => 'pe-7s-note',
                ),
                array(
                    'pe-7s-next' => 'pe-7s-next',
                ),
                array(
                    'pe-7s-news-paper' => 'pe-7s-news-paper',
                ),
                array(
                    'pe-7s-musiclist' => 'pe-7s-musiclist',
                ),
                array(
                    'pe-7s-music' => 'pe-7s-music',
                ),
                array(
                    'pe-7s-mouse' => 'pe-7s-mouse',
                ),
                array(
                    'pe-7s-more' => 'pe-7s-more',
                ),
                array(
                    'pe-7s-moon' => 'pe-7s-moon',
                ),
                array(
                    'pe-7s-monitor' => 'pe-7s-monitor',
                ),
                array(
                    'pe-7s-micro' => 'pe-7s-micro',
                ),
                array(
                    'pe-7s-menu' => 'pe-7s-menu',
                ),
                array(
                    'pe-7s-map' => 'pe-7s-map',
                ),
                array(
                    'pe-7s-map-marker' => 'pe-7s-map-marker',
                ),
                array(
                    'pe-7s-mail' => 'pe-7s-mail',
                ),
                array(
                    'pe-7s-mail-open' => 'pe-7s-mail-open',
                ),
                array(
                    'pe-7s-mail-open-file' => 'pe-7s-mail-open-file',
                ),
                array(
                    'pe-7s-magnet' => 'pe-7s-magnet',
                ),
                array(
                    'pe-7s-loop' => 'pe-7s-loop',
                ),
                array(
                    'pe-7s-look' => 'pe-7s-look',
                ),
                array(
                    'pe-7s-lock' => 'pe-7s-lock',
                ),
                array(
                    'pe-7s-lintern' => 'pe-7s-lintern',
                ),
                array(
                    'pe-7s-link' => 'pe-7s-link',
                ),
                array(
                    'pe-7s-like' => 'pe-7s-like',
                ),
                array(
                    'pe-7s-light' => 'pe-7s-light',
                ),
                array(
                    'pe-7s-less' => 'pe-7s-less',
                ),
                array(
                    'pe-7s-keypad' => 'pe-7s-keypad',
                ),
                array(
                    'pe-7s-junk' => 'pe-7s-junk',
                ),
                array(
                    'pe-7s-info' => 'pe-7s-info',
                ),
                array(
                    'pe-7s-home' => 'pe-7s-home',
                ),
                array(
                    'pe-7s-help2' => 'pe-7s-help2',
                ),
                array(
                    'pe-7s-help1' => 'pe-7s-help1',
                ),
                array(
                    'pe-7s-graph3' => 'pe-7s-graph3',
                ),
                array(
                    'pe-7s-graph2' => 'pe-7s-graph2',
                ),
                array(
                    'pe-7s-graph1' => 'pe-7s-graph1',
                ),
                array(
                    'pe-7s-graph' => 'pe-7s-graph',
                ),
                array(
                    'pe-7s-global' => 'pe-7s-global',
                ),
                array(
                    'pe-7s-gleam' => 'pe-7s-gleam',
                ),
                array(
                    'pe-7s-glasses' => 'pe-7s-glasses',
                ),
                array(
                    'pe-7s-gift' => 'pe-7s-gift',
                ),
                array(
                    'pe-7s-folder' => 'pe-7s-folder',
                ),
                array(
                    'pe-7s-flag' => 'pe-7s-flag',
                ),
                array(
                    'pe-7s-filter' => 'pe-7s-filter',
                ),
                array(
                    'pe-7s-file' => 'pe-7s-file',
                ),
                array(
                    'pe-7s-expand1' => 'pe-7s-expand1',
                ),
                array(
                    'pe-7s-exapnd2' => 'pe-7s-exapnd2',
                ),
                array(
                    'pe-7s-edit' => 'pe-7s-edit',
                ),
                array(
                    'pe-7s-drop' => 'pe-7s-drop',
                ),
                array(
                    'pe-7s-drawer' => 'pe-7s-drawer',
                ),
                array(
                    'pe-7s-download' => 'pe-7s-download',
                ),
                array(
                    'pe-7s-display2' => 'pe-7s-display2',
                ),
                array(
                    'pe-7s-display1' => 'pe-7s-display1',
                ),
                array(
                    'pe-7s-diskette' => 'pe-7s-diskette',
                ),
                array(
                    'pe-7s-date' => 'pe-7s-date',
                ),
                array(
                    'pe-7s-cup' => 'pe-7s-cup',
                ),
                array(
                    'pe-7s-culture' => 'pe-7s-culture',
                ),
                array(
                    'pe-7s-crop' => 'pe-7s-crop',
                ),
                array(
                    'pe-7s-credit' => 'pe-7s-credit',
                ),
                array(
                    'pe-7s-copy-file' => 'pe-7s-copy-file',
                ),
                array(
                    'pe-7s-config' => 'pe-7s-config',
                ),
                array(
                    'pe-7s-compass' => 'pe-7s-compass',
                ),
                array(
                    'pe-7s-comment' => 'pe-7s-comment',
                ),
                array(
                    'pe-7s-coffee' => 'pe-7s-coffee',
                ),
                array(
                    'pe-7s-cloud' => 'pe-7s-cloud',
                ),
                array(
                    'pe-7s-clock' => 'pe-7s-clock',
                ),
                array(
                    'pe-7s-check' => 'pe-7s-check',
                ),
                array(
                    'pe-7s-chat' => 'pe-7s-chat',
                ),
                array(
                    'pe-7s-cart' => 'pe-7s-cart',
                ),
                array(
                    'pe-7s-camera' => 'pe-7s-camera',
                ),
                array(
                    'pe-7s-call' => 'pe-7s-call',
                ),
                array(
                    'pe-7s-calculator' => 'pe-7s-calculator',
                ),
                array(
                    'pe-7s-browser' => 'pe-7s-browser',
                ),
                array(
                    'pe-7s-box2' => 'pe-7s-box2',
                ),
                array(
                    'pe-7s-box1' => 'pe-7s-box1',
                ),
                array(
                    'pe-7s-bookmarks' => 'pe-7s-bookmarks',
                ),
                array(
                    'pe-7s-bicycle' => 'pe-7s-bicycle',
                ),
                array(
                    'pe-7s-bell' => 'pe-7s-bell',
                ),
                array(
                    'pe-7s-battery' => 'pe-7s-battery',
                ),
                array(
                    'pe-7s-ball' => 'pe-7s-ball',
                ),
                array(
                    'pe-7s-back' => 'pe-7s-back',
                ),
                array(
                    'pe-7s-attention' => 'pe-7s-attention',
                ),
                array(
                    'pe-7s-anchor' => 'pe-7s-anchor',
                ),
                array(
                    'pe-7s-albums' => 'pe-7s-albums',
                ),
                array(
                    'pe-7s-alarm' => 'pe-7s-alarm',
                ),
                array(
                    'pe-7s-airplay' => 'pe-7s-airplay',
                ),
            ),

        );
        return array_merge( $icons, $custom_icons );
    }
}
add_filter( 'vc_iconpicker-type-fontawesome', 'piroll_filter_iconpicker' );
