'use strict';

/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 2);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */,
/* 1 */,
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(3);


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* Custom View for nK Tabs */
(function ($) {
    if (typeof window.vc === 'undefined') {
        return;
    }

    window.nKTabsView = window.vc.shortcode_view.extend({
        new_tab_adding: false,
        events: {
            'click .add_tab': 'addTab',
            'click > .vc_controls .vc_control-btn-delete': 'deleteShortcode',
            'click > .vc_controls .vc_control-btn-edit': 'editElement',
            'click > .vc_controls .vc_control-btn-clone': 'clone'
        },
        initialize: function initialize(params) {
            window.nKTabsView.__super__.initialize.call(this, params);
            window._.bindAll(this, 'stopSorting');
        },
        render: function render() {
            window.nKTabsView.__super__.render.call(this);
            this.$tabs = this.$el.find('.wpb_tabs_holder');

            // remove default unused tabs
            this.$tabs.find('.tab-pane').remove();

            this.createAddTabButton();
            return this;
        },
        ready: function ready(e) {
            window.nKTabsView.__super__.ready.call(this, e);
        },
        createAddTabButton: function createAddTabButton() {
            var newTabButtonId = +new Date() + '-' + Math.floor(Math.random() * 11);
            this.$tabs.append('<div id="new-tab-' + newTabButtonId + '" class="new_element_button"></div>');
            this.$add_button = $('<li class="add_tab_block"><a href="#new-tab-' + newTabButtonId + '" class="add_tab" title="' + window.i18nLocale.add_tab + '">+</a></li>').appendTo(this.$tabs.find('.tabs_controls'));
        },
        addTab: function addTab(e) {
            e.preventDefault();
            // check user role to add controls
            if (!this.hasUserAccess()) {
                return false;
            }
            this.new_tab_adding = true;
            var tabTitle = window.i18nLocale.tab;
            var tabsCount = this.$tabs.find('[data-element_type=nk_tab]').length;
            var tabId = +new Date() + '-' + tabsCount + '-' + Math.floor(Math.random() * 11);

            window.vc.shortcodes.create({
                shortcode: 'nk_tab',
                params: { title: tabTitle, tabId: tabId },
                parent_id: this.model.id
            });
            return false;
        },
        stopSorting: function stopSorting() {
            var shortcode = void 0;

            this.$tabs.find('ul.tabs_controls li:not(.add_tab_block)').each(function () {
                shortcode = window.vc.shortcodes.get($('[id=' + $(this).attr('aria-controls') + ']').data('model-id'));
                window.vc.storage.lock();
                shortcode.save({ order: $(this).index() }); // Optimize
            });

            if (shortcode) {
                shortcode.save();
            }
        },
        changedContent: function changedContent(view) {
            var params = view.model.get('params');
            if (!this.$tabs.hasClass('ui-tabs')) {
                this.$tabs.tabs({
                    select: function select(event, ui) {
                        return !$(ui.tab).hasClass('add_tab');
                    }
                });
                this.$tabs.find('.ui-tabs-nav').prependTo(this.$tabs);
                // check user role to add controls
                if (this.hasUserAccess()) {
                    this.$tabs.find('.ui-tabs-nav').sortable({
                        axis: this.$tabs.closest('[data-element_type]').data('element_type') === 'vc_tour' ? 'y' : 'x',
                        update: this.stopSorting,
                        items: '> li:not(.add_tab_block)'
                    });
                }
            }
            if (view.model.get('cloned') === true) {
                var $tabControls = $('.tabs_controls > .add_tab_block', this.$content);
                var $newTab = $('<li><a href=\'#tab-' + params.tab_id + '\'>' + params.title + '</a></li>').insertBefore($tabControls);

                this.$tabs.tabs('refresh');
                this.$tabs.tabs('option', 'active', $newTab.index());
            } else {
                $('<li><a href=\'#tab-' + params.tab_id + '\'>' + params.title + '</a></li>').insertBefore(this.$add_button);
                this.$tabs.tabs('refresh');
                this.$tabs.tabs('option', 'active', this.new_tab_adding ? $('.ui-tabs-nav li', this.$content).length - 2 : 0);
            }
            this.new_tab_adding = false;
        },
        cloneModel: function cloneModel(model, parentId, saveOrder) {
            var newOrder = window._.isBoolean(saveOrder) && saveOrder === true ? model.get('order') : parseFloat(model.get('order')) + window.vc.clone_index;
            var params = window._.extend({}, model.get('params'));
            var tag = model.get('shortcode');

            if (tag === 'nk_tab') {
                window._.extend(params, { tab_id: +new Date() + '-' + this.$tabs.find('[data-element-type=nk_tab]').length + '-' + Math.floor(Math.random() * 11) });
            }

            var modelClone = window.vc.shortcodes.create({
                shortcode: tag,
                id: window.vc_guid(),
                parent_id: parentId,
                order: newOrder,
                cloned: tag !== 'nk_tab', // todo review this by @say2me
                cloned_from: model.toJSON(),
                params: params
            });

            window._.each(window.vc.shortcodes.where({ parent_id: model.id }), function (shortcode) {
                this.cloneModel(shortcode, modelClone.get('id'), true);
            }, this);
            return modelClone;
        }
    });

    window.nKTabView = window.VcColumnView.extend({
        events: {
            'click > .vc_controls .vc_control-btn-delete': 'deleteShortcode',
            'click > .vc_controls .vc_control-btn-prepend': 'addElement',
            'click > .vc_controls .vc_control-btn-edit': 'editElement',
            'click > .vc_controls .vc_control-btn-clone': 'clone',
            'click > .wpb_element_wrapper > .vc_empty-container': 'addToEmpty'
        },
        render: function render() {
            var params = this.model.get('params');
            window.nKTabView.__super__.render.call(this);
            /**
             * @deprecated 4.4.3
             * @see composer-atts.js vc.atts.tab_id.addShortcode
             */
            if (!params.tab_id) {
                params.tab_id = +new Date() + '-' + Math.floor(Math.random() * 11);
                this.model.save('params', params);
            }
            this.id = 'tab-' + params.tab_id;
            this.$el.attr('id', this.id);
            return this;
        },
        ready: function ready(e) {
            window.nKTabView.__super__.ready.call(this, e);
            this.$tabs = this.$el.closest('.wpb_tabs_holder');
            return this;
        },
        changeShortcodeParams: function changeShortcodeParams(model) {
            window.nKTabView.__super__.changeShortcodeParams.call(this, model);
            var params = model.get('params');

            if (window._.isObject(params) && window._.isString(params.title) && window._.isString(params.tab_id)) {
                $('.ui-tabs-nav [href="#tab-' + params.tab_id + '"]').text(params.title);
            }
        },
        deleteShortcode: function deleteShortcode(e) {
            if (window._.isObject(e)) {
                e.preventDefault();
            }
            var answer = window.confirm(window.i18nLocale.press_ok_to_delete_section);
            var parentId = this.model.get('parent_id');

            if (answer !== true) {
                return;
            }
            this.model.destroy();

            if (!window.vc.shortcodes.where({ parent_id: parentId }).length) {
                var parent = window.vc.shortcodes.get(parentId);
                parent.destroy();
                return;
            }
            var params = this.model.get('params');
            var currentTabIndex = $('[href="#tab-' + params.tab_id + '"]', this.$tabs).parent().index();
            $('[href="#tab-' + params.tab_id + '"]').parent().remove();
            var tabLength = this.$tabs.find('.ui-tabs-nav li:not(.add_tab_block)').length;

            if (tabLength > 0) {
                this.$tabs.tabs('refresh');
            }

            if (currentTabIndex < tabLength) {
                this.$tabs.tabs('option', 'active', currentTabIndex);
            } else if (tabLength > 0) {
                this.$tabs.tabs('option', 'active', tabLength - 1);
            }
        },
        cloneModel: function cloneModel(model, parentId, saveOrder) {
            var newOrder = window._.isBoolean(saveOrder) && saveOrder === true ? model.get('order') : parseFloat(model.get('order')) + window.vc.clone_index;
            var params = window._.extend({}, model.get('params'));
            var tag = model.get('shortcode');

            if (tag === 'nk_tab') {
                window._.extend(params, { tab_id: +new Date() + '-' + this.$tabs.find('[data-element_type=nk_tab]').length + '-' + Math.floor(Math.random() * 11) });
            }

            var modelClone = window.vc.shortcodes.create({
                shortcode: tag,
                parent_id: parentId,
                order: newOrder,
                cloned: true,
                cloned_from: model.toJSON(),
                params: params
            });

            window._.each(window.vc.shortcodes.where({ parent_id: model.id }), function (shortcode) {
                this.cloneModel(shortcode, modelClone.get('id'), true);
            }, this);
            return modelClone;
        }
    });
})(jQuery);

/***/ })
/******/ ]);