<?php
/**
 * nK Button
 *
 * Example:
 * [nk_button link="https://googlee.com" icon_right="" icon_left="" block="false" long="false" size="md" ]My Button[/nk_button]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_button', 'nk_button' );

if ( ! function_exists( 'nk_button' ) ) :
    function nk_button( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'style' => '1',
                    'link' => '',
                    'icon_right' => '',
                    'icon_left' => '',
                    'block' => '',
                    'long' => '',
                    'size' => 'md',
                    'class' => '',
                ), $atts
            )
        );

        // add classes
        if ( $style == 2 ) {
            $class .= ' nk-btn-2';
        } else {
            $class .= ' nk-btn';

            if ( piroll_check( $size ) ) {
                $class .= ' nk-btn-' . $size;
            }

            if ( piroll_check( $block ) ) {
                $class .= ' nk-btn-block';
            }

            if ( piroll_check( $long ) ) {
                $class .= ' nk-btn-long';
            }
        }

        // icons
        $icon_str_right = $icon_str_left = '';
        if ( piroll_check( $icon_right ) ) {
            $icon_str_right = ' <span class="icon"><span class="' . esc_attr( $icon_right ) . '"></span></span> ';
        }
        if ( piroll_check( $icon_left ) ) {
            $icon_str_left = ' <span class="icon"><span class="' . esc_attr( $icon_left ) . '"></span></span> ';
        }

        // link
        $link_atts = '';
        $tag = 'span';
        if ( piroll_check( $link ) && function_exists( 'vc_build_link' ) ) {
            $link = vc_build_link( $link );

            if ( isset( $link['url'] ) && $link['url'] ) {
                $tag = 'a';
                $link_atts = ' href="' . esc_attr( $link['url'] ) . '"';

                if ( isset( $link['title'] ) && $link['title'] ) {
                    $link_atts .= ' title="' . esc_attr( $link['title'] ) . '"';
                }
                if ( isset( $link['target'] ) && $link['target'] ) {
                    $link_atts .= ' target="' . esc_attr( $link['target'] ) . '"';
                }
                if ( isset( $link['rel'] ) && $link['rel'] ) {
                    $link_atts .= ' rel="' . esc_attr( $link['rel'] ) . '"';
                }
            }
        } else if ( piroll_check( $link ) ) {
            $tag = 'a';
            $link_atts = ' href="' . esc_attr( $link ) . '"';
        }

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        return '<' . $tag . $link_atts . ' class="' . esc_attr( $class ) . '">' . $icon_str_left . '<span>' . $content . '</span>' . $icon_str_right . '</' . $tag . '>';
    }
endif;


add_action( 'init', 'vc_nk_button' );
if ( ! function_exists( 'vc_nk_button' ) ) :
    function vc_nk_button() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Button', 'piroll-shortcodes' ),
                    'base' => 'nk_button',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-button',
                    'params' => array_merge(
                        array(
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Style', 'piroll-shortcodes' ),
                                'param_name' => 'style',
                                'std'        => '1',
                                'value'      => array(
                                    esc_html__( 'Default', 'piroll-shortcodes' )  => '1',
                                    esc_html__( 'Link', 'piroll-shortcodes' )  => '2',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Text', 'piroll-shortcodes' ),
                                'param_name'  => 'content',
                                'value'       => 'Button',
                                'description' => '',
                                'admin_label' => true,
                            ),
                            array(
                                'type'       => 'vc_link',
                                'heading'    => esc_html__( 'Link', 'piroll-shortcodes' ),
                                'param_name' => 'link',
                            ),
                            array(
                                'type'        => 'iconpicker',
                                'heading'     => esc_html__( 'Icon Left', 'piroll-shortcodes' ),
                                'param_name'  => 'icon_left',
                            ),
                            array(
                                'type'        => 'iconpicker',
                                'heading'     => esc_html__( 'Icon Right', 'piroll-shortcodes' ),
                                'param_name'  => 'icon_right',
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Size', 'piroll-shortcodes' ),
                                'param_name' => 'size',
                                'std'        => '',
                                'value'      => array(
                                    esc_html__( 'Extra Small', 'piroll-shortcodes' )  => 'xs',
                                    esc_html__( 'Small', 'piroll-shortcodes' )  => 'sm',
                                    esc_html__( 'Mid', 'piroll-shortcodes' )    => '',
                                    esc_html__( 'Large', 'piroll-shortcodes' )  => 'lg',
                                ),
                                'dependency' => array(
                                    'element'    => 'style',
                                    'value'      => array( '1' ),
                                ),
                                'description' => '',
                            ),
                            array(
                                'param_name'  => 'block',
                                'heading'     => esc_html__( 'Block', 'piroll-shortcodes' ),
                                'type'        => 'checkbox',
                                'value'       => array(
                                    '' => true,
                                ),
                                'dependency' => array(
                                    'element'    => 'style',
                                    'value'      => array( '1' ),
                                ),
                            ),
                            array(
                                'param_name'  => 'long',
                                'heading'     => esc_html__( 'Long', 'piroll-shortcodes' ),
                                'type'        => 'checkbox',
                                'value'       => array(
                                    '' => true,
                                ),
                                'dependency' => array(
                                    'element'    => 'style',
                                    'value'      => array( '1' ),
                                ),
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;
