<?php
/**
 * nK Carousel
 *
 * Example:
 * [nk_carousel autoplay="0" show_arrows="false" show_dots="false" no_margin="false" all_visible="false" style="1" size="1"]
 *     [nk_carousel_item]Item Content[/nk_carousel_item]
 *     [nk_carousel_item]Item Content[/nk_carousel_item]
 * [/nk_carousel]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_carousel', 'nk_carousel' );

if ( ! function_exists( 'nk_carousel' ) ) :
    function nk_carousel( $atts, $content = null ) {
        if ( ! piroll_check( $content ) ) {
            return '';
        }

        extract(
            shortcode_atts(
                array(
                    'autoplay' => '',
                    'show_arrows' => '', // 1, 2
                    'show_dots' => '',
                    'no_margin' => '',
                    'all_visible' => '',
                    'style' => '1',
                    'size' => '',
                    'class' => '',
                ), $atts
            )
        );

        if ( $style == 2 || $style == 3 ) {
            $class .= ' nk-carousel-' . $style;
        } else {
            $class .= ' nk-carousel';
        }

        if ( piroll_check( $size ) ) {
            $class .= ' nk-carousel-x' . $size;
        }
        if ( piroll_check( $no_margin ) ) {
            $class .= ' nk-carousel-no-margin';
        }
        if ( piroll_check( $all_visible ) ) {
            $class .= ' nk-carousel-all-visible';
        }

        $attributes = '';
        if ( piroll_check( $autoplay ) ) {
            $attributes .= ' data-autoplay="' . esc_attr( $autoplay ) . '"';
        }
        if ( piroll_check( $show_arrows ) || $show_arrows == 2 ) {
            $attributes .= ' data-arrows="true"';
        }
        if ( $show_arrows == 2 ) {
            $class .= ' nk-carousel-arrows-2';
        }
        if ( piroll_check( $show_dots ) ) {
            $attributes .= ' data-dots="true"';
        }

        $attributes .= ' data-size="1"';

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        return '<div class="' . esc_attr( $class ) . '"' . $attributes . '>
                   <div class="nk-carousel-inner">'
                   . do_shortcode( $content ) .
                   '</div>
                </div>';
    }
endif;

// image for carousel
nk_theme()->reg_shortcode( 'nk_carousel_item', 'nk_carousel_item' );

if ( ! function_exists( 'nk_carousel_item' ) ) :
    function nk_carousel_item( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'class' => '',
                ), $atts
            )
        );

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        return '<div><div class="' . esc_attr( $class ) . '">' . do_shortcode( $content ) . '</div></div>';
    }
endif;


/* Add VC Shortcode */
add_action( 'init', 'vc_nk_carousel' );
if ( ! function_exists( 'vc_nk_carousel' ) ) :
    function vc_nk_carousel() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name'     => esc_html__( 'nK Carousel', 'piroll-shortcodes' ),
                    'base'     => 'nk_carousel',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-carousel',
                    'as_parent' => array( 'only' => 'nk_carousel_item' ),
                    'content_element' => true,
                    'show_settings_on_create' => false,
                    'admin_enqueue_css'       => plugin_dir_url( __FILE__ ) . 'css/nk-carousel-vc-view.css',
                    'js_view' => 'VcColumnView',
                    'params'   => array_merge(
                        array(
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Autoplay', 'piroll-shortcodes' ),
                                'param_name'  => 'autoplay',
                                'value'       => '0',
                                'description' => esc_html__( 'Type integer value in ms', 'piroll-shortcodes' ),
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Show Arrows', 'piroll-shortcodes' ),
                                'param_name' => 'show_arrows',
                                'std'        => '',
                                'value'      => array(
                                    esc_html__( 'Disabled', 'piroll-shortcodes' ) => '',
                                    esc_html__( 'Style 1', 'piroll-shortcodes' ) => true,
                                    esc_html__( 'Style 2', 'piroll-shortcodes' ) => 2,
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'        => 'checkbox',
                                'heading'     => esc_html__( 'Show Dots', 'piroll-shortcodes' ),
                                'param_name'  => 'show_dots',
                                'value'       => array( '' => true ),
                            ),
                            array(
                                'type'        => 'checkbox',
                                'heading'     => esc_html__( 'No Margin Between Slides', 'piroll-shortcodes' ),
                                'param_name'  => 'no_margin',
                                'value'       => array( '' => true ),
                            ),
                            array(
                                'type'        => 'checkbox',
                                'heading'     => esc_html__( 'All Visible', 'piroll-shortcodes' ),
                                'description' => esc_html__( 'By default non-active slides semi-transparent, this option removed transparency.', 'piroll-shortcodes' ),
                                'param_name'  => 'all_visible',
                                'value'       => array( '' => true ),
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Style', 'piroll-shortcodes' ),
                                'param_name' => 'style',
                                'std'        => '1',
                                'value'      => array(
                                    esc_html__( 'Style 1', 'piroll-shortcodes' ) => '1',
                                    esc_html__( 'Style 2', 'piroll-shortcodes' ) => '2',
                                    esc_html__( 'Style 3', 'piroll-shortcodes' ) => '3',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Size', 'piroll-shortcodes' ),
                                'param_name' => 'size',
                                'std'        => false,
                                'value'      => array(
                                    esc_html__( 'Default', 'piroll-shortcodes' ) => false,
                                    esc_html__( 'X1', 'piroll-shortcodes' ) => '1',
                                    esc_html__( 'X2', 'piroll-shortcodes' ) => '2',
                                    esc_html__( 'X3', 'piroll-shortcodes' ) => '3',
                                    esc_html__( 'X4', 'piroll-shortcodes' ) => '4',
                                ),
                                'dependency' => array(
                                    'element'    => 'style',
                                    'value'      => array( '2' ),
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;


add_action( 'init', 'vc_nk_carousel_item' );
if ( ! function_exists( 'vc_nk_carousel_item' ) ) :
    function vc_nk_carousel_item() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name'     => esc_html__( 'nK Carousel Item', 'piroll-shortcodes' ),
                    'base'     => 'nk_carousel_item',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-single-image',
                    'as_child' => array( 'only' => 'nk_carousel' ),
                    'content_element' => true,
                    'is_container'  => true,
                    'js_view'  => 'VcColumnView',
                    'params'   => array_merge(
                        array(
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;


// Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_nk_carousel extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_nk_carousel_item extends WPBakeryShortCodesContainer {
    }
}
