<?php
/**
 * nK Contact Info
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_contact_info', 'nk_contact_info' );

if ( ! function_exists( 'nk_contact_info' ) ) :
    function nk_contact_info( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'class' => '',
                ), $atts
            )
        );

        $result = '';

        if ( piroll_check( $content ) && function_exists( 'vc_param_group_parse_atts' ) ) {
            $class .= piroll_get_css_tab_class( $atts );

            $result .= '<ul class="nk-contact-info ' . esc_attr( $class ) . '">';

            $content = vc_param_group_parse_atts( $content );
            foreach ( $content as $item ) {
                $result .= '<li>';
                if ( isset( $item['title'] ) ) {
                    $result .= '<strong>' . esc_html( $item['title'] ) . ':</strong>';
                }
                if ( isset( $item['value'] ) ) {
                    $result .= ' ' . esc_html( $item['value'] );
                }
                $result .= '</li>';
            }

            $result .= '</ul>';
        }

        return $result;
    }
endif;


add_action( 'init', 'vc_nk_contact_info' );
if ( ! function_exists( 'vc_nk_contact_info' ) ) :
    function vc_nk_contact_info() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Contact Info', 'piroll-shortcodes' ),
                    'base' => 'nk_contact_info',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-contact',
                    'params' => array_merge(
                        array(
                            array(
                                'type'        => 'param_group',
                                'heading'     => esc_html__( 'Contact Fields', 'piroll-shortcodes' ),
                                'value'       => '',
                                'param_name'  => 'content',
                                'params'      => array(
                                    array(
                                        'type'        => 'textfield',
                                        'heading'     => esc_html__( 'Title', 'piroll-shortcodes' ),
                                        'param_name'  => 'title',
                                        'value'       => '',
                                    ),
                                    array(
                                        'type'        => 'textfield',
                                        'heading'     => esc_html__( 'Value', 'piroll-shortcodes' ),
                                        'param_name'  => 'value',
                                        'value'       => '',
                                        'admin_label' => true,
                                    ),
                                ),
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;
