<?php
/**
 * nK Icon Box
 *
 * Example:
 * [nk_icon_box icon="fa fa-search" title="Title"]My Content[/nk_icon_box]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_icon_box', 'nk_icon_box' );

if ( ! function_exists( 'nk_icon_box' ) ) :
    function nk_icon_box( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'style' => '1',
                    'icon' => '',
                    'icon_link' => '',
                    'title' => '',
                    'title_link' => '',
                    'class' => '',
                ), $atts
            )
        );

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        if ( $style == '2' ) {
            $class .= ' nk-ibox-3';
        } else if ( $style == '3' ) {
            $class .= ' nk-ibox-2';
        } else {
            $class .= ' nk-ibox-1';
        }

        if ( $icon ) {
            $link_atts = '';
            $tag = 'span';
            if ( piroll_check( $icon_link ) && function_exists( 'vc_build_link' ) ) {
                $icon_link = vc_build_link( $icon_link );

                if ( isset( $icon_link['url'] ) && $icon_link['url'] ) {
                    $tag = 'a';
                    $link_atts = ' href="' . esc_attr( $icon_link['url'] ) . '"';

                    if ( isset( $icon_link['title'] ) && $icon_link['title'] ) {
                        $link_atts .= ' title="' . esc_attr( $icon_link['title'] ) . '"';
                    }
                    if ( isset( $icon_link['target'] ) && $icon_link['target'] ) {
                        $link_atts .= ' target="' . esc_attr( $icon_link['target'] ) . '"';
                    }
                    if ( isset( $icon_link['rel'] ) && $icon_link['rel'] ) {
                        $link_atts .= ' rel="' . esc_attr( $icon_link['rel'] ) . '"';
                    }
                }
            } else if ( piroll_check( $icon_link ) ) {
                $tag = 'a';
                $link_atts = ' href="' . esc_attr( $icon_link ) . '"';
            }
            $icon = '<div class="nk-ibox-icon"><' . $tag . ' class="' . esc_attr( $icon ) . '" ' . $link_atts . '></' . $tag . '></div>';
        }

        if ( $title ) {
            $link_atts = '';
            $tag = 'span';
            if ( piroll_check( $title_link ) && function_exists( 'vc_build_link' ) ) {
                $title_link = vc_build_link( $title_link );

                if ( isset( $title_link['url'] ) && $title_link['url'] ) {
                    $tag = 'a';
                    $link_atts = ' href="' . esc_attr( $title_link['url'] ) . '"';

                    if ( isset( $title_link['title'] ) && $title_link['title'] ) {
                        $link_atts .= ' title="' . esc_attr( $title_link['title'] ) . '"';
                    }
                    if ( isset( $title_link['target'] ) && $title_link['target'] ) {
                        $link_atts .= ' target="' . esc_attr( $title_link['target'] ) . '"';
                    }
                    if ( isset( $title_link['rel'] ) && $title_link['rel'] ) {
                        $link_atts .= ' rel="' . esc_attr( $title_link['rel'] ) . '"';
                    }
                }
            } else if ( piroll_check( $title_link ) ) {
                $tag = 'a';
                $link_atts = ' href="' . esc_attr( $title_link ) . '"';
            }
            $title = '<div class="nk-ibox-title"><' . $tag . ' ' . $link_atts . '>' . esc_html( $title ) . '</' . $tag . '></div>';
        }

        return '<div class="' . esc_attr( $class ) . '">' . $icon . '<div class="nk-ibox-cont">' . $title . '<div class="nk-ibox-text">' . esc_html( $content ) . '</div></div></div>';
    }
endif;

add_action( 'init', 'vc_nk_icon_box' );
if ( ! function_exists( 'vc_nk_icon_box' ) ) :
    function vc_nk_icon_box() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Icon Box', 'piroll-shortcodes' ),
                    'base' => 'nk_icon_box',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-icon-box',
                    'params' => array_merge(
                        array(
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Style', 'piroll-shortcodes' ),
                                'param_name' => 'style',
                                'std'        => '1',
                                'value'      => array(
                                    esc_html__( 'Style 1', 'piroll-shortcodes' )  => '1',
                                    esc_html__( 'Style 2', 'piroll-shortcodes' )  => '2',
                                    esc_html__( 'Style 3', 'piroll-shortcodes' )  => '3',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'        => 'iconpicker',
                                'heading'     => esc_html__( 'Icon', 'piroll-shortcodes' ),
                                'param_name'  => 'icon',
                                'admin_label' => true,
                                'value'       => '',
                            ),
                            array(
                                'type'       => 'vc_link',
                                'heading'    => esc_html__( 'Icon Link', 'piroll-shortcodes' ),
                                'param_name' => 'icon_link',
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Title', 'piroll-shortcodes' ),
                                'param_name'  => 'title',
                                'value'       => '',
                                'description' => '',
                                'admin_label' => true,
                            ),
                            array(
                                'type'       => 'vc_link',
                                'heading'    => esc_html__( 'Title Link', 'piroll-shortcodes' ),
                                'param_name' => 'title_link',
                            ),
                            array(
                                'type'        => 'textarea',
                                'heading'     => esc_html__( 'Inner Text', 'piroll-shortcodes' ),
                                'param_name'  => 'content',
                                'value'       => '',
                                'description' => '',
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;
