<?php
/**
 * nK Images Carousel
 *
 * Example:
 * [nk_images_carousel images="12,53,18" images_size="piroll_1280x720_crop" on_click="popup" autoplay="0" show_arrows="false" show_dots="false" no_margin="false" all_visible="false" style="1" size=""]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_images_carousel', 'nk_images_carousel' );

if ( ! function_exists( 'nk_images_carousel' ) ) :
    function nk_images_carousel( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'images' => '',
                    'images_size' => 'piroll_1280x720_crop',
                    'on_click' => 'popup',
                    'autoplay' => 0,
                    'show_arrows' => '',
                    'show_dots' => '',
                    'no_margin' => '',
                    'all_visible' => '',
                    'style' => '1',
                    'size' => '',
                    'class' => '',
                ), $atts
            )
        );

        if ( ! piroll_check( $images ) ) {
            return '';
        }

        // classes for carousel container
        if ( $style == 2 || $style == 3 ) {
            $class .= ' nk-carousel-' . $style;
        } else {
            $class .= ' nk-carousel';
        }
        if ( piroll_check( $size ) ) {
            $class .= ' nk-carousel-x' . $size;
        }
        if ( piroll_check( $no_margin ) ) {
            $class .= ' nk-carousel-no-margin';
        }
        if ( piroll_check( $all_visible ) ) {
            $class .= ' nk-carousel-all-visible';
        }

        // attributes for carousel container
        $attributes = '';
        if ( piroll_check( $show_arrows ) ) {
            $attributes .= ' data-arrows="true"';
        }
        if ( piroll_check( $autoplay ) ) {
            $attributes .= ' data-autoplay="' . esc_attr( $autoplay ) . '"';
        }
        if ( piroll_check( $show_dots ) ) {
            $attributes .= ' data-dots="true"';
        }
        $attributes .= ' data-size="1"';

        // prepare images
        $ar_images = explode( ',', $images );
        $images_str = '';
        foreach ( $ar_images as $image_id ) {
            $attachment = piroll_get_attachment( $image_id, $images_size );

            if ( piroll_check( $attachment ) ) {
                $image_on_click_link = false;
                $image = '<img src="' . esc_url( $attachment['src'] ) . '" alt="' . esc_attr( $attachment['alt'] ) . '" class="' . ( $style != 3 ? 'nk-img-fit' : '' ) . '">';

                // popup image
                $data_size = '';
                if ( $on_click == 'popup' ) {
                    $image_on_click_link = $attachment['src'];
                    $popup_attachment = piroll_get_attachment( $image_id, '1920x1080' );

                    if ( piroll_check( $popup_attachment ) ) {
                        $image_on_click_link = $popup_attachment['src'];
                        if ( $popup_attachment['width'] && $popup_attachment['height'] ) {
                            $data_size = ' data-size="' . esc_attr( $popup_attachment['width'] ) . 'x' . esc_attr( $popup_attachment['height'] ) . '"';
                        }
                    }
                }

                // custom link
                if ( $on_click == 'custom' ) {
                    $image_on_click_link = get_post_meta( $image_id, 'link', true );
                }

                // prepare image container
                if ( $image_on_click_link ) {
                    $image = '<a href="' . esc_url( $image_on_click_link ) . '" class="nk-gallery-item"' . $data_size . '>' . $image . '</a>';
                } else {
                    $image = '<div class="nk-gallery-item">' . $image . '</div>';
                }

                $images_str .= '<div><div>
                                    ' . $image . '
                                </div></div>';
            }
        }

        $gallery_class = '';
        if ( $on_click == 'popup' ) {
            $gallery_class = ' nk-popup-gallery';
        }

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        return '<div class="' . esc_attr( $class ) . '"' . $attributes . '>
                    <div class="' . esc_attr( 'nk-carousel-inner' . $gallery_class ) . '">
                    ' . $images_str . '
                    </div>
                </div>';
    }
endif;

add_action( 'init', 'vc_nk_images_carousel' );
if ( ! function_exists( 'vc_nk_images_carousel' ) ) :
    function vc_nk_images_carousel() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Images Carousel', 'piroll-shortcodes' ),
                    'base' => 'nk_images_carousel',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-images-carousel',
                    'params' => array_merge(
                        array(
                            array(
                                'type'        => 'attach_images',
                                'heading'     => esc_html__( 'Select Images', 'piroll-shortcodes' ),
                                'param_name'  => 'images',
                                'admin_label' => true,
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Images Size', 'piroll-shortcodes' ),
                                'param_name' => 'images_size',
                                'std'        => 'piroll_1280x720_crop',
                                'value'      => get_intermediate_image_sizes(),
                                'description' => '',
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'On Click', 'piroll-shortcodes' ),
                                'param_name' => 'on_click',
                                'std'        => 'popup',
                                'value'      => array(
                                    esc_html__( 'Disable', 'piroll-shortcodes' ) => false,
                                    esc_html__( 'Popup', 'piroll-shortcodes' ) => 'popup',
                                    esc_html__( 'Custom Link', 'piroll-shortcodes' ) => 'custom',
                                ),
                                'description' => esc_html__( 'Custom Link option works only with Link property in Media Uploader', 'piroll-shortcodes' ),
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Autoplay', 'piroll-shortcodes' ),
                                'param_name'  => 'autoplay',
                                'value'       => 0,
                                'description' => esc_html__( 'Type integer value in ms', 'piroll-shortcodes' ),
                            ),
                            array(
                                'type'        => 'checkbox',
                                'heading'     => esc_html__( 'Show Arrows', 'piroll-shortcodes' ),
                                'param_name'  => 'show_arrows',
                                'value'       => array(
                                    '' => true,
                                ),
                            ),
                            array(
                                'type'        => 'checkbox',
                                'heading'     => esc_html__( 'Show Dots', 'piroll-shortcodes' ),
                                'param_name'  => 'show_dots',
                                'value'       => array(
                                    '' => true,
                                ),
                            ),
                            array(
                                'type'        => 'checkbox',
                                'heading'     => esc_html__( 'No Margin Between Slides', 'piroll-shortcodes' ),
                                'param_name'  => 'no_margin',
                                'value'       => array(
                                    '' => true,
                                ),
                            ),
                            array(
                                'type'        => 'checkbox',
                                'heading'     => esc_html__( 'All Visible', 'piroll-shortcodes' ),
                                'description' => esc_html__( 'By default non-active slides semi-transparent, this option removed transparency.', 'piroll-shortcodes' ),
                                'param_name'  => 'all_visible',
                                'value'       => array(
                                    '' => true,
                                ),
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Style', 'piroll-shortcodes' ),
                                'param_name' => 'style',
                                'std'        => '1',
                                'value'      => array(
                                    esc_html__( 'Style 1', 'piroll-shortcodes' ) => '1',
                                    esc_html__( 'Style 2', 'piroll-shortcodes' ) => '2',
                                    esc_html__( 'Style 3', 'piroll-shortcodes' ) => '3',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Size', 'piroll-shortcodes' ),
                                'param_name' => 'size',
                                'std'        => false,
                                'value'      => array(
                                    esc_html__( 'Default', 'piroll-shortcodes' ) => false,
                                    esc_html__( 'X1', 'piroll-shortcodes' ) => '1',
                                    esc_html__( 'X2', 'piroll-shortcodes' ) => '2',
                                    esc_html__( 'X3', 'piroll-shortcodes' ) => '3',
                                    esc_html__( 'X4', 'piroll-shortcodes' ) => '4',
                                ),
                                'dependency' => array(
                                    'element'    => 'style',
                                    'value'      => array( '2' ),
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;
