<?php
/**
 * nK Portfolio Custom List
 *
 * Example:
 * [nk_portfolio_custom_list post_type="post" ids="" exclude_ids="" custom_query="" taxonomies="" count="5" pagination="false"]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_portfolio_custom_list', 'nk_portfolio_custom_list' );

if ( ! function_exists( 'nk_portfolio_custom_list' ) ) :
    function nk_portfolio_custom_list( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'style' => 'masonry_3_style_1',
                    'items_gap' => 'disabled',
                    'items_hover_style' => '1_left_bottom',

                    // colors
                    'items_1_hover_background' => 'rgba(0,0,0,.85)',
                    'items_1_hover_color' => '#fff',
                    'items_2_background' => 'rgba(0,0,0,.6)',
                    'items_2_hover_background' => 'rgba(0,0,0,.85)',
                    'items_2_color' => '#fff',
                    'items_2_hover_color' => '#fff',
                    'items_3_background' => '#fff',
                    'items_3_color' => '#000',

                    'items_click_action' => 'page',
                    'items_click_target' => '',
                    'items_description' => 'title',
                    'items_description_icon' => 'pe-7s-look',
                    'class' => '',
                ), $atts
            )
        );

        static $nk_portfolio_custom_list_id = 0;
        $nk_portfolio_custom_list_id++;

        /**
         * Work with printing posts
         */
        $classes_array = piroll_get_portfolio_classes( $style, $items_gap, $items_hover_style, 0 );
        $class .= ' ' . $classes_array['parent_class'];

        if ( $items_click_action == 'image' ) {
            $class .= ' nk-popup-gallery';
        }

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        ob_start();
        ?>
        <div>
            <div id="nk-portfolio-custom-list-<?php echo esc_attr( $nk_portfolio_custom_list_id ); ?>" class="<?php echo esc_attr( $class ); ?>">
                                                            <?php

                                                            // Extract child shortcodes
                                                            $pattern = get_shortcode_regex();
                                                            $count = preg_match_all( '/' . $pattern . '/s', $content, $matches, PREG_SET_ORDER );
                                                            $items = $count ? $matches : array();

                                                            // prepare portfolio items by ID
                                                            $pf_item_ids = array();
                                                            $pf_items = array();
                                                            foreach ( $items as $item ) {
                                                                $item_shortcode_name = $item[2];
                                                                $item_atts = shortcode_parse_atts( $item[3] );
                                                                if ( $item_shortcode_name == 'nk_portfolio_item'
                                                                        && isset( $item_atts['item_id'] )
                                                                        && $item_atts['item_id']
                                                                        && ! in_array( $item_atts['item_id'], $pf_item_ids ) ) {
                                                                    $pf_item_ids[] = $item_atts['item_id'];
                                                                }
                                                            }
                                                            if ( count( $pf_item_ids ) ) {
                                                                $query_opts = array(
                                                                    'post_type' => 'portfolio',
                                                                    'showposts' => 100,
                                                                    'posts_per_page' => 100,
                                                                    'paged' => 0,
                                                                    'post__in' => $pf_item_ids,
                                                                );
                                                                $nk_query = new WP_Query( $query_opts );
                                                                while ( $nk_query->have_posts() ) :
                                                                    $nk_query->the_post();
                                                                    $categories = get_the_terms( get_the_ID(), 'portfolio-category' );
                                                                    $categories_string = '';
                                                                    if ( $categories ) {
                                                                        foreach ( $categories as $cat ) {
                                                                            if ( $categories_string ) {
                                                                                $categories_string .= ',';
                                                                            }
                                                                            $categories_string .= $cat->name;
                                                                        }
                                                                    }
                                                                    $pf_items[ get_the_ID() ] = array(
                                                                        'id' => get_the_ID(),
                                                                        'attachment' => piroll_get_attachment( get_post_thumbnail_id( get_the_ID() ), 'piroll_800x600' ),
                                                                        'attachment_full' => piroll_get_attachment( get_post_thumbnail_id( get_the_ID() ), 'piroll_1920x1080' ),
                                                                        'categories' => $categories,
                                                                        'categories_string' => $categories_string,
                                                                        'permalink' => get_permalink(),
                                                                        'title' => '<h2 class="portfolio-item-title h3">' . get_the_title( get_the_ID() ) . '</h2>',
                                                                    );
                                                                endwhile;
                                                                wp_reset_postdata();
                                                            }

                                                            // print portfolio list
                                                            $i = 0;
                                                            foreach ( $items as $item ) {
                                                                $item_shortcode_name = $item[2];
                                                                $item_atts = shortcode_parse_atts( $item[3] );
                                                                $item_content = $item[5];

                                                                $classes_array = piroll_get_portfolio_classes( $style, $items_gap, $items_hover_style, $i++ );

                                                                // custom content item
                                                                if ( $item_shortcode_name == 'nk_portfolio_custom_item' ) {
                                                                    $item_class = $classes_array['item_class'];
                                                                    $item_info_class = $classes_array['item_info_class'];
                                                                    $url = isset( $item_atts['url'] ) ? $item_atts['url'] : false;
                                                                    $image = isset( $item_atts['image'] ) ? $item_atts['image'] : false;
                                                                    if ( $image ) {
                                                                        $image = piroll_get_attachment( $image, 'piroll_800x600' );
                                                                    }

                                                                    if ( isset( $item_atts['no_hover'] ) && piroll_check( $item_atts['no_hover'] ) ) {
                                                                        $item_class = str_replace( array( '-style-1', '-style-3' ), '-style-2', $item_class );
                                                                        $item_class .= ' hover';
                                                                        $item_info_class = 'nk-portfolio-item-info nk-portfolio-item-info-center';
                                                                    }
                                                                    ?>
                                                                    <div class="<?php echo esc_attr( $classes_array['isotope_item_class'] ); ?>">
                        <div class="<?php echo esc_attr( $item_class ); ?>">
                                                                    <?php if ( $url ) : ?>
                                    <a href="<?php echo esc_url( $url ); ?>" class="nk-portfolio-item-link" target="<?php echo esc_attr( $items_click_target ); ?>"></a>
                                <?php endif; ?>

                            <div class="nk-portfolio-item-image">
                                                                    <?php if ( $image && isset( $image['src'] ) && ! empty( $image['src'] ) ) : ?>
                                    <div style="background-image: url('<?php echo esc_url( $image['src'] ); ?>')"></div>
                                <?php endif; ?>
                            </div>

                            <div class="nk-portfolio-item-info <?php echo esc_attr( $item_info_class ); ?>">
                                <div>
                                                                    <?php echo do_shortcode( $item_content ); ?>
                                </div>
                            </div>
                        </div>
                        </div>
                                                                    <?php
                                                                } // portfolio item
                                                                else if ( isset( $item_atts['item_id'] ) && isset( $pf_items[ $item_atts['item_id'] ] ) ) {
                                                                    $pf_item = $pf_items[ $item_atts['item_id'] ];
                                                                    $attachment = $pf_item['attachment'];
                                                                    $attachment_full = $pf_item['attachment_full'];
                                                                    ?>
                                                                    <div id="work-<?php echo esc_attr( $pf_item['id'] ); ?>" class="<?php echo esc_attr( $classes_array['isotope_item_class'] ); ?>">
                        <div class="<?php echo esc_attr( $classes_array['item_class'] ); ?>">
                                                                    <?php if ( $items_click_action == 'page' ) : ?>
                                    <a href="<?php echo esc_url( $pf_item['permalink'] ); ?>" class="nk-portfolio-item-link" target="<?php echo esc_attr( $items_click_target ); ?>"></a>
                                <?php endif; ?>

                                                                    <?php if ( isset( $attachment['src'] ) && ! empty( $attachment['src'] ) ) : ?>
                                                                        <?php if ( $items_click_action == 'image' ) : ?>
                                        <a href="<?php echo esc_url( $attachment_full['src'] ); ?>" class="nk-portfolio-item-link nk-gallery-item" data-size="<?php echo esc_attr( $attachment_full['width'] ); ?>x<?php echo esc_attr( $attachment_full['height'] ); ?>"></a>
                                    <?php endif; ?>

                                    <div class="nk-portfolio-item-image">
                                        <div style="background-image: url('<?php echo esc_url( $attachment['src'] ); ?>')"></div>
                                    </div>
                                <?php endif; ?>

                            <div class="nk-portfolio-item-info <?php echo esc_attr( $classes_array['item_info_class'] ); ?>">
                                <div>
                                                                    <?php if ( $items_description == 'title' ) : ?>
                                                                        <?php echo wp_kses_post( $pf_item['title'] ); ?>
                                            <div class="portfolio-item-category"><?php echo esc_html( str_replace( ',', ', ', $pf_item['categories_string'] ) ); ?></div>
                                        <?php elseif ( $items_description == 'icon' ) : ?>
                                            <div class="portfolio-item-icon"><span class="<?php echo esc_attr( $items_description_icon ); ?>"></span></div>
                                        <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        </div>
                                                                    <?php
                                                                }

                                                                ?>
                                                                <?php
                                                            }
                                                            ?>
            </div>
        </div>

        <?php
        /**
         * Print custom CSS
         */
        $custom_css_selector = '#nk-portfolio-custom-list-' . esc_attr( $nk_portfolio_custom_list_id );
        ?>
        <style>
            <?php
            if ( strpos( $items_hover_style, '1_' ) !== false ) :
                echo esc_attr( $custom_css_selector . ' .nk-portfolio-item.nk-portfolio-item-info-style-1 .nk-portfolio-item-info { background-color: ' . $items_1_hover_background . '; color: ' . $items_1_hover_color . '; }' );
            elseif ( strpos( $items_hover_style, '2_' ) !== false ) :
                echo esc_attr( $custom_css_selector . ' .nk-portfolio-item.nk-portfolio-item-info-style-1 .nk-portfolio-item-info { background-color: ' . $items_2_background . '; color: ' . $items_2_color . '; }' );
                echo esc_attr( $custom_css_selector . ' .nk-portfolio-item.nk-portfolio-item-info-style-1:hover .nk-portfolio-item-info { background-color: ' . $items_2_hover_background . '; color: ' . $items_2_hover_color . '; }' );
            else :
                echo esc_attr( $custom_css_selector . ' .nk-portfolio-item.nk-portfolio-item-info-style-3 .nk-portfolio-item-info { background-color: ' . $items_3_background . '; color: ' . $items_3_color . '; }' );
            endif;
            ?>
        </style>
        <?php

        $result = ob_get_contents();
        ob_end_clean();
        return $result;
    }
endif;


// each portfolio item shortcode (custom content)
nk_theme()->reg_shortcode( 'nk_portfolio_custom_item', 'nk_portfolio_custom_item' );
if ( ! function_exists( 'nk_portfolio_custom_item' ) ) :
    function nk_portfolio_custom_item( $atts, $content = null ) {

    }
endif;

// each portfolio item shortcode (ID of portfolio item)
nk_theme()->reg_shortcode( 'nk_portfolio_item', 'nk_portfolio_item' );
if ( ! function_exists( 'nk_portfolio_item' ) ) :
    function nk_portfolio_item( $atts, $content = null ) {

    }
endif;

add_action( 'init', 'vc_nk_portfolio_custom_list' );
if ( ! function_exists( 'vc_nk_portfolio_custom_list' ) ) :
    function vc_nk_portfolio_custom_list() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Portfolio Custom List', 'piroll-shortcodes' ),
                    'base' => 'nk_portfolio_custom_list',
                    'controls' => 'full',
                    'category' => 'nK',
                    'is_container' => true,
                    'js_view' => 'VcColumnView',
                    'icon' => 'icon-nk icon-nk-posts-list',
                    'as_parent' => array(
                        'only' => 'nk_portfolio_custom_item,nk_portfolio_item',
                    ),
                    'params' => array_merge(
                        array(
                            /**
                             * General
                             */
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Style', 'piroll-shortcodes' ),
                                'param_name' => 'style',
                                'value' => array(
                                    esc_html__( 'Masonry 1 Column Style 1', 'piroll-shortcodes' ) => 'masonry_1_style_1',
                                    esc_html__( 'Masonry 2 Columns Style 1', 'piroll-shortcodes' ) => 'masonry_2_style_1',
                                    esc_html__( 'Masonry 2 Columns Style 2', 'piroll-shortcodes' ) => 'masonry_2_style_2',
                                    esc_html__( 'Masonry 2 Columns Style 3', 'piroll-shortcodes' ) => 'masonry_2_style_3',
                                    esc_html__( 'Masonry 3 Columns Style 1', 'piroll-shortcodes' ) => 'masonry_3_style_1',
                                    esc_html__( 'Masonry 3 Columns Style 2', 'piroll-shortcodes' ) => 'masonry_3_style_2',
                                    esc_html__( 'Masonry 3 Columns Style 3', 'piroll-shortcodes' ) => 'masonry_3_style_3',
                                    esc_html__( 'Masonry 3 Columns Style 4', 'piroll-shortcodes' ) => 'masonry_3_style_4',
                                    esc_html__( 'Masonry 3 Columns Metro 1', 'piroll-shortcodes' ) => 'masonry_3_metro_1',
                                    esc_html__( 'Masonry 3 Columns Metro 2', 'piroll-shortcodes' ) => 'masonry_3_metro_2',
                                    esc_html__( 'Masonry 4 Columns Style 1', 'piroll-shortcodes' ) => 'masonry_4_style_1',
                                    esc_html__( 'Masonry 4 Columns Style 2', 'piroll-shortcodes' ) => 'masonry_4_style_2',
                                    esc_html__( 'Masonry 4 Columns Metro 1', 'piroll-shortcodes' ) => 'masonry_4_metro_1',
                                    esc_html__( 'Masonry 4 Columns Metro 2', 'piroll-shortcodes' ) => 'masonry_4_metro_2',
                                ),
                                'std' => 'masonry_3_style_1',
                                'description' => '',
                            ),
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Items Gap', 'piroll-shortcodes' ),
                                'param_name' => 'items_gap',
                                'value' => array(
                                    esc_html__( 'Disabled', 'piroll-shortcodes' ) => 'disabled',
                                    esc_html__( 'Small', 'piroll-shortcodes' ) => 'small',
                                    esc_html__( 'Mid', 'piroll-shortcodes' ) => 'mid',
                                    esc_html__( 'Big', 'piroll-shortcodes' ) => 'big',
                                ),
                                'std' => 'disabled',
                                'description' => '',
                            ),
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Items Hover Style', 'piroll-shortcodes' ),
                                'param_name' => 'items_hover_style',
                                'value' => array(
                                    esc_html__( 'Style 1 text on left bottom', 'piroll-shortcodes' ) => '1_left_bottom',
                                    esc_html__( 'Style 1 text on right bottom', 'piroll-shortcodes' ) => '1_right_bottom',
                                    esc_html__( 'Style 1 text on right top', 'piroll-shortcodes' ) => '1_right_top',
                                    esc_html__( 'Style 1 text on left top', 'piroll-shortcodes' ) => '1_left_top',
                                    esc_html__( 'Style 1 text on center', 'piroll-shortcodes' ) => '1_center',
                                    esc_html__( 'Style 1 text on left', 'piroll-shortcodes' ) => '1_left',
                                    esc_html__( 'Style 1 text on right', 'piroll-shortcodes' ) => '1_right',
                                    esc_html__( 'Style 1 text on top', 'piroll-shortcodes' ) => '1_top',
                                    esc_html__( 'Style 1 text on bottom', 'piroll-shortcodes' ) => '1_bottom',
                                    esc_html__( 'Style 2 text on left bottom', 'piroll-shortcodes' ) => '2_left_bottom',
                                    esc_html__( 'Style 2 text on right bottom', 'piroll-shortcodes' ) => '2_right_bottom',
                                    esc_html__( 'Style 2 text on right top', 'piroll-shortcodes' ) => '2_right_top',
                                    esc_html__( 'Style 2 text on left top', 'piroll-shortcodes' ) => '2_left_top',
                                    esc_html__( 'Style 2 text on center', 'piroll-shortcodes' ) => '2_center',
                                    esc_html__( 'Style 2 text on left', 'piroll-shortcodes' ) => '2_left',
                                    esc_html__( 'Style 2 text on right', 'piroll-shortcodes' ) => '2_right',
                                    esc_html__( 'Style 2 text on top', 'piroll-shortcodes' ) => '2_top',
                                    esc_html__( 'Style 2 text on bottom', 'piroll-shortcodes' ) => '2_bottom',
                                    esc_html__( 'Style 3 text on left', 'piroll-shortcodes' ) => '3_left',
                                    esc_html__( 'Style 3 text on center', 'piroll-shortcodes' ) => '3_center',
                                    esc_html__( 'Style 3 text on right', 'piroll-shortcodes' ) => '3_right',
                                    esc_html__( 'None', 'piroll-shortcodes' ) => 'none',
                                ),
                                'std' => '1_left_bottom',
                                'description' => '',
                            ),

                            array(
                                'type'        => 'colorpicker',
                                'param_name'  => 'items_1_hover_background',
                                'heading' => esc_html__( 'Items Hover Background Color', 'piroll-shortcodes' ),
                                'value'       => 'rgba(0,0,0,.85)',
                                'dependency' => array(
                                    'element'    => 'items_hover_style',
                                    'value'      => array( '1_left_bottom', '1_right_bottom', '1_right_top', '1_left_top', '1_center', '1_left', '1_right', '1_top', '1_bottom' ),
                                ),
                            ),
                            array(
                                'type'        => 'colorpicker',
                                'param_name'  => 'items_1_hover_color',
                                'heading' => esc_html__( 'Items Hover Color', 'piroll-shortcodes' ),
                                'value'       => '#fff',
                                'dependency' => array(
                                    'element'    => 'items_hover_style',
                                    'value'      => array( '1_left_bottom', '1_right_bottom', '1_right_top', '1_left_top', '1_center', '1_left', '1_right', '1_top', '1_bottom' ),
                                ),
                            ),
                            array(
                                'type'        => 'colorpicker',
                                'param_name'  => 'items_2_background',
                                'heading' => esc_html__( 'Items Background Color', 'piroll-shortcodes' ),
                                'value'       => 'rgba(0,0,0,.6)',
                                'dependency' => array(
                                    'element'    => 'items_hover_style',
                                    'value'      => array( '2_left_bottom', '2_right_bottom', '2_right_top', '2_left_top', '2_center', '2_left', '2_right', '2_top', '2_bottom' ),
                                ),
                            ),
                            array(
                                'type'        => 'colorpicker',
                                'param_name'  => 'items_2_hover_background',
                                'heading' => esc_html__( 'Items Hover Background Color', 'piroll-shortcodes' ),
                                'value'       => 'rgba(0,0,0,.85)',
                                'dependency' => array(
                                    'element'    => 'items_hover_style',
                                    'value'      => array( '2_left_bottom', '2_right_bottom', '2_right_top', '2_left_top', '2_center', '2_left', '2_right', '2_top', '2_bottom' ),
                                ),
                            ),
                            array(
                                'type'        => 'colorpicker',
                                'param_name'  => 'items_2_color',
                                'heading' => esc_html__( 'Items Color', 'piroll-shortcodes' ),
                                'value'       => '#fff',
                                'dependency' => array(
                                    'element'    => 'items_hover_style',
                                    'value'      => array( '2_left_bottom', '2_right_bottom', '2_right_top', '2_left_top', '2_center', '2_left', '2_right', '2_top', '2_bottom' ),
                                ),
                            ),
                            array(
                                'type'        => 'colorpicker',
                                'param_name'  => 'items_2_hover_color',
                                'heading' => esc_html__( 'Items Hover Color', 'piroll-shortcodes' ),
                                'value'       => '#fff',
                                'dependency' => array(
                                    'element'    => 'items_hover_style',
                                    'value'      => array( '2_left_bottom', '2_right_bottom', '2_right_top', '2_left_top', '2_center', '2_left', '2_right', '2_top', '2_bottom' ),
                                ),
                            ),
                            array(
                                'type'        => 'colorpicker',
                                'param_name'  => 'items_3_background',
                                'heading' => esc_html__( 'Items Background Color', 'piroll-shortcodes' ),
                                'value'       => '#fff',
                                'dependency' => array(
                                    'element'    => 'items_hover_style',
                                    'value'      => array( '3_center', '3_left', '3_right' ),
                                ),
                            ),
                            array(
                                'type'        => 'colorpicker',
                                'param_name'  => 'items_3_color',
                                'heading' => esc_html__( 'Items Color', 'piroll-shortcodes' ),
                                'value'       => '#000',
                                'dependency' => array(
                                    'element'    => 'items_hover_style',
                                    'value'      => array( '3_center', '3_left', '3_right' ),
                                ),
                            ),

                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Items Click Action', 'piroll-shortcodes' ),
                                'param_name' => 'items_click_action',
                                'value' => array(
                                    esc_html__( 'Disabled', 'piroll-shortcodes' ) => 'disabled',
                                    esc_html__( 'Open Item Page', 'piroll-shortcodes' ) => 'page',
                                    esc_html__( 'Open Featured Image', 'piroll-shortcodes' ) => 'image',
                                ),
                                'std' => 'page',
                                'description' => '',
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => esc_html__( 'Click Target', 'piroll-shortcodes' ),
                                'param_name' => 'items_click_target',
                                'value' => '',
                                'dependency' => array(
                                    'element' => 'items_click_action',
                                    'value' => array( 'page' ),
                                ),
                            ),
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Items Description', 'piroll-shortcodes' ),
                                'param_name' => 'items_description',
                                'value' => array(
                                    esc_html__( 'Disabled', 'piroll-shortcodes' ) => 'disabled',
                                    esc_html__( 'Title + Category', 'piroll-shortcodes' ) => 'title',
                                    esc_html__( 'Custom Icon', 'piroll-shortcodes' ) => 'icon',
                                ),
                                'std' => 'title',
                                'description' => '',
                            ),
                            array(
                                'type' => 'iconpicker',
                                'heading' => esc_html__( 'Items Description Icon', 'piroll-shortcodes' ),
                                'param_name' => 'items_description_icon',
                                'value' => 'pe-7s-look',
                                'dependency' => array(
                                    'element' => 'items_description',
                                    'value' => array( 'icon' ),
                                ),
                            ),

                            array(
                                'type' => 'textfield',
                                'heading' => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name' => 'class',
                                'value' => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;


add_action( 'init', 'vc_nk_portfolio_custom_item' );
if ( ! function_exists( 'vc_nk_portfolio_custom_item' ) ) :
    function vc_nk_portfolio_custom_item() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name'             => esc_html__( 'nK Portfolio Custom Item', 'piroll-shortcodes' ),
                    'base'             => 'nk_portfolio_custom_item',
                    'category'         => 'nK',
                    'icon'             => 'icon-nk',
                    'as_child'         => array(
                        'only' => 'nk_portfolio_custom_list',
                    ),
                    'is_container'     => true,
                    'js_view' => 'VcColumnView',
                    'params'           => array_merge(
                        array(
                            array(
                                'type'        => 'checkbox',
                                'heading'     => esc_html__( 'No Hover Effect', 'piroll-shortcodes' ),
                                'param_name'  => 'no_hover',
                                'value'       => array(
                                    '' => true,
                                ),
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'URL', 'piroll-shortcodes' ),
                                'param_name'  => 'url',
                                'value'       => '',
                                'description' => '',
                                'admin_label' => true,
                            ),
                            array(
                                'type'        => 'attach_image',
                                'heading'     => esc_html__( 'Background Image', 'piroll-shortcodes' ),
                                'param_name'  => 'image',
                                'admin_label' => true,
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;


add_action( 'init', 'vc_nk_portfolio_item' );
if ( ! function_exists( 'vc_nk_portfolio_item' ) ) :
    function vc_nk_portfolio_item() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name'             => esc_html__( 'nK Portfolio Item', 'piroll-shortcodes' ),
                    'base'             => 'nk_portfolio_item',
                    'category'         => 'nK',
                    'icon'             => 'icon-nk',
                    'as_child'         => array(
                        'only' => 'nk_portfolio_custom_list',
                    ),
                    'params'           => array_merge(
                        array(
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Portfolio Item ID', 'piroll-shortcodes' ),
                                'param_name'  => 'item_id',
                                'value'       => '',
                                'description' => '',
                                'admin_label' => true,
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;


// extend vc controls
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_nk_portfolio_custom_list extends WPBakeryShortCodesContainer {

    }
}
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_nk_portfolio_custom_item extends WPBakeryShortCodesContainer {

    }
}
