<?php
/**
 * nK Portfolio List
 *
 * Example:
 * [nk_portfolio_fullscreen_slider post_type="post" ids="" exclude_ids="" custom_query="" taxonomies="" count="5" pagination="false"]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_portfolio_fullscreen_slider', 'nk_portfolio_fullscreen_slider' );

if ( ! function_exists( 'nk_portfolio_fullscreen_slider' ) ) :
    function nk_portfolio_fullscreen_slider( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'post_type' => 'default',
                    'taxonomies' => '',
                    'taxonomies_relation' => 'OR',
                    'ids' => '',
                    'custom_query' => '',
                    'exclude_ids' => '',
                    'orderby' => 'post_date',
                    'order' => 'DESC',
                    'count' => 5,
                    'class' => '',
                ), $atts
            )
        );

        /**
         * Set Up Query
         */
        $query_opts = array(
            'post_type' => 'portfolio',
            'showposts' => intval( $count ),
            'posts_per_page' => intval( $count ),
            'paged' => 0,
            'order' => $order,
        );

        // Order By
        switch ( $orderby ) {
            case 'title':
                $query_opts['orderby'] = 'title';
                break;

            case 'id':
                $query_opts['orderby'] = 'ID';
                break;

            case 'post__in':
                $query_opts['orderby'] = 'post__in';
                break;

            default:
                $query_opts['orderby'] = 'post_date';
                break;
        }

        // Exclude IDs
        $exclude_ids = explode( ',', $exclude_ids );
        if ( $exclude_ids ) {
            $query_opts['post__not_in'] = $exclude_ids;
        }

        // IDs
        if ( $post_type == 'ids' ) {
            $ids = explode( ',', $ids );
            $query_opts['post__in'] = $ids;
        } // Custom Query
        else if ( $post_type == 'custom_query' ) {
            $tmp_arr = array();
            parse_str( html_entity_decode( $custom_query ), $tmp_arr );
            $query_opts = array_merge( $query_opts, $tmp_arr );
        } else {
            // Taxonomies
            $taxonomies = $taxonomies ? explode( ',', $taxonomies ) : array();
            if ( ! empty( $taxonomies ) ) {
                $all_terms = piroll_get_portfolio_terms();
                $query_opts['tax_query'] = array(
                    'relation' => piroll_check( $taxonomies_relation ) ? $taxonomies_relation : 'OR',
                );
                foreach ( $taxonomies as $taxonomy ) {
                    $taxonomy_name = null;

                    foreach ( $all_terms as $term ) {
                        if ( $term['value'] == $taxonomy ) {
                            $taxonomy_name = $term['group'];
                            continue;
                        }
                    }

                    if ( $taxonomy_name ) {
                        $query_opts['tax_query'][] = array(
                            'taxonomy' => $taxonomy_name,
                            'field' => 'id',
                            'terms' => $taxonomy,
                        );
                    }
                }
            }
        }

        /**
         * Work with printing posts
         */

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        ob_start();
        ?>
        <div class="nk-fullpage-portfolio <?php echo esc_attr( $class ); ?>">
            <?php
            $nk_query = new WP_Query( $query_opts );

            $i = 0;
            while ( $nk_query->have_posts() ) :
                $nk_query->the_post();
                $attachment = piroll_get_attachment( get_post_thumbnail_id( get_the_ID() ), 'piroll_1920x1080' );
                $categories = get_the_terms( get_the_ID(), 'portfolio_category' );
                $categories_string = '';
                if ( $categories ) {
                    foreach ( $categories as $cat ) {
                        if ( $categories_string ) {
                            $categories_string .= ' / ';
                        }
                        $categories_string .= $cat->name;
                    }
                }
                $number = ++$i;
                if ( $number < 10 ) {
                    $number = '0' . $number;
                }
                $title = get_the_title();
                $letter = $title[0];
                ?>

                <div class="nk-fullpage-item" data-letter="<?php echo esc_attr( $letter ); ?>" data-number="<?php echo esc_attr( $number ); ?>">
                    <?php if ( isset( $attachment['src'] ) && ! empty( $attachment['src'] ) ) : ?>
                        <img src="<?php echo esc_url( $attachment['src'] ); ?>" alt="<?php echo esc_attr( $title ); ?>" class="nk-fullpage-image">
                    <?php endif; ?>
                    <div class="nk-fullpage-view-button">
                        <div class="container">
                            <a class="nk-btn-2" href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html__( 'View project', 'piroll-shortcodes' ); ?></a>
                        </div>
                    </div>
                    <div class="nk-fullpage-content">
                        <div class="container">
                            <div class="nk-fullpage-item-category">
                                <?php echo esc_html( $categories_string ); ?>
                            </div>
                            <h2 class="nk-fullpage-title display-4"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( $title ); ?></a></h2>
                        </div>
                    </div>
                </div>
                <?php
            endwhile;
            ?>
        </div>

        <?php
        wp_reset_postdata();

        $result = ob_get_contents();
        ob_end_clean();
        return $result;
    }
endif;


add_action( 'init', 'vc_nk_portfolio_fullscreen_slider' );
if ( ! function_exists( 'vc_nk_portfolio_fullscreen_slider' ) ) :
    function vc_nk_portfolio_fullscreen_slider() {
        // post types list
        $post_types_list = array(
            array( 'default', esc_html__( 'Default Portfolio List', 'piroll-shortcodes' ) ),
            array( 'custom_query', esc_html__( 'Custom Query', 'piroll-shortcodes' ) ),
            array( 'ids', esc_html__( 'List of IDs', 'piroll-shortcodes' ) ),
        );

        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Portfolio Fullscreen Slider', 'piroll-shortcodes' ),
                    'base' => 'nk_portfolio_fullscreen_slider',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon' => 'icon-nk icon-nk-posts-list',
                    'params' => array_merge(
                        array(
                            /**
                             * General
                             */
                            array(
                                'type' => 'textfield',
                                'heading' => esc_html__( 'Works Count', 'piroll-shortcodes' ),
                                'param_name' => 'count',
                                'value' => 5,
                                'description' => '',
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name' => 'class',
                                'value' => '',
                                'description' => '',
                            ),

                            /**
                             * Query
                             */
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Data source', 'piroll-shortcodes' ),
                                'group' => esc_html__( 'Query', 'piroll-shortcodes' ),
                                'param_name' => 'post_type',
                                'value' => $post_types_list,
                                'std' => 'default',
                                'description' => esc_html__( 'Select content type', 'piroll-shortcodes' ),
                            ),
                            array(
                                'type' => 'autocomplete',
                                'heading' => esc_html__( 'Narrow data source', 'piroll-shortcodes' ),
                                'group' => esc_html__( 'Query', 'piroll-shortcodes' ),
                                'param_name' => 'taxonomies',
                                'settings' => array(
                                    'multiple' => true,
                                    'min_length' => 1,
                                    'groups' => true,
                                    // In UI show results grouped by groups, default false
                                    'unique_values' => true,
                                    // In UI show results except selected. NB! You should manually check values in backend, default false
                                    'display_inline' => true,
                                    // In UI show results inline view, default false (each value in own line)
                                    'delay' => 100,
                                    // delay for search. default 500
                                    'auto_focus' => true,
                                    // auto focus input, default true
                                    'values' => piroll_get_portfolio_terms(),
                                ),
                                'description' => esc_html__( 'Enter categories, tags or custom taxonomies.', 'piroll-shortcodes' ),
                                'dependency' => array(
                                    'element' => 'post_type',
                                    'value_not_equal_to' => array(
                                        'ids',
                                        'custom_query',
                                    ),
                                ),
                            ),
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Data source relation', 'piroll-shortcodes' ),
                                'group' => esc_html__( 'Query', 'piroll-shortcodes' ),
                                'param_name' => 'taxonomies_relation',
                                'value' => array(
                                    'OR',
                                    'AND',
                                ),
                                'std' => 'OR',
                                'dependency' => array(
                                    'element' => 'post_type',
                                    'value_not_equal_to' => array(
                                        'ids',
                                        'custom_query',
                                    ),
                                ),
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => esc_html__( 'IDs', 'piroll-shortcodes' ),
                                'group' => esc_html__( 'Query', 'piroll-shortcodes' ),
                                'param_name' => 'ids',
                                'description' => esc_html__( 'Type here the posts, pages, etc. IDs you want to use separated by coma. ex: 23,24,25', 'piroll-shortcodes' ),
                                'dependency' => array(
                                    'element' => 'post_type',
                                    'value' => array( 'ids' ),
                                ),
                            ),
                            array(
                                'type' => 'textarea_safe',
                                'heading' => esc_html__( 'Custom Query', 'piroll-shortcodes' ),
                                'group' => esc_html__( 'Query', 'piroll-shortcodes' ),
                                'param_name' => 'custom_query',
                                'description' => sprintf( esc_html__( 'Build custom query according to %s.', 'piroll-shortcodes' ), "<a href='http://codex.wordpress.org/Function_Reference/query_posts'>WordPress Codex</a>" ),
                                'dependency' => array(
                                    'element' => 'post_type',
                                    'value' => array( 'custom_query' ),
                                ),
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => esc_html__( 'Exclude IDs', 'piroll-shortcodes' ),
                                'group' => esc_html__( 'Query', 'piroll-shortcodes' ),
                                'param_name' => 'exclude_ids',
                                'description' => esc_html__( 'Type here the posts, pages, etc. IDs you want to use separated by coma. ex: 23,24,25', 'piroll-shortcodes' ),
                            ),
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Order By', 'piroll-shortcodes' ),
                                'group' => esc_html__( 'Query', 'piroll-shortcodes' ),
                                'param_name' => 'orderby',
                                'value' => array(
                                    esc_html__( 'Date', 'piroll-shortcodes' ) => 'post_date',
                                    esc_html__( 'Title', 'piroll-shortcodes' ) => 'title',
                                    esc_html__( 'ID', 'piroll-shortcodes' ) => 'id',
                                    esc_html__( 'Post In', 'piroll-shortcodes' ) => 'post__in',
                                ),
                                'std' => 'post_date',
                            ),
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Order', 'piroll-shortcodes' ),
                                'group' => esc_html__( 'Query', 'piroll-shortcodes' ),
                                'param_name' => 'order',
                                'value' => array(
                                    'DESC',
                                    'ASC',
                                ),
                                'std' => 'DESC',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;
