<?php
/**
 * nK Progress
 *
 * Example:
 * [nk_progress title="Progress" value="25" size="xl"]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_progress', 'nk_progress' );

if ( ! function_exists( 'nk_progress' ) ) :
    function nk_progress( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'value' => '25',
                    'size' => '',
                    'class' => '',
                ), $atts
            )
        );
        $result = $attribute = '';

        $class .= ' nk-progress nk-count';
        if ( piroll_check( $size ) ) {
            $class .= ' nk-progress-' . $size;
        }

        if ( piroll_check( $value ) ) {
            $attribute = ' data-progress="' . esc_attr( $value ) . '"';
        }

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        $result .= '<div class="' . esc_attr( $class ) . '"' . $attribute . '>';
        if ( piroll_check( $title ) ) {
            $result .= '<div class="nk-progress-title">' . esc_html( $title ) . ' <span class="nk-progress-percent">' . esc_html( $value ) . '%</span></div>';
        }
        if ( piroll_check( $value ) ) {
            $result .= '<div class="nk-progress-line">';
            $result .= '<div style="width: ' . esc_attr( $value ) . '%;"></div>';
            $result .= '</div>';
        }
        $result .= '</div>';

        return $result;
    }
endif;


add_action( 'init', 'vc_nk_progress' );
if ( ! function_exists( 'vc_nk_progress' ) ) :
    function vc_nk_progress() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Progress', 'piroll-shortcodes' ),
                    'base' => 'nk_progress',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-progress',
                    'params' => array_merge(
                        array(
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Title', 'piroll-shortcodes' ),
                                'param_name'  => 'title',
                                'value'       => '',
                                'description' => '',
                                'admin_label' => true,
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Value', 'piroll-shortcodes' ),
                                'param_name'  => 'value',
                                'value'       => '25',
                                'description' => '',
                                'admin_label' => true,
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Size', 'piroll-shortcodes' ),
                                'param_name' => 'size',
                                'std'        => false,
                                'value'      => array(
                                    esc_html__( 'Extra Small', 'piroll-shortcodes' )  => 'xs',
                                    esc_html__( 'Small', 'piroll-shortcodes' )  => 'sm',
                                    esc_html__( 'Default', 'piroll-shortcodes' )  => '',
                                    esc_html__( 'Mid', 'piroll-shortcodes' )  => 'md',
                                    esc_html__( 'Large', 'piroll-shortcodes' )  => 'lg',
                                    esc_html__( 'Extra Large', 'piroll-shortcodes' )  => 'xlg',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;
