<?php
/**
 * nK Testimonial
 *
 * Example:
 * [nk_testimonial user_name="John" text="Lorem Text"]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_testimonial', 'nk_testimonial' );

if ( ! function_exists( 'nk_testimonial' ) ) :
    function nk_testimonial( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'user_name' => '',
                    'text' => '',
                    'class' => '',
                ), $atts
            )
        );

        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        return '<blockquote class="nk-blockquote-style-1 ' . esc_attr( $class ) . '">
                    <p>' . esc_html( $text ) . '</p>
                    <cite>' . esc_html( $user_name ) . '</cite>
                </blockquote>';
    }
endif;


add_action( 'init', 'vc_nk_testimonial' );
if ( ! function_exists( 'vc_nk_testimonial' ) ) :
    function vc_nk_testimonial() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Testimonial', 'piroll-shortcodes' ),
                    'base' => 'nk_testimonial',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-testimonial',
                    'params' => array_merge(
                        array(
                            array(
                                'type'        => 'textarea',
                                'heading'     => esc_html__( 'Text', 'piroll-shortcodes' ),
                                'param_name'  => 'text',
                                'value'       => '',
                                'description' => '',
                                'holder'      => 'div',
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'User Name', 'piroll-shortcodes' ),
                                'param_name'  => 'user_name',
                                'value'       => '',
                                'description' => '',
                                'admin_label' => true,
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;
