<?php
/**
 * nK Title
 *
 * Example:
 * [nk_title tag="h2" like="h2"]My Title[/nk_title]
 */
// Required plugin nK Themes Helper
if ( ! function_exists( 'nk_theme' ) ) {
    return;
}
nk_theme()->reg_shortcode( 'nk_title', 'nk_title' );

if ( ! function_exists( 'nk_title' ) ) :
    function nk_title( $atts, $content = null ) {
        extract(
            shortcode_atts(
                array(
                    'tag'       => 'h2',
                    'like'      => 'h2',
                    'style'     => false,
                    'align'      => 'left',
                    'class'     => '',
                ), $atts
            )
        );

        switch ( $tag ) {
            case 'h1':
            case 'h2':
            case 'h3':
            case 'h4':
            case 'h5':
            case 'h6':
                break;
            default:
                $tag = 'div';
                break;
        }

        switch ( $like ) {
            case false:
            case 'h1':
            case 'h3':
            case 'h4':
            case 'h5':
            case 'h6':
            case 'display-1':
            case 'display-2':
            case 'display-3':
            case 'display-4':
                break;
            case 'subtitle':
            case 'subtitle-2':
                $like = 'nk-' . $like;
                break;
            default:
                $like = 'h2';
                break;
        }
        if ( piroll_check( $style ) ) {
            $class .= ' nk-' . $style;
        }
        if ( piroll_check( $like ) ) {
            $class .= ' ' . $like;
        }
        if ( piroll_check( $align ) ) {
            $class .= ' text-xs-' . $align;
        }
        // additional classname for custom styles VC
        $class .= piroll_get_css_tab_class( $atts );

        return '<' . $tag . " class='" . esc_attr( $class ) . "'>" . do_shortcode( $content ) . '</' . $tag . '>';
    }
endif;


add_action( 'init', 'vc_nk_title' );
if ( ! function_exists( 'vc_nk_title' ) ) :
    function vc_nk_title() {
        if ( function_exists( 'vc_map' ) ) {
            /* Register shortcode with Visual Composer */
            vc_map(
                array(
                    'name' => esc_html__( 'nK Title', 'piroll-shortcodes' ),
                    'base' => 'nk_title',
                    'controls' => 'full',
                    'category' => 'nK',
                    'icon'     => 'icon-nk icon-nk-title',
                    'params' => array_merge(
                        array(
                            array(
                                'type'        => 'textarea_html',
                                'heading'     => esc_html__( 'Inner Text', 'piroll-shortcodes' ),
                                'param_name'  => 'content',
                                'holder'      => 'div',
                                'value'       => '',
                                'description' => '',
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Tag', 'piroll-shortcodes' ),
                                'param_name' => 'tag',
                                'std'        => 'h2',
                                'value'      => array(
                                    esc_html__( 'h1', 'piroll-shortcodes' )  => 'h1',
                                    esc_html__( 'h2', 'piroll-shortcodes' )  => 'h2',
                                    esc_html__( 'h3', 'piroll-shortcodes' )  => 'h3',
                                    esc_html__( 'h4', 'piroll-shortcodes' )  => 'h4',
                                    esc_html__( 'h5', 'piroll-shortcodes' )  => 'h5',
                                    esc_html__( 'h6', 'piroll-shortcodes' )  => 'h6',
                                    esc_html__( 'div', 'piroll-shortcodes' ) => 'div',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Looks Like', 'piroll-shortcodes' ),
                                'param_name' => 'like',
                                'std'        => false,
                                'value'      => array(
                                    esc_html__( 'disabled', 'piroll-shortcodes' )  => false,
                                    esc_html__( 'h1', 'piroll-shortcodes' )  => 'h1',
                                    esc_html__( 'h2', 'piroll-shortcodes' )  => 'h2',
                                    esc_html__( 'h3', 'piroll-shortcodes' )  => 'h3',
                                    esc_html__( 'h4', 'piroll-shortcodes' )  => 'h4',
                                    esc_html__( 'h5', 'piroll-shortcodes' )  => 'h5',
                                    esc_html__( 'h6', 'piroll-shortcodes' )  => 'h6',
                                    esc_html__( 'display-1', 'piroll-shortcodes' )  => 'display-1',
                                    esc_html__( 'display-2', 'piroll-shortcodes' )  => 'display-2',
                                    esc_html__( 'display-3', 'piroll-shortcodes' )  => 'display-3',
                                    esc_html__( 'display-4', 'piroll-shortcodes' )  => 'display-4',
                                    esc_html__( 'Subtitle', 'piroll-shortcodes' )  => 'subtitle',
                                    esc_html__( 'Subtitle Style 2', 'piroll-shortcodes' )  => 'subtitle-2',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Style', 'piroll-shortcodes' ),
                                'param_name' => 'style',
                                'std'        => false,
                                'value'      => array(
                                    esc_html__( 'disabled', 'piroll-shortcodes' )  => false,
                                    esc_html__( 'Title', 'piroll-shortcodes' )  => 'title',
                                    esc_html__( 'Sub Title', 'piroll-shortcodes' )  => 'sub-title',
                                    esc_html__( 'Title Back', 'piroll-shortcodes' )  => 'title-back',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'       => 'dropdown',
                                'heading'    => esc_html__( 'Align', 'piroll-shortcodes' ),
                                'param_name' => 'align',
                                'std'        => 'left',
                                'value'      => array(
                                    esc_html__( 'Left', 'piroll-shortcodes' )  => 'left',
                                    esc_html__( 'Right', 'piroll-shortcodes' )  => 'right',
                                    esc_html__( 'Center', 'piroll-shortcodes' )  => 'center',
                                ),
                                'description' => '',
                            ),
                            array(
                                'type'        => 'textfield',
                                'heading'     => esc_html__( 'Custom Classes', 'piroll-shortcodes' ),
                                'param_name'  => 'class',
                                'value'       => '',
                                'description' => '',
                            ),
                        ), piroll_get_css_tab()
                    ),
                )
            );
        }
    }
endif;
